package com.aote.plugins.impexp;

import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.module.ModuleMapper;
import com.aote.plugins.impexp.exportfile.IExportFile;
import com.aote.plugins.impexp.importfile.IDataAnaly;
import com.aote.plugins.impexp.importfile.JSONConfigAnaly;
import com.aote.rs.mapper.WebException;
import org.apache.http.HttpEntity;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import com.aote.util.ExcelUtil;
public class FileManager {

	/**
	 * 对应的spring上下文，用于测试时，从外面传入
	 */
	public  ApplicationContext assingedContext = null;

	/**
	 * 从文件读取数据
	 * @param filepath 读取数据时的文件路径
	 * @param configName 处理读取数据的配置路径名
	 * @return
	 */
	@SuppressWarnings("resource")
	public JSONArray read(String filepath, String configName) {
		// 拿到文件名
		InputStream is = null;
		try {
			filepath = filepath.replaceAll("\\\\", "/");
			// 构造请求Json数据
			String jsonString = "{\"filepath\":\""+filepath+"\"}";
			// 发送请求，通过服务拿文件信息
			HttpEntity httpEntity =RestTools.postHttpEntity("/rs/file/getUploadFile",new JSONObject(jsonString));
			is = httpEntity.getContent();
		} catch (FileNotFoundException e) {
			throw new WebException(500, filepath+"您所选的文件不存在!!!");
		} catch (IOException e) {
			e.printStackTrace();
		}
		filepath = filepath.replace("\\", "/");
		String fileName = filepath.split("/")[filepath.split("/").length - 1];

		List<String[]> data = null;
		if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
			try {
				data = ExcelUtil.readExcel(is, fileName);
			} catch (IOException e) {
				throw new WebException(500, "文件解析错误!!!");
			}
		} else {
			throw new WebException(500, "非excel文件暂时未作处理.如有需求,请联系开发人员!!!!");
		}
		return getBean(configName).analy(data);
	}

	/**
	 * 导出数据到文件
	 * @param condition 前台传过来的查询条件
	 * @param configName 导出bean需要的json格式的配置文件名
	 * @return
	 */
	public JSONArray export(String condition, String beanName, String configName) {
		try {
			return getExportBean(beanName).export(condition, configName);
		} catch (RuntimeException e) {
			throw e;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	private IDataAnaly getBean(String configName){
		//获取用户配置文件路径
		String userConfigFile = getUserConfig(configName);
		//模块中的路径
		Map<String, Map<String, String>> map= ModuleMapper.getMap();
		String configFilePath = null;
		for (String key : map.keySet()) {
			if(FileManager.class.getClassLoader().getResourceAsStream(key+"/impexp/imp/" + configName)!=null){
				configFilePath=key+"/impexp/imp/" + configName;
				break;
			}
		}
		map.toString();
		JSONConfigAnaly jca = new JSONConfigAnaly();
		if(userConfigFile!=null){
			jca.setJsonPath(userConfigFile);
		}else if(configFilePath!=null){
			jca.setJsonPath(configFilePath);
		}else{
			throw new WebException(404,"找不到配置: "+configName);
		}
		return (IDataAnaly)jca;
	}

	private String getUserConfig(String configName) {
		// 从线程变量里获取登录用户目录名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		// 看对应目录下有没有给定内容
		String path =dir + "/impexp/imp/" + configName;
		if (FileManager.class.getClassLoader().getResourceAsStream(path) == null) {
			return null;
		}
		return path;
	}

	/**
	 * 获取导出数据的bean
	 * @param name 导出数据的bean
	 * @return
	 */
	private IExportFile getExportBean(String name) {
		ApplicationContext wac;
		// 如果外面给了上下文，用外面传入的
		if (this.assingedContext != null) {
			wac = this.assingedContext;
		} else {
			wac = ContextLoader.getCurrentWebApplicationContext();
		}
		return (IExportFile) wac.getBean(name);
	}
}
