package com.af.plugins.sms;

import com.af.plugins.ConvertTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import com.aote.ThreadResource;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;

/**
 * 读取Properties配置文件
 */

public class PropertiesReaderPlugin {

	/**
	 * 根据key获取指定Properties配置文件的值
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return value
	 */
	public static String read(String propsName, String key) {
		try {
			return read(propsName,key,null);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 根据key获取指定Properties配置文件的值（UTF-8）
	 * 
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return value
	 */
	public static String readToUTF8(String propsName, String key) {
		String s = read(propsName, key);
		return ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
	}

	/**
	 * 根据key获取指定Properties配置文件的键值对
	 * 
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return key-value JSON
	 */
	public static JSONObject readTojson(String propsName, String key) {
		String s = read(propsName, key);
		return new JSONObject(ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8));
	}
	
	/**
	 * 根据key和参数获取指定Properties配置文件的值
	 * @param propsName  文件名
	 * @param key			键值对对应键
	 * @param param   需要加入的参数
	 * @return value
	 */
	public static String read(String propsName, String key, JSONObject param) {
		Properties props = new Properties();
		try {
			props.load(PropertiesReaderPlugin.class.getResourceAsStream("/" + propsName));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		String str = props.getProperty(key);
		if(param != null) {
			Set<String> set =  param.keySet();
			for (String paramStr : set) {
				String replaceString = "\\{"+paramStr+"}";
				str = str.replaceAll(replaceString, param.getString(paramStr));
			}
		}
		return str;
	}

	/**
	 * 根据key，指定模块名和参数获取物联网表配置文件的值
	 * @param key 配置文件的key
	 * @param moduleName 模块名
	 * @param param 需要加入的参数
	 * @return 对应的值
	 */
	public static String readWebMeter(String key,String moduleName,JSONObject param){
		Properties props = new Properties();
		InputStream proStream = PropertiesReaderPlugin.class.getResourceAsStream("/" + moduleName + "/webmeter.properties");
		if(proStream == null){
			return null;
		}
		InputStreamReader propertiesAsStream = new InputStreamReader(PropertiesReaderPlugin.class.getResourceAsStream("/" + moduleName + "/webmeter.properties"), StandardCharsets.UTF_8);
		try {
			props.load(propertiesAsStream);
		} catch (IOException e) {
			throw new IOTException(IOTExceptionCode.CONFIG_FAIL);
		}
		if(key != null){
			String str = props.getProperty(key);
			if(param != null) {
				Set<String> set =  param.keySet();
				for (String paramStr : set) {
					String replaceString = "\\{"+paramStr+"}";
					//如果传入的参数JSON中含有该参数的值，则直接替换{}内容
					if(!"null".equals(param.getString(paramStr))) {
						str = str.replaceAll(replaceString, param.getString(paramStr));
						//如果配置文件本身有该参数的值，则拿配置文件中该参数对应的值替换{}内容
					}else if(props.containsKey(paramStr)){
						str = str.replaceAll(replaceString, props.getProperty(paramStr));
						//如果在传入的参数JSON和配置文件本身都没有找到该参数的值，则传null字符串
					} else {
						str = str.replaceAll(replaceString, "null");
					}
				}
			}
			return str;
		} else {
			JSONObject params = new JSONObject();
			Set keys = props.keySet();
			for(Object k : keys){
				String keyStr = k.toString();
				String value = props.getProperty(keyStr);
				params.put(keyStr,value);
			}
			return params.toString();
		}
	}
}
