package com.af.plugins.onenet;

import com.af.plugins.ConvertTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import com.af.plugins.iot.WebMeterInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.Security;

/**
 * Onenet 基础工具类
 * @author Mr.river
 */
public class OnenetTools {
    /**
     * 解密移动平台回调数据消息
     *
     * @param encodeStr 待解密的回调数据
     * @return 解密的回调数据
     */
    public static JSONObject decodeCallBackData(String encodeStr) {
        //待解密的数据
        byte[] aes_msg = ConvertTools.base64Decode(encodeStr.getBytes(StandardCharsets.UTF_8));
        //EncodingAESKey，移动订阅时提供
        byte[] password = ConvertTools.base64Decode((WebMeterInfo.getString("onenetEncodingAESKey") + "=").getBytes(StandardCharsets.UTF_8));
        //解密后的数据
        byte[] plain_msg;
        try {
            plain_msg = decrypt(aes_msg, password);
        } catch (Exception e) {
            throw new IOTException(IOTExceptionCode.ONENET_DECODE_CALLBACK_FAIL);
        }
        String str = new String(plain_msg, StandardCharsets.UTF_8);
        //截取JSON数据
        return new JSONObject(str.substring(str.indexOf("{")));
    }

    /**
     * AES算法解密
     *
     * @param encrypted 待解密的数据
     * @param password  解密所需的密钥
     * @return 解密的数据
     */
    private static byte[] decrypt(byte[] encrypted, byte[] password) throws Exception {
        byte[] bs = new byte[16];
        System.arraycopy(password, 0, bs, 0, 16);
        IvParameterSpec zeroIv = new IvParameterSpec(bs);
        SecretKeySpec key = new SecretKeySpec(password, "AES");
        Security.addProvider(new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(Cipher.DECRYPT_MODE, key, zeroIv);
        return cipher.doFinal(encrypted);
    }
}
