package com.af.plugins.iot;

/**
 * IOT平台 通用错误码
 *
 * @author Mr.river
 */
public enum IOTExceptionCode {
    //平台鉴权异常
    AUTHENTICATION_FAIL(
            "E1",
            "平台鉴权失败",
            "请检查telecomAPIKey及telecomSecret是否配置正确"
    ),
    //物联网表配置文件异常
    CONFIG_FAIL(
            "E2",
            "获取物联网表模块配置文件失败",
            "请检查模块下是否包含webmeter.properties配置文件"
    ),
    //移动平台解密回调数据异常
    ONENET_DECODE_CALLBACK_FAIL(
            "E4",
            "解密回调数据失败",
            "请检查EncodingAESKey是否配置正确"
    ),
    //未找到物联网表模块异常
    MODULE_NOT_FIND_FAIL(
            "E5",
            "未找到此物联网表模块",
            "请检查物联网表模块名是否配置正确"
    );

    private String code;
    private String name;
    private String message;

    IOTExceptionCode(String code, String name, String message) {
        this.code = code;
        this.name = name;
        this.message = message;
    }


    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getMessage() {
        return message;
    }
}
