package com.af.plugins.iot;

import com.iotplatform.client.NorthApiException;

/**
 * IOT平台 通用异常类
 *
 * @author Mr.river
 */
public class IOTException extends RuntimeException {

    public IOTException(IOTExceptionCode iotExceptionCode) {
        super(
                getErrorMessage(
                        iotExceptionCode.getCode(),
                        iotExceptionCode.getName(),
                        iotExceptionCode.getMessage()
                )
        );
    }

    public IOTException(NorthApiException e) {
        super(
                getErrorMessage(
                        e.getError_code(),
                        e.getHttpStatusCode() + "请求异常",
                        e.getError_desc())
        );
    }

    private static String getErrorMessage(String code, String name, String message) {
        return "{错误码：" + code + "    描述：" + name + "    说明：" + message + "}";
    }
}
