package com.af.plugins.iot;

import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.*;
import com.iotplatform.client.invokeapi.DeviceManagement;

/**
 * 注册设备
 * @author Gear
 */
public class DeviceManagementTools {
	/**
	 * 注册设备
	 * @param nodeId 模组号，即IMEI
	 * @return device_id
	 */
    public String regDevice(String nodeId) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		RegDirectDeviceInDTO2 rddid = new RegDirectDeviceInDTO2();
		//15位IMEI号
        rddid.setNodeId(nodeId);
        rddid.setVerifyCode(nodeId);
        rddid.setTimeout(0);
        RegDirectDeviceOutDTO rddod;
        try {
            String authToken = AuthenticationTools.getAuthToken();
            rddod = dm.regDirectDevice(rddid, WebMeterInfo.getString("telecomAPIKey"), authToken);
        } catch (NorthApiException e) {
			String errorCode = e.getError_code();
        	if(errorCode.equals("100416") || errorCode.equals("100426")){
        		return "设备已被注册";
			}
            throw new IOTException(e);
        }
        return rddod.getDeviceId();
	}

	/**
	 * 修改设备信息
	 * @param deviceId device_id，设备ID
	 * @param name 设备名
	 * @return 执行结果
	 */
	public int modifyDeviceInfo(String deviceId, String name) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		ModifyDeviceInforInDTO mdiid = new ModifyDeviceInforInDTO();
        mdiid.setName(name);
		mdiid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
		mdiid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
		mdiid.setDeviceType(WebMeterInfo.getString("deviceType"));
		mdiid.setModel(WebMeterInfo.getString("meterModel"));
        mdiid.setProtocolType("CoAP");
        try {
			dm.modifyDeviceInfo(mdiid, deviceId,WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
			return 0;
		} catch (NorthApiException e) {
            throw new IOTException(e);
		}
	}

	/**
	 * 注销设备
	 * @param deviceId device_id，设备ID
	 * @return 执行结果
	 */
	public int cancelDevice(String deviceId){
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		try {
			String authToken = AuthenticationTools.getAuthToken();
			dm.deleteDirectDevice(deviceId,null,WebMeterInfo.getString("telecomAPIKey"), authToken);
			return 0;
		} catch (NorthApiException e) {
			String errorCode = e.getError_code();
			if(errorCode.equals("100403") || errorCode.equals("100418")){
				return 0;
			}
			throw new IOTException(e);
		}
	}
	
	public int queryDeviceStatus(String deviceId) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		try {
			QueryDeviceStatusOutDTO qdsod = dm.queryDeviceStatus(deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
		} catch (NorthApiException e) {
            throw new IOTException(e);
		}
	}
}













