package com.af.plugins.iot;

import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.AuthOutDTO;
import com.iotplatform.client.invokeapi.Authentication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 鉴权(线程安全)
 * @author Gear
 */
public class AuthenticationTools {
	private static Map<String,Long> stamp = new ConcurrentHashMap<>();
	private static Map<String,AuthOutDTO> aod = new ConcurrentHashMap<>();

	public static String getAuthToken(){
		long current = System.currentTimeMillis();
		String apiKey = WebMeterInfo.getString("telecomAPIKey");
		AuthOutDTO authOutDTO = aod.get(apiKey);
		Long stampValue = stamp.get(apiKey);
		if(authOutDTO != null && stampValue != null && (current - stampValue) < (1000 * 60 * 15)) {
	    	return authOutDTO.getAccessToken();
		} else {
			try {
				Authentication auth = new Authentication(NorthApiClientTools.getNorthApiClient());
				AuthOutDTO newAnthOutDTO = auth.getAuthToken();
				aod.put(apiKey,newAnthOutDTO);
				stamp.put(apiKey,System.currentTimeMillis());
				return newAnthOutDTO.getAccessToken();
			} catch (NorthApiException e) {
				throw new IOTException(IOTExceptionCode.AUTHENTICATION_FAIL);
			}
		}
	}
}
