package com.af.plugins;

import com.af.plugins.xq.AsyncTools;
import com.af.plugins.xq.DefaultAsyncTools;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;

/**
 * Logic工具类
 *
 * @author Mr.river
 *
 */
public class LogicTools {
    /**
     * 批处理Logic
     */
    public static void batchRunLogic(JSONArray batchArray /*待处理的数据集合*/,
                                          String serviceIP /*业务逻辑所在服务IP*/,
                                          String serviceName /*业务逻辑所在服务名*/,
                                          String servicePort /*业务逻辑所在服务端口*/,
                                          String logicName /*业务逻辑名称*/) throws Exception {
        batchRunLogic(batchArray,serviceIP,serviceName,servicePort,logicName,null);
    }

    /**
     * 批处理Logic(回调执行结果)
     */
    public static void batchRunLogic(JSONArray batchArray /*待处理的数据集合*/,
                                          String serviceIP /*业务逻辑所在服务IP*/,
                                          String serviceName /*业务逻辑所在服务名*/,
                                          String servicePort /*业务逻辑所在服务端口*/,
                                          String logicName /*业务逻辑名称*/,
                                          String callbackUrl /*回调进度地址*/) throws Exception {
        //待处理的数据集合长度
        int length = batchArray.length();
        //当前进度
        int index = 0;
        //遍历参数集
        Iterator<Object> iterator = batchArray.iterator();
        //如果端口为null
        if(servicePort == null){
            //获取当前服务的端口
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objectNames;
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            servicePort = objectNames.iterator().next().getKeyProperty("port");
        }
        //请求地址
        String url = "http://"+serviceIP+":"+servicePort+"/"+serviceName+"/rs/logic/"+logicName;
        //定义异步请求
        AsyncTools asyncTools;
        //定义回调标识
        boolean isCallBack = false;
        //如果有回调地址
        if(callbackUrl != null) {
            //重写回调方法，返回业务执行进度
            isCallBack = true;
            asyncTools = new AsyncTools() {
                @Override
                public void callBack(Boolean result, String httpCode, String response, String body) {
                    //返回当前执行进度
                    JSONObject progress = new JSONObject();
                    progress.put("currentProgress",index);
                    progress.put("total",length);
                    postAsync(callbackUrl,progress,false);
                }
            };
        } else {
            asyncTools = new DefaultAsyncTools();
        }
        while (iterator.hasNext()){
            //请求参数
            Object param = iterator.next();
            if(param instanceof JSONObject){
                asyncTools.postAsync(url,(JSONObject) param,isCallBack);
            } else {
                asyncTools.postAsync(url,(String) param,isCallBack);
            }
        }
    }
}
