/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.xq;

import com.aote.ThreadResource;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.AsyncRestTemplate;

public abstract class AsyncTools {
    public abstract void callBack(Boolean var1, String var2, String var3, String var4);

    public void postAsync(String path, Boolean isCallBack) {
        this.postAsync(path, "", "", isCallBack);
    }

    public void postAsync(String path, JSONObject value, Boolean isCallBack) {
        this.postAsync(path, value.toString(), "", isCallBack);
    }

    public void postAsync(String path, String value, Boolean isCallBack) {
        this.postAsync(path, value, "", isCallBack);
    }

    public void postAsync(String path, JSONObject value, JSONObject headers, Boolean isCallBack) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            if (!headers.has("Content-Type")) {
                headers.put("Content-Type", (Object)"application/json");
            }
            this.postAsync(path, value.toString(), headers.toString(), isCallBack);
        } else if (headers == null) {
            this.postAsync(path, "", "", isCallBack);
        } else {
            this.postAsync(path, "", headers.toString(), isCallBack);
        }
    }

    private void postAsync(String path, String value, String headerStr, Boolean isCallBack) {
        HttpHeaders httpHeaders = new HttpHeaders();
        AsyncTools.setHeaders(headerStr, httpHeaders);
        AsyncRestTemplate client = new AsyncRestTemplate();
        ListenableFuture listenableFuture = client.postForEntity(path, new HttpEntity((Object)value, (MultiValueMap)httpHeaders), String.class, new Object[0]);
        if (isCallBack.booleanValue()) {
            listenableFuture.addCallback(result -> {
                String httpCode = result.getStatusCode().toString();
                String response = result.getStatusCode().getReasonPhrase();
                String body = (String)result.getBody();
                this.callBack(true, httpCode, response, body);
            }, ex -> {
                String httpCode = ex.getMessage().substring(0, ex.getMessage().indexOf(" "));
                String response = ex.getMessage().substring(ex.getMessage().indexOf(" "));
                this.callBack(false, httpCode, response, null);
            });
        }
    }

    private static void setHeaders(String headersStr, HttpHeaders base) {
        String token = (String)ThreadResource.Token.get();
        if (token != null) {
            base.add("Token", token);
        }
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            for (String headerKey : headers.keySet()) {
                base.add(headerKey, headers.getString(headerKey));
            }
        }
    }
}

