/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_consumer;

import com.af.plugins.kafka.kafka_consumer.Worker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerHandler {
    private final KafkaConsumer<String, String> consumer;
    private ExecutorService executors;
    private Map<String, String> map = new HashMap<String, String>();

    public ConsumerHandler(String groupId, String topic) {
        this.readLogicUrl();
        Properties props = new Properties();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("src\\main\\java\\com\\af\\plugins\\kafka\\kafka_consumer\\kafka_consumer.properties"));
            props.load(bufferedReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        props.put("group.id", groupId);
        if (props.get("topicPartitionNumGroupid") != null) {
            props.remove("topicPartitionNumGroupid");
        }
        if (props.get("workerNum") != null) {
            props.remove("workerNum");
        }
        System.err.println(props.toString());
        this.consumer = new KafkaConsumer(props);
        this.consumer.subscribe(Arrays.asList(topic));
    }

    private void readLogicUrl() {
        String[] logicsCatalog;
        Properties properties = new Properties();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("src\\main\\java\\com\\af\\plugins\\kafka\\kafka_consumer\\logicCatalog.properties"));
            properties.load(bufferedReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String logicCatalog : logicsCatalog = properties.toString().substring(1, properties.toString().length() - 1).split(",")) {
            String[] logicURL = logicCatalog.split("=");
            this.map.put(logicURL[0], logicURL[1]);
        }
    }

    public void execute(int workerNum) {
        this.executors = new ThreadPoolExecutor(workerNum, workerNum, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());
        block0: while (true) {
            ConsumerRecords records = this.consumer.poll(Duration.ZERO);
            Iterator iterator = records.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                this.executors.submit(new Worker(record, this.map));
            }
            break;
        }
    }

    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.executors != null) {
            this.executors.shutdown();
        }
        try {
            if (!this.executors.awaitTermination(10L, TimeUnit.SECONDS)) {
                System.out.println("Timeout.... Ignore for this case");
            }
        }
        catch (InterruptedException ignored) {
            System.out.println("Other thread interrupted this shutdown, ignore for this case.");
            Thread.currentThread().interrupt();
        }
    }
}

