/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.iot.AuthenticationTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.NorthApiClientTools;
import com.af.plugins.iot.WebMeterInfo;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.ModifyDeviceInforInDTO;
import com.iotplatform.client.dto.QueryDeviceStatusOutDTO;
import com.iotplatform.client.dto.RegDirectDeviceInDTO2;
import com.iotplatform.client.dto.RegDirectDeviceOutDTO;
import com.iotplatform.client.invokeapi.DeviceManagement;

public class DeviceManagementTools {
    public String regDevice(String nodeId) {
        RegDirectDeviceOutDTO rddod;
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        RegDirectDeviceInDTO2 rddid = new RegDirectDeviceInDTO2();
        rddid.setNodeId(nodeId);
        rddid.setVerifyCode(nodeId);
        rddid.setTimeout(Integer.valueOf(0));
        try {
            String authToken = AuthenticationTools.getAuthToken();
            rddod = dm.regDirectDevice(rddid, WebMeterInfo.getString("telecomAPIKey"), authToken);
        }
        catch (NorthApiException e) {
            if (e.getError_code().equals("100416")) {
                return "\u8bbe\u5907\u5df2\u88ab\u6ce8\u518c";
            }
            throw new IOTException(e);
        }
        return rddod.getDeviceId();
    }

    public int modifyDeviceInfo(String deviceId, String name) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        ModifyDeviceInforInDTO mdiid = new ModifyDeviceInforInDTO();
        mdiid.setName(name);
        mdiid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
        mdiid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
        mdiid.setDeviceType(WebMeterInfo.getString("deviceType"));
        mdiid.setModel(WebMeterInfo.getString("meterModel"));
        mdiid.setProtocolType("CoAP");
        try {
            dm.modifyDeviceInfo(mdiid, deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }

    public int cancelDevice(String deviceId) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        try {
            String authToken = AuthenticationTools.getAuthToken();
            dm.deleteDirectDevice(deviceId, null, WebMeterInfo.getString("telecomAPIKey"), authToken);
            return 0;
        }
        catch (NorthApiException e) {
            if (e.getError_code().equals("100403")) {
                return 0;
            }
            throw new IOTException(e);
        }
    }

    public int queryDeviceStatus(String deviceId) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        try {
            QueryDeviceStatusOutDTO qdsod = dm.queryDeviceStatus(deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }
}

