/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTools {
    public static JSONObject remove(JSONObject colsToBeRemoved, JSONObject jo) {
        Set keySet1 = colsToBeRemoved.keySet();
        for (String s : keySet1) {
            jo.remove(s);
        }
        return jo;
    }

    public JSONObject add(JSONObject obj, String addLabel, Object addVale) {
        obj.put(addLabel, addVale);
        return obj;
    }

    public boolean isContains(JSONObject obj, String key) {
        return obj.has(key);
    }

    public JSONObject removeKey(JSONObject obj, String key) {
        obj.remove(key);
        return obj;
    }

    public boolean isNull(JSONObject obj, String key) {
        return obj.isNull(key);
    }

    public JSONObject convertToJson(String str) {
        return new JSONObject(str);
    }

    public static HashMap<String, Object> toHashMap(JSONObject object) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = String.valueOf(it.next());
            if (object.isNull(key)) {
                data.put(key, null);
                continue;
            }
            Object value = object.get(key);
            data.put(key, value);
        }
        return data;
    }

    public JSONArray findDiff(JSONObject jo1, JSONObject jo2) {
        JSONArray jsonArray = null;
        Set keySet1 = jo1.keySet();
        jsonArray = new JSONArray();
        for (String s : keySet1) {
            if (!this.isValueEquals(jo1, jo2, s)) continue;
            JSONObject jo = new JSONObject();
            jo.put("field", (Object)s);
            jo.put("newVal", jo1.get(s) == null ? null : jo1.get(s).toString());
            jo.put("oldVal", jo2.get(s) == null ? null : jo2.get(s).toString());
            jsonArray.put((Object)jo);
        }
        return jsonArray;
    }

    private boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
        if (jo1.isNull(s) && !jo2.isNull(s) || !jo1.isNull(s) && jo2.isNull(s)) {
            return false;
        }
        if (jo1.isNull(s) && "null".equals(jo2.get(s))) {
            return false;
        }
        if (jo1.get(s) instanceof Integer) {
            if (jo2.get(s) instanceof BigDecimal) {
                return new BigDecimal((Integer)jo1.get(s)).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            try {
                return new BigDecimal((Integer)jo1.get(s)).compareTo(new BigDecimal(Integer.valueOf(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof String) {
            if (jo2.get(s) instanceof String) {
                return !jo1.get(s).equals(jo2.get(s));
            }
            return false;
        }
        if (jo1.get(s) instanceof Double) {
            if (jo2.get(s) instanceof Integer) {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal((Integer)jo2.get(s))) != 0;
            }
            try {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal(Double.parseDouble(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return !jo2.get(s).equals(jo1.get(s));
    }

    public JSONArray packJson(JSONObject json, String pricetype) {
        JSONArray result = new JSONArray();
        if ("fixed".equals(pricetype)) {
            JSONObject value = new JSONObject();
            value.put("f_unitprice", (Object)json.getBigDecimal("f_unitprice"));
            result.put((Object)value);
        } else if ("mixed".equals(pricetype)) {
            JSONArray array = (JSONArray)json.get("detailprice");
            JSONObject obj = new JSONObject();
            obj.put("f_hybridprice1", (Object)array.getJSONObject(0).getBigDecimal("f_price"));
            obj.put("f_hybridprice2", (Object)array.getJSONObject(1).getBigDecimal("f_price"));
            obj.put("f_hybridprice1rate", (Object)array.getJSONObject(0).getBigDecimal("f_ratio"));
            result.put((Object)obj);
        } else if ("staired".equals(pricetype)) {
            JSONArray array = (JSONArray)json.get("detailprice");
            for (Object object : array) {
                JSONObject obj = new JSONObject();
                obj.put("price", (Object)((JSONObject)object).getBigDecimal("f_price"));
                obj.put("amount", (Object)((JSONObject)object).getBigDecimal("f_amount"));
                result.put((Object)obj);
            }
            Iterator obj = new JSONObject();
            obj.put("sumamount", json.get("sumamount"));
            result.put((Object)obj);
        }
        return result;
    }

    public static void main(String[] args) {
        String json = "{\"price\":\"1.1\",\"amount\":\"100\"}";
        JSONObject obj = new JSONObject(json);
        JsonTools tool = new JsonTools();
        tool.removeKey(obj, "amount");
        System.out.println(obj);
    }
}

