package com.aote.xyhf;

import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;

/**
 * 西银惠付支付工具类
 * @auther qinlong
 * @date 2020-04-17 9:43
 */
public class xyhfUtil {

    private static Logger log = Logger.getLogger(xyhfUtil.class);

    private static final String SUCCESS = "SUCCESS";
    private static final String ERROR = "ERROR";
    private static final String AUTH_CODE_INVALID = "AUTH_CODE_INVALID";
    private static final String USERPAYING = "USERPAYING";
    private static final String TRADE_ERROR = "TRADE_ERROR";
    private static final String REFUND = "REFUND";
    private static final String NOTPAY = "NOTPAY";
    private static final String CLOSED = "CLOSED";
    private static final String REVOKED = "REVOKED";
    private static final String PAYERROR = "PAYERROR";
    private static final String PARTREFUND = "PARTREFUND";


    public static final HashMap<String, String> errorMap = new HashMap();

    static {
        errorMap.put(SUCCESS, "支付成功");
        errorMap.put(ERROR, "支付失败");
        errorMap.put(AUTH_CODE_INVALID, "二维码已过期,请刷新再试");
        errorMap.put(USERPAYING, "等待客户验证密码");
        errorMap.put(TRADE_ERROR, "'暂无可用的支付方式,请绑定其它银行卡完成支付");
        errorMap.put(REFUND, "转入退款");
        errorMap.put(NOTPAY, "未支付");
        errorMap.put(CLOSED, "已关闭");
        errorMap.put(REVOKED, "已撤销");
        errorMap.put(PAYERROR, "支付失败");
        errorMap.put(PARTREFUND, "部分退款");
    }

    public static  String  getErrorMsg(String str){
        if(errorMap.containsKey(str)) {
            return errorMap.get(str).toString();
        }else {
            return "未知状态";
        }
    }

    public static String sign(JSONObject json, JSONObject config){
       try {
           return RSASignature.sign(json,config);
       }catch (Exception e){
           log.debug("signError："+ e.getMessage() );
           throw  new RuntimeException(e.getMessage());
       }
    }
    public static boolean check( JSONObject json,JSONObject config) {
        try {
            return RSASignature.check(json,config);
        } catch (Exception e) {
            log.debug("checkError："+ e.getMessage() );
            throw  new RuntimeException(e.getMessage());
        }
    }
    }
