package com.aote.xyhf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

import com.aote.util.ResourceHelper;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * 西安银行签名
 * @author long
 *
 */
public class RSASignature {


	static Logger log = Logger.getLogger(RSASignature.class);
	/** 
     * 签名算法 
     */
	public static final String SIGN_ALGORITHMS = "NONEwithRSA"; 

	
	//私钥签名
	 public static  String sign(JSONObject json,JSONObject config) throws Exception  {
		 String content = json2Query(json);
		 System.out.println("原始签名串："+content);

		 String secret = config.getString("OpenplAppsecret");
		 String content2 = HMACSHA256(content.getBytes("UTF-8"),secret.getBytes());
	        try   
	        {    
	        	String privateKey = loadPrivateKeyByFile(config.getString("privateKeyPath")).split("-----")[2];
	        	RSAPrivateKey priKey = loadPrivateKeyByStr(privateKey);   
	            java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);  
	            signature.initSign(priKey);  
	            signature.update( content2.getBytes());  
	            byte[] signed = signature.sign();  
	            return encodeBase64(signed);  
	        }  
	        catch (Exception e)   
	        {  
	            e.printStackTrace();  
	        }  
	        return null;  
	    }

	public static  String signTest(JSONObject json,String OpenplAppsecret,String path) throws Exception  {
		String content = json2Query(json);
		System.out.println("原始签名串："+content);

		String secret =OpenplAppsecret;
		String content2 = HMACSHA256(content.getBytes("UTF-8"),secret.getBytes());
		try
		{
			String privateKey = loadPrivateKeyByFile(path).split("-----")[2];
			RSAPrivateKey priKey = loadPrivateKeyByStr(privateKey);
			java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);
			signature.initSign(priKey);
			signature.update( content2.getBytes());
			byte[] signed = signature.sign();
			return encodeBase64(signed);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return null;
	}
	/**
	     * 私钥验签 
	     * @throws Exception 
	     *             解密过程中的异常信息 
	     */  
	    public static boolean check( JSONObject json,JSONObject config)
	            throws Exception {  
	    	boolean ischeck = false;
	    	String str = json2Query(json);
			String secret = config.getString("OpenplAppsecret");
	    	String content = HMACSHA256(str.getBytes("UTF-8"), secret.getBytes());
	    	String privateKey = loadPrivateKeyByFile(config.getString("privateKeyPath")).split("-----")[2];
	    	RSAPrivateKey priKey = loadPrivateKeyByStr(privateKey); 
        	String signature=json.getString("SIGNATURE");
	        Cipher cipher = null;  
	        try {
	            // 使用默认RSA  
	            cipher = Cipher.getInstance("RSA");
	            // cipher= Cipher.getInstance("RSA", new BouncyCastleProvider());
	            cipher.init(Cipher.DECRYPT_MODE, priKey);
	            byte[] output = cipher.doFinal(decodeBase64(signature));
	            String res = new String(output).toLowerCase();
	            if(content.equals(res)){
	            	ischeck = true;
	            }
	            System.out.println("私钥解密结果："+ischeck);
	        } catch (NoSuchAlgorithmException e) {  
	            throw new Exception("无此解密算法");  
	        } catch (NoSuchPaddingException e) {  
	            e.printStackTrace();  
	        } catch (InvalidKeyException e) {  
	            throw new Exception("解密私钥非法,请检查");  
	        } catch (IllegalBlockSizeException e) {  
	            throw new Exception("密文长度非法");  
	        } catch (BadPaddingException e) {  
	            throw new Exception("密文数据已损坏");  
	        } 
	        return ischeck;
	    }  
	/**
	 * HMACSHA256加密
	 * @param data
	 * @param key
	 * @return
	 */
	private static  String HMACSHA256(byte[] data, byte[] key) 
	{
		try  {
			SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
			Mac mac = Mac.getInstance("HmacSHA256");
			mac.init(signingKey);
			return byte2hex(mac.doFinal(data));
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		}
		return null;
	} 
	private static  String byte2hex(byte[] b) 
	{
		StringBuilder hs = new StringBuilder();
		String stmp;
		for (int n = 0; b!=null && n < b.length; n++) {
			stmp = Integer.toHexString(b[n] & 0XFF);
			if (stmp.length() == 1)
				hs.append('0');
			hs.append(stmp);
		}
		return hs.toString();
	}
	/**
	 * 读取私钥文件
	 * @return
	 * @throws Exception
	 */
	private static  String  loadPrivateKeyByFile(String privateKeyPath) throws Exception {
		try {

			String path = ResourceHelper.class.getResource("/keystore/" + privateKeyPath).getPath();
			BufferedReader br = new BufferedReader(new FileReader(
					path));
			String readLine = null;  
			StringBuilder sb = new StringBuilder();  
			while ((readLine = br.readLine()) != null) {  
				sb.append(readLine);  
			}  
			br.close();  
			return sb.toString();  
		} catch (IOException e) {  
			throw new Exception("私钥数据读取错误");  
		} catch (NullPointerException e) {  
			throw new Exception("私钥输入流为空");  
		}  
	}  
   /**
    * 获取私钥
    * @param privateKeyStr
    * @return
    * @throws Exception
    */
	private static  RSAPrivateKey loadPrivateKeyByStr(String privateKeyStr)  
	throws Exception {  
		try {  
			byte[] buffer = decodeBase64(privateKeyStr);  
			PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);  
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");  
			return (RSAPrivateKey) keyFactory.generatePrivate(keySpec);  
		} catch (NoSuchAlgorithmException e) {  
			throw new Exception("无此算法");  
		} catch (InvalidKeySpecException e) {  
			throw new Exception("私钥非法");  
		} catch (NullPointerException e) {  
			throw new Exception("私钥数据为空");  
		}  

	} 
	/**
	 * 将json格式的参数转成string签名串
	 * @param json
	 * @return
	 * @throws UnsupportedEncodingException 
	 */
	private static String json2Query(JSONObject json) throws UnsupportedEncodingException
	{
		StringBuilder sb = new StringBuilder();
		Iterator<String> it = json.keys();
		ArrayList<String> list=(ArrayList)IteratorUtils.toList(it);
		Collections.sort(list);
		for(String k:list){
			try {
				if("".equals(json.get(k).toString())||json.get(k)==JSONObject.NULL||json.get(k)==null){
					continue;
				}else{
					if("SIGNATURE".equals(k)){
						continue;
					}else{
					sb.append(k+ "=" + json.get(k).toString() + "&");
					}
				}
				
			} catch (JSONException e) {

				e.printStackTrace();
			} 
		}
		if (sb.length() > 0)
		{
			sb.deleteCharAt(sb.length()-1);
		}
		return sb.toString();
	}
	/**
	 * 将获取到的签名串转成json
	 * @param query
	 * @return
	 */
	private  JSONObject Query2json(String query){
		String[] strs=query.split("&");
		JSONObject json = new JSONObject();
		try {
			for(String param:strs){
				String[] vk = param.split("=");
				json.put(vk[0], vk[1]);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return json;
	}

	private static String  getFilePath() {
		String path = ResourceHelper.class.getClassLoader().getResource("keystore").getPath();
		String res = path.substring(1);
		res=res.replace("%20"," ");
		return res;

	}
	/*** 
     * encode by Base64 
     */  
    public static String encodeBase64(byte[]input) throws Exception{  
        Class clazz=Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");  
        Method mainMethod= clazz.getMethod("encode", byte[].class);  
        mainMethod.setAccessible(true);  
         Object retObj=mainMethod.invoke(null, new Object[]{input});  
         return (String)retObj;  
    }  
    /*** 
     * decode by Base64 
     */  
    public static byte[] decodeBase64(String input) throws Exception{  
        Class clazz=Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");  
        Method mainMethod= clazz.getMethod("decode", String.class);  
        mainMethod.setAccessible(true);  
         Object retObj=mainMethod.invoke(null, input);  
         return (byte[])retObj;  
    } 

}
