package com.aote.xjccb_ronglian;

import com.aote.utils.BankFileUtil;
import com.aote.utils.HexStringUtil;
import com.aote.utils.MD5Util;
import com.aote.utils.PayUtil;
import org.apache.commons.collections.IteratorUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @auther qinlong
 * @date 2020-06-04 14:28
 */
public class XjCcbRLUtil {

    private static Logger log = Logger.getLogger(XjCcbRLUtil.class);

    public static JSONArray readBankFile(String filePath,String reg,String charSet,int startLine,int removeLastLine){
        JSONArray ja = BankFileUtil.readFiles(filePath,reg,charSet,startLine,removeLastLine);
        JSONArray datas = new JSONArray();
        for(int i=0;i<ja.length();i++){
            datas.put(strformatJson(ja.getJSONObject(i).getString("line")));
        }
        log.debug("jsonData:"+datas.toString());
        return datas;
    }

    public static JSONObject strformatJson(String str) {
        /**
         * 0用户编号|1用户名称|2支付流水号|3银行订单号 |4燃气方订单号(空值)|5支付时间|6支付金额|
         * 支付流水号: (对应t_weixinreturnxml中f_out_trade_no，收费记录f_serial_id/f_banksn）
         */
        JSONObject data = new JSONObject();
        String[] strs = str.split("\\|");
        data.put("f_user_id",strs[0]);
        data.put("f_user_name",strs[1]);
        data.put("f_serial_id",strs[2]);
        data.put("f_trade_number",strs[3]);
       try {
           SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
           String  date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(sdf.parse(strs[5]));
           data.put("f_trade_date",date);
       }catch (ParseException e){
           log.debug(e.getMessage());
       }
        data.put("f_total_charge",strs[6]);
        data.put("f_bankname","建设银行");
        data.put("f_unit","yuan");
        return data;
    }



    public static String encrypt(String data, String password) throws Exception
    {
        log.debug("使用des加密前的数据为："+data);
        byte[] datasource = data.getBytes("utf-8");
        SecureRandom random = new SecureRandom();
        DESKeySpec desKey = null;
        desKey = new DESKeySpec(password.getBytes());
        // 创建一个密匙工厂，然后用它把DESKeySpec转换成
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance("DES");
        // 用密匙初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, securekey, random);
        // 现在，获取数据并加密
        // 正式执行加密操作
        return HexStringUtil.bytetoHexString(cipher.doFinal(datasource)).toUpperCase();

    }
    /**
     * 解密
     *
     * @param
     * @param password
     *            String
     * @return byte[]
     * @throws Exception
     */
    public static String decrypt(String srcstr, String password)
            throws Exception {
        byte[] src = HexStringUtil.hexStringToByteArray(srcstr);
        // DES算法要求有一个可信任的随机数源
        SecureRandom random = new SecureRandom();
        // 创建一个DESKeySpec对象
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        // 创建一个密匙工厂
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        // 将DESKeySpec对象转换成SecretKey对象
        SecretKey securekey = keyFactory.generateSecret(desKey);
        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance("DES");
        // 用密匙初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, securekey, random);
        String result = new String(cipher.doFinal(src),"UTF-8");
        // 真正开始解密操作
        return result;
    }

    public static String json2Query(JSONObject json) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = json.keys();
        ArrayList<String> list=(ArrayList)IteratorUtils.toList(it);
        Collections.sort(list);
        for(String k:list){
            try {
                if("".equals(json.get(k).toString())||json.get(k)==JSONObject.NULL||json.get(k)==null){
                    continue;
                }else{
                    sb.append(k+ "=" + URLEncoder.encode(json.get(k).toString()) + "&");
                }
            } catch (JSONException e) {

                throw new RuntimeException(e);
            }
        }
        if (sb.length() > 0)
        {
            sb.deleteCharAt(sb.length()-1);
        }
        return sb.toString();
    }

    public static JSONObject post(JSONObject sendData,JSONObject config,String transcode){
        JSONObject json = new JSONObject();
        try{
//            String reqsn = config.getString("projectcode") + PayUtil.getNowDate("yyyyMMddHHmmss")
//                    + (new Random().nextInt(10000) + 10000);

            String encryptStr  = encrypt(sendData.toString(),config.getString("encrypt")) ;
            log.debug("加密数据："+encryptStr);
            json.put("projectcode",config.getString("projectcode"));
            json.put("data",encryptStr);
            json.put("transcode",transcode);
            String queryStr = json2Query(json);
            String sign =MD5Util.encode(queryStr+"&"+MD5Util.encode(config.getString("md5Key"),"UTF-8"),"UTF-8");
//            json.put("reqsn",reqsn);
            json.put("sign",sign);
            log.debug("请求数据:"+json.toString()+",url:"+config.getString("payUrl"));
            HttpPost hp = new HttpPost(config.getString("payUrl"));//配置文件里面的url对应的key为相对的通讯码
            hp.setHeader("Content-Type", "application/JSON");
            hp.setEntity(new StringEntity(json.toString(), "UTF-8"));
            HttpClient httpClient = new DefaultHttpClient();
            HttpResponse response = httpClient.execute(hp);

            int code = response.getStatusLine().getStatusCode();
            log.debug("状态码"+code);
            if (code == 200) {
                String result = EntityUtils.toString(response.getEntity(), "UTF-8");
                log.debug("返回数据:"+result);
                JSONObject ret = new JSONObject(result);
                if(ret.get("states").equals("1")){
                    String data = decrypt(ret.getString("data"),config.getString("encrypt"));
                    log.debug("解密data:"+data);
                    JSONObject dataJ = new JSONObject(data);
                    ret.put("data",dataJ);
                }
                ret.put("code",200);
                return ret;
            }else {
                return new JSONObject("{\"code\": "+code+",\"msg\":\"请求失败\"}");
            }
        }catch (Exception e){

            return new JSONObject("{\"code\":500,\"msg\":\""+e.getMessage()+"\"}");
        }
    }
}
