package com.aote.wft;

import com.aote.utils.SHA256withRSAUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.aote.utils.MD5Util;
import com.aote.utils.PayUtil;
import com.aote.utils.SSLClient;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class WftPlugins {

	static Logger log = Logger.getLogger(WftPlugins.class);

	private static final String SUCCESS = "SUCCESS";
	private static final String REFUND = "REFUND";
	private static final String NOTPAY = "NOTPAY";
	private static final String CLOSED = "CLOSED";
	private static final String REVERSE = "REVERSE";
	private static final String REVOK = "REVOK";
	private static final String PAYERROR = "PAYERROR";

	public static final HashMap<String, String> errorMap = new HashMap();

	static {
		errorMap.put(SUCCESS, "支付成功");
		errorMap.put(REFUND, "转入退款");
		errorMap.put(NOTPAY, "未支付");
		errorMap.put(CLOSED, "已关闭");
		errorMap.put(REVERSE, "已冲正");
		errorMap.put(REVOK, "已撤销");
		errorMap.put(PAYERROR, "支付失败");
	}

	public static  String  getErrorMsg(String str){
		if(errorMap.containsKey(str)) {
			return errorMap.get(str).toString();
		}else {
			return "未知状态";
		}
	}

	public static JSONObject toReturnData(JSONObject json){
		return WftReturnData.toReturnData(json);
	}

	public static String sign(JSONObject json,JSONObject config){
		if("RSA_1_256".equals(config.getString("signType"))){
			json.put("sign_type","RSA_1_256");
			return SHA256withRSAUtil.sign(PayUtil.json2Query(json),config.getString("privateKey"),false);
		}else {
			return MD5Util.sign(PayUtil.json2Query(json), "&key=" +  config.get("secretKey").toString(), "utf-8");
		}
	}
	/**
	 * 威富通验签
	 * @param json
	 * @param key
	 * @return
	 */
	 public static boolean checkParam(JSONObject json,JSONObject config){
		boolean result = false;
		 String sign = "";
		if(json.has("sign")){
			sign = json.getString("sign");
			json.remove("sign");
		}else if(json.has("SIGNATURE")){
			sign = json.getString("SIGNATURE");
			json.remove("SIGNATURE");
		}else {
			return false;
		}
		String preStr = PayUtil.json2Query(json);
		if("RSA_1_256".equals(config.getString("signType"))){
			result =SHA256withRSAUtil.verifySign(preStr,sign,config.getString("publicKey"));

		}else {
			String signRecieve = MD5Util.sign(preStr, "&key=" + config.get("secretKey").toString(), "utf-8");
			result = sign.equalsIgnoreCase(signRecieve);
		}
		return result;
	    }


	 /**
	  * 威富通发送请求
	  * @param seandData
	  * @param url
	  * @return
	  */
	public static JSONObject post (JSONObject seandData,String url){
		try {
			HttpClient httpclient = new SSLClient();
			HttpPost postRequest = new HttpPost(url);//
			postRequest.setEntity(new StringEntity(XmlUtils.toXml(seandData), "UTF-8"));
			HttpResponse httpResponse = httpclient.execute(postRequest);
			
			int StatusCode = httpResponse.getStatusLine().getStatusCode();
			if (StatusCode != 200) {//
				throw new RuntimeException("威富通平台连接错误，错误代码:" + StatusCode);
			}
			HttpEntity entity = httpResponse.getEntity();
			String rs = EntityUtils.toString(entity, "UTF-8");
			JSONObject result = XmlUtils.toJson(rs.getBytes("UTF-8"),"UTF-8");
			return result;
		}catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 *
	 * 威富通查询结果
	 * @param data
	 * @return
	 */
	public JSONObject queryResult(JSONObject data){
		boolean check  = false;
		JSONObject result =  new JSONObject();
			/**
			 * SUCCESS—支付成功;REFUND—转入退款;NOTPAY—未支付;CLOSED—已关闭;REVERSE—已冲正;REVOK—已撤销;PAYERROR—支付失败(其他原因，如银行返回失败)
			 */
		String trade_state = data.getString("trade_state").toUpperCase();
		if("SUCCESS".equals(trade_state))
		{
			result = WftReturnData.toReturnData(data);
			log.debug("result========>>"+result);
			result.put("code", 200);
			result.put("msg", getErrorMsg(trade_state));
			return result;
		}
		if("NOTPAY".equals(trade_state)||"PAYERROR".equals(trade_state)){
			result.put("code", 201);
			result.put("msg", getErrorMsg(trade_state));
			return result;
		}
		result.put("code", 500);
		result.put("msg", getErrorMsg(trade_state));

		return result;
	}
}
