package com.aote.utils;


import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

//解析Excel
public class readExcel {

    /**
     * 解压Zip文件
     * @param path 文件目录
     */
    public  void unZip(String path,String path2)
    {
//        long startTime=System.currentTimeMillis();
        try {
            ZipInputStream Zin=new ZipInputStream(new FileInputStream(path));//输入源zip路径
            BufferedInputStream Bin=new BufferedInputStream(Zin);
            String Parent=path2; //输出路径（文件夹目录）
            File Fout=null;
            ZipEntry entry;
            try {
                while((entry = Zin.getNextEntry())!=null && !entry.isDirectory()){
                    Fout=new File(Parent,entry.getName());
                    if(!Fout.exists()){
                        (new File(Fout.getParent())).mkdirs();
                    }
                    FileOutputStream out=new FileOutputStream(Fout);
                    BufferedOutputStream Bout=new BufferedOutputStream(out);
                    int b;
                    while((b=Bin.read())!=-1){
                        Bout.write(b);
                    }
                    Bout.close();
                    out.close();
                    System.out.println(Fout+"解压成功");
                }
                Bin.close();
                Zin.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
//        long endTime=System.currentTimeMillis();
//        System.out.println("耗费时间： "+(endTime-startTime)+" ms");
    }

    public JSONArray read( String fileName) throws Exception {
        JSONArray res=new JSONArray();
        try {
            //String encoding = "GBK";
            File excel = new File(fileName);
            if (excel.isFile() && excel.exists()) {   //判断文件是否存在

                Workbook wb;
                //根据文件后缀（xls/xlsx）进行判断
                if ( fileName.endsWith("xls")){
                    FileInputStream fis = new FileInputStream(excel);   //文件流对象
                    wb = new HSSFWorkbook(fis);
                }else if (fileName.endsWith("xlsx")){
                    wb = new XSSFWorkbook(excel);
                }else {
                    System.out.println("文件类型错误!");
                    return res;
                }

                //开始解析
                Sheet sheet = wb.getSheetAt(0);     //读取sheet 0

                int firstRowIndex = sheet.getFirstRowNum()+1;   //第一行是列名，所以不读
                int lastRowIndex = sheet.getLastRowNum();
                System.out.println("firstRowIndex: "+firstRowIndex);
                System.out.println("lastRowIndex: "+lastRowIndex);

                for(int rIndex = firstRowIndex; rIndex <= lastRowIndex; rIndex++) {   //遍历行
                  res.put(dataToJsonArray(sheet,rIndex));
                }
            } else {
                System.out.println("找不到指定的文件");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public JSONArray dataToJsonArray(Sheet sheet,int rIndex){

        Row row = sheet.getRow(rIndex);
        JSONArray ja=new JSONArray();
        if (row != null) {
            int firstCellIndex = row.getFirstCellNum();
            int lastCellIndex = row.getLastCellNum();
            for (int cIndex = firstCellIndex; cIndex < lastCellIndex; cIndex++) {   //遍历列
                Cell cell = row.getCell(cIndex);
                if (cell != null) {
                    ja.put(cell.toString());
                }else {
                    ja.put("");
                }
            }
        }
        return ja;
    }
    public JSONArray dataToJson(JSONArray param,JSONArray newparam,JSONArray data){
        JSONArray row=new JSONArray();
        JSONArray colname= (JSONArray) data.get(0);
        for (int i=1;i<data.length();i++){
            JSONObject jo=new JSONObject();
            JSONArray col= (JSONArray) data.get(i);
         for (int j=0;j<colname.length();j++){
             for(int t=0;t<param.length();t++){
                 if(colname.get(j).equals(param.get(t))){
                     jo.put(newparam.get(t).toString(),col.get(j));
                 }
             }
         }
         row.put(jo);

        }
        return row;
    }
}