package com.aote.utils;

import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class XhWeiGuanFeiUtil {

    static Logger log = Logger.getLogger(XhWeiGuanFeiUtil.class);

    public static JSONObject getWGF (String beginFee,Object f_feiweihufei ){
        JSONObject wgf = new JSONObject();
        String endFee = getEndFee(beginFee);
        int f_repairNum = getRepairNum(endFee,beginFee);
        log.debug("维管费年数：" + f_repairNum);
        double f_amountmaintenance = f_repairNum  * Double.parseDouble(f_feiweihufei.toString());
        int f_repairnumfei  =  f_repairNum * 12 ;
        String  f_beginfeehx  = getBeginfeehx(beginFee,f_repairnumfei);
        wgf.put("f_amountmaintenance",f_amountmaintenance );
        wgf.put("f_feiweihufei",Double.parseDouble(f_feiweihufei.toString()));
        wgf.put("f_beginfee",beginFee);
        wgf.put("f_endfee",endFee);
        wgf.put("f_repairnum",f_repairNum);
        wgf.put("f_beginfeehx",f_beginfeehx);
        log.debug("维管费计算结果：" + wgf.toString());
        return wgf;
    }

    public static String  getEndFee(String beginFee){

        try {
            if(beginFee == null || "".equals(beginFee)){
                return null;
            }
            Date nowdate = new Date();

            Calendar nowc = Calendar.getInstance();
            nowc.setTime(nowdate);

            Date begindate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(beginFee);

            Calendar beginc = Calendar.getInstance();
            beginc.setTime(begindate);
            long nowtime = nowdate.getTime();
            long begintime = begindate.getTime();
            if(nowtime <= begintime){
                return null;
            }

            long weihunians = nowtime > begintime ?
                    ((nowtime - begintime)/(60*60*24*1000))/365:0;

            int weihuyue =  nowc.get(Calendar.YEAR) == beginc.get(Calendar.YEAR) &&
                    beginc.get(Calendar.MONTH) > nowc.get(Calendar.MONTH) ? 0:1;

            int weihuheji = (int)((weihunians+weihuyue )*12 -1);
            log.debug("计算截止日期：weihunians-"+weihunians+",weihuyue-"+weihuyue+",weihuheji-" + weihuheji);
            beginc.add(Calendar.MONTH,weihuheji);
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beginc.getTime());

        } catch (ParseException e) {
            return null;
        }
    }
//    public static String getNowDate(){
//
//    }

    public static int getRepairNum(String EndFee,String beginFee){
        try{
            if(beginFee == null || "".equals(beginFee)){
                return 0;
            }
            if(EndFee == null || "".equals(EndFee)){
                return 0;
            }
            Date begindate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(beginFee);
            Calendar beginc = Calendar.getInstance();
            beginc.setTime(begindate);
            Date enddate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(EndFee);
            Calendar endc = Calendar.getInstance();
            endc.setTime(enddate);
            log.debug("subYears:"+(endc.get(Calendar.YEAR) - beginc.get(Calendar.YEAR)));
            log.debug("subMonth:"+(endc.get(Calendar.MONTH) - beginc.get(Calendar.MONTH)+1));
            int f_repairnum = ((endc.get(Calendar.YEAR) - beginc.get(Calendar.YEAR))*12
                    + (endc.get(Calendar.MONTH) - beginc.get(Calendar.MONTH)+1))/12;
            return f_repairnum;
        }catch(ParseException e){
            return 0;
        }
    }
    public static String getBeginfeehx(String beginFee,int f_repairnumfei){

        try{
            if(beginFee == null || "".equals(beginFee)){
                return beginFee;
            }
            Date begindate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(beginFee);
            Calendar beginc = Calendar.getInstance();
            beginc.setTime(begindate);
            beginc.add(Calendar.MONTH,f_repairnumfei);
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beginc.getTime());
        }catch(ParseException e){
            return beginFee;
        }
        // f_beginfeehx= userfiles.begenfee.toDate().addMonths(f_repairnumfei .toInt() )
    }



}
