package com.aote.utils;

import com.af.plugins.sms.PropertiesReaderPlugin;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @date 2020年4月14日21:35:40
 **/
@ServerEndpoint(value="/websocket/{f_terminal_num}")
@Component
@Transactional
public class WebSocket {


    private static int onlineCount=0;
    static Logger log = Logger.getLogger(WebSocket.class);
    private static ConcurrentHashMap<String, WebSocket> webSocketSet=new ConcurrentHashMap<String, WebSocket>();

    private Session session;
    private String local_url = PropertiesReaderPlugin.read("http.properties","local_url");
    //与某个客户端的连接会话，需要通过它来给客户端发送数据
    private Session WebSocketsession;
    private Boolean type = true;
    private String f_terminal_num = "";
    HttpPlugin http=new HttpPlugin();

  /**
   * 连接建立成功调用的方法
   *
   * @param session 可选的参数。session为与某个客户端的连接会话，需要通过它来给客户端发送数据
   */

  @OnOpen
  public void onOpen(@PathParam(value = "f_terminal_num") String f_terminal_num, Session session) {


        log.debug("终端号:"+f_terminal_num);
        this.session = session;
        this.f_terminal_num=f_terminal_num;
        webSocketSet.put(f_terminal_num,this);     //加入set中
        addOnlineCount();           //在线数加1
        System.out.println("有新连接加入！当前在线人数为" + getOnlineCount());
        String str="{data:{type:\'在线\',device:\'"+f_terminal_num+"\'}}";
        JSONObject jo=new JSONObject(str);
        try {
            http.post(local_url,jo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 连接关闭调用的方法
     */
    @OnClose
    public void onClose() throws Exception {

        if (!this.f_terminal_num.equals("")) {
            String str="{data:{type:\'离线\',device:\'"+f_terminal_num+"\'}}";
            JSONObject jo=new JSONObject(str);
            try {
                http.post(local_url,jo);
                webSocketSet.remove(this.f_terminal_num);  //从set中删除
                subOnlineCount();           //在线数减1
                System.out.println("有一连接关闭！当前在线人数为" + getOnlineCount());
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    /**
     * 收到客户端消息后调用的方法
     *
     * @param message 客户端发送过来的消息
     */
    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
//        System.out.println("来自客户端的消息:" + message);
        if(message.equals("123456")){
            this.sendMessage("心跳");
        }

    }
    //消息推送
    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }


    /**
      * 给指定的人发送消息
      * @param message
      */
    public void sendToUser(String sendUserno,String message) {


        try {
            if (webSocketSet.get(sendUserno) != null) {
                webSocketSet.get(sendUserno).sendMessage(message);
            } else {
               System.out.println("当前用户不在线");
            }
        } catch (IOException e) {
          e.printStackTrace();
        }
    }


  /**
  * 给所有人发消息
  * @param message
  */
  public void sendAll(String message) {

        //遍历HashMap
        for (WebSocket ws : webSocketSet.values()) {
        try {
        //判断接收用户是否是当前发消息的用户

            //当前发消息的人员编号
            String userno = "";
            if (!userno.equals(ws.f_terminal_num)) {
                ws.sendMessage(message);
                System.out.println("key = " + ws.f_terminal_num);
            }
        } catch (IOException e) {
         e.printStackTrace();
         }
       }
    }

    public JSONArray getDevice() {
        JSONArray jo=new JSONArray();
        for (String key : webSocketSet.keySet()) {
            jo.put(key);
        }
      return  jo;
    }

    private String getNowTime() {
        Date date = new Date();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = format.format(date);
        return time;
    }


    /**
     * 发生错误时调用
     */
    @OnError
    public void onError(Session session, Throwable error) {
        System.out.println(this.f_terminal_num+"发生错误");
        log.debug("终端:"+this.f_terminal_num+"发生错误");
        error.printStackTrace();
    }
    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        WebSocket.onlineCount++;
    }

    public static synchronized void subOnlineCount() {
        WebSocket.onlineCount--;
    }

}




