package com.aote.utils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.*;
import java.net.Socket;
import java.net.UnknownHostException;

public class  SocketClient {
        /**
         * ip
         */
  //      private static String ip = "10.223.199.30";
//        private static String ip = "127.0.0.1";

        /**
         * 主程序
         *
         *            参数
         * @throws IOException
         * @throws UnknownHostException
         */
        public static String testEnquire(String ip,String idstr, String str) {
            try {

                Socket socket = new Socket(ip,Integer.parseInt(idstr));
                OutputStream os = socket.getOutputStream();
                os.write(str.getBytes("UTF-8"));
                os.flush();
                byte[] bs = new byte[1000];
                int len = socket.getInputStream().read(bs);
                System.out.println(new String(bs, 0, len));
                return new String(bs, 0, len);

                // System.out.println(i+"==>"+new String(bs, 0, len));
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
//            return str;
        }

    public static String send(String ip,int port, String info) throws IOException {
        Socket socket = null;
        BufferedReader br = null;
        InputStream is = null;
        PrintWriter pw = null;
        OutputStream os = null;
        String result = "";
        try {
            //1.建立客户端socket连接，指定服务器位置及端口
            socket = new Socket(ip, port);
            //2.得到socket读写流
            os = socket.getOutputStream();
            pw = new PrintWriter(os);
            //输入流
            is = socket.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            //3.利用流按照一定的操作，对socket进行读写操作
            pw.write(info);
            pw.flush();
            socket.shutdownOutput();
            //接收服务器的相应
            String reply = null;
            while(!((reply=br.readLine())==null)){
                System.out.println("接收服务器的信息：" + reply);
                result += reply;
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            //4.关闭资源
            if(br != null){
                br.close();
            }
            if(is != null){
                is.close();
            }
            if(pw != null){
                pw.close();
            }
            if(os != null){
                os.close();
            }
            if(socket != null){
                socket.close();
            }
        }
        System.out.println("socket通讯返回：" + result);
        return result;
    }

    /**
     * 把数字转换成固定长度字符串,如果不够,前面补0
     */
    private static String toString(int num, int len) {
        String result = num + "";
        // 取得要添加的0的个数
        int n = len - result.length();
        for (int i = 0; i < n; i++) {
            result = "0" + result;
        }
        return result;
    }


    /**
     * 生成报文
     * str  传输数据
     */
    public static String GenerateMac(JSONArray str) {
        String msg="|";
         for(int i=0;i<str.length();i++){
             msg=msg+str.get(i).toString()+"|";
         }
         return msg;
    }
    /**
     * mac计算方式
     * str  原始串
     * mle mac长度
     */
    public static String getMac(String str, int mlen) {
        byte[] dt=str.getBytes();
        int n, k, len, ilen;
        // original input String length
        len = dt.length;
        // 原始串和mac长度的余数
        k = len % mlen;
        //
        n = mlen - k;
        ilen = len + n;
        byte[] bt = new byte[ilen];
        for (int i = 0; i < len; i++) {
            dt[i] = (byte) (dt[i] > 0x00 ? dt[i] : dt[i] + 256);
            bt[i] = dt[i];
        }
        bt[len] = 127;

        byte bo[] = new byte[mlen];
        for (int i = 0; i < ilen;) {
            for (int j = 0; j < mlen; j++) {
                bo[j] ^= bt[i];
                i++;
            }
        }

        for (int i = 0; i < mlen; i++) {
            // 如果遇到\r \n

            if ((bo[i] >= 0x00 ? bo[i] : bo[i] + 256) >= 0x80) { // "\r"
                bo[i] ^= 0x80;
            }

            if (bo[i] == 0x0d) { // "\r"
                bo[i] = 0x4d;
            }
            if (bo[i] == 0x0a) { // "\n"
                bo[i] = 0x4a;
            }
            if (bo[i] == 0x3a) { // ":"
                bo[i] = 0x7a;
            }
            if (bo[i] == 0x7c) { // "|"
                bo[i] = 0x3c;
            }
            if (bo[i] == 0x00) { // "0"
                bo[i] = 0x40;
            }

        }
        return new String(bo);
    }

    /**
     * 报文获取
     * str  原始串
     *
     */
    public static String getMessagec(String str) {
        String mac = getMac(str,8);
        str = str+mac;
        int len = str.length();
        if(len<10){
                str="000"+len+str;
        }
        if(len<100&&len>9){
            str="00"+len+str;
        }
        if(len<1000&&len>99){
            str="0"+len+str;
        }
        if(len<10000&&len>999){
            str=len+str;
        }
        return str;
    }

       /**
     * 获取交易代码
     * str  响应报文
     *
     */
    public JSONObject getTrasactionCode(String str) {
        String [] strarr=str.split("\\|");

        JSONObject code=new JSONObject();

        code.put("backdata",strarr);
        code.put("respCode",strarr[1]);
        code.put("respDesc",strarr[2]);
        return code;
    }
    /**
     * 生成清算文件
     * str  查询结果集
     * bankid 银行代码
     * transactionid  交易代码
     * nowdate  当前时间
     * paramresult 遍历字段
     */
    public JSONObject getSellinggasFile(JSONArray str,String bankid,int transactionid,String nowdate,JSONArray paramresult,String path) {
        JSONArray  ja=str;
        AccountUtil au=new AccountUtil();
       //保存的交易id
        int dealid=transactionid-1;
        //记录总数
        int l=ja.length();
        //记录内容
        String filecontent=l+"\n";
        if(l==0){
            filecontent=0+"\n";
        }else {
            for (int i = 0; i < l; i++) {
                JSONObject jo = new JSONObject(ja.get(i).toString());
                JSONArray costcontent = new JSONArray();
                costcontent.put(dealid);  //交易代码
                //循环读取并保存所需字段
                for (int j = 0; j < paramresult.length(); j++) {
                    if(paramresult.get(j).toString().equals("f_delivery_date")){
                        String date=jo.get(paramresult.get(j).toString()).toString().substring(0, 10).replace("-","");
                        String time=jo.get(paramresult.get(j).toString()).toString().substring(11, 19).replace(":","");
                        costcontent.put(date);
                        costcontent.put(time);
                    }else {
                        costcontent.put(jo.get((String) paramresult.get(j)));
                    }
                }
                //生成每条记录报文,并保存到文件字符串
                filecontent = filecontent + getMessagec(GenerateMac(costcontent)) + "\n";
            }
        }
        String date=nowdate.substring(0, 10).replace("-","");
        String time=nowdate.substring(11, 19).replace(":","");
        //清算文件名格式：交易代码（2003）.银行代码.日期(YYYYMMDD).时间(hhmmss)
        String filename = transactionid + "." + bankid + "." +date  + "." +time;
//        HttpServletRequest request = null;
//        String path=request.getSession().getServletContext().getRealPath("/");
//        path.replace(":\\","://");
//        path.replace("\\","/");

        JSONObject result=new JSONObject();
        try {
            au.writeFile(filecontent, path, filename);
            result.put("path",path+"/"+filename);
            result.put("filename",filename);
            return result;
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }
    //修改银证返回价格单价时间格式
    public String getdate(String str) {

        str = str.replaceAll("-","");
        return str;
    }


}
