package com.aote.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;


import com.aote.util.ResourceHelper;
/**
 * RSA公私钥
 * @author qinlong
 *
 * 2019年1月11日
 */
public class SHA256withRSAUtil {

	static Logger log = Logger.getLogger(SHA256withRSAUtil.class);

	public static  String loadKeyByFile(String file) {  
		try {  
			String path = ResourceHelper.class.getResource("/keystore").getPath() + File.separator +file ;
			BufferedReader br = new BufferedReader(new FileReader(path));
			String readLine = null;  
			StringBuilder sb = new StringBuilder();  
			while ((readLine = br.readLine()) != null) {  
				sb.append(readLine);  
			}  
			br.close();  
			return sb.toString();
		} catch (IOException e) {  
			throw new RuntimeException("密钥数据读取错误");  
		} catch (NullPointerException e) {  
			throw new RuntimeException("密钥输入流为空");  
		}  
	}
	/** 
	 * 签名算法 
	 */
	public static final String SIGN_ALGORITHMS = "SHA256withRSA"; 


	/**
	 * 私钥签名
	 */
	public static  String sign(String content,String path,boolean needsha256) {
		log.debug("原始签名串："+content);
		if(needsha256){
			content = SHA_256(content);
		}
		log.debug("SHA-256编码后-----》"+ content);
		try   
		{    
			RSAPrivateKey priKey = loadPrivateKeyByStr(loadKeyByFile(path));   
			Signature signature = Signature.getInstance(SIGN_ALGORITHMS);  
			signature.initSign(priKey);  
			signature.update( content.getBytes());
			byte[] signed = signature.sign();  
			return Base64Util.encode(signed);  
		}  
		catch (Exception e)   
		{  
			log.debug("签名异常"+e.getMessage());
			//	            e.printStackTrace();  
		}  
		return null;  
	} 


	/**
	 * SHA-256加密

	 * @return
	 */
	private static  String SHA_256(String plainText) 
	{
		MessageDigest messageDigest;
		try  {
			messageDigest = MessageDigest.getInstance("SHA-256");
			messageDigest.update(plainText.getBytes());
			byte[] outputDigest_sign = messageDigest.digest();
			
			return HexStringUtil.bytetoHexString(outputDigest_sign);
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("SHA-256编码异常"); 
		} 
	}


	public static boolean verifySign( String content, String sign, String path) {
		Signature signature = null;
		try {
			signature = Signature.getInstance("SHA256WithRSA");
			RSAPublicKey pubKey = loadpublicKeyByStr(loadKeyByFile(path));
			signature.initVerify(pubKey);

			signature.update(content.getBytes("utf-8"));
			return signature.verify(Base64.decodeBase64(sign.getBytes("UTF8")));
		} catch (Exception e) {
			// 一般不会出现
			throw new RuntimeException("签名格式不合法"+e.getMessage());
		}
	}
	/** 
	 * 私钥验签 
	 * @throws Exception 
	 *             解密过程中的异常信息 
	 */  
	public static boolean check(String content,String path,String signature,boolean needsha256)
			{
		boolean ischeck = false;
		if(needsha256){
			 content = SHA_256(content);
		}
		Cipher cipher = null;
		try {
			RSAPrivateKey priKey = loadPrivateKeyByStr(loadKeyByFile(path));
			// 使用默认RSA  
			cipher = Cipher.getInstance("RSA");
			// cipher= Cipher.getInstance("RSA", new BouncyCastleProvider());
			cipher.init(Cipher.DECRYPT_MODE, priKey);
			byte[] bytes = Base64Util.decode(signature);
			byte[] output = cipher.doFinal(Base64.decodeBase64(signature.getBytes("UTF-8")));
			String res = new String(output).toLowerCase();
			if(content.equals(res)){
				ischeck = true;
			}
			System.out.println("私钥解密结果："+ischeck);
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("无此解密算法");
		} catch (NoSuchPaddingException e) {
			throw new RuntimeException("无此解密算法");
		} catch (InvalidKeyException e) {
			throw new RuntimeException("解密私钥非法,请检查");
		} catch (IllegalBlockSizeException e) {
			throw new RuntimeException("密文长度非法");
		} catch (BadPaddingException e) {
			throw new RuntimeException("密文数据已损坏");
		} catch (UnsupportedEncodingException e){
			throw new RuntimeException("密文编码错误已损坏");
		}
		return ischeck;
	}
	/**
	 * 获取私钥
	 * @param privateKeyStr
	 * @return
	 * @throws Exception
	 */
	private static  RSAPrivateKey loadPrivateKeyByStr(String privateKeyStr)
	{
		try {
			byte[] buffer = Base64Util.decode(privateKeyStr);
			PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			return (RSAPrivateKey) keyFactory.generatePrivate(keySpec);
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("无此算法");
		} catch (InvalidKeySpecException e) {
			throw new RuntimeException("私钥非法");
		} catch (NullPointerException e) {
			throw new RuntimeException("私钥数据为空");
		}

	}
	/**
	 * 获取私钥
	 * @param publicKeyStr
	 * @return
	 * @throws Exception
	 */
	private static RSAPublicKey loadpublicKeyByStr(String publicKeyStr)
	{
		try {
			byte[] buffer = Base64Util.decode(publicKeyStr);
			X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			return (RSAPublicKey) keyFactory.generatePublic(keySpec);
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("无此算法");
		} catch (InvalidKeySpecException e) {
			throw new RuntimeException("私钥非法");
		} catch (NullPointerException e) {
			throw new RuntimeException("私钥数据为空");
		}

	}
}
