package com.aote.utils;



import com.aote.xjccb_ronglian.XjCcbRLUtil;
import com.jcraft.jsch.*;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import java.io.*;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/**
 * <p>
 *     Sftp工具类
 * </p>
 *
 * @author huqingniu
 * @version 1.0.0
 * @date 2018/12/24
 */
public class SFtpClient {

    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(XjCcbRLUtil.class);

//    private String userName;
//    private String password;
//    private int port;
//    private String hostName;
//    private String priKeyFile;
//    private String passphrase;



//
//    public SFtpClient(String userName, String password, int port, String hostName,
//                String priKeyFile, String passphrase) {
//        super();
//        this.userName = userName;
//        this.password = password;
//        this.port = port;
//        this.hostName = hostName;
//        this.priKeyFile = priKeyFile;
//        this.passphrase = passphrase;
//    }

    /**
     * 登陆sftp
     *
     * 认证方式
     * @return 登陆信息
     */
    private static Map<String,Object> loginIn(String userName, String password, int port, String hostName,
                                       String priKeyFile, String passphrase){
        //解决JSch日志打印问题
//        JSch.setLogger(new SettleJschLogPrint());

        try {
            ChannelSftp sftp = null;
            Session session = null;

            JSch jsch = new JSch();
            System.out.println("获取SFTP服务器连接username:{},host:{},port:{}"+userName+hostName+port);
            session = jsch.getSession(userName,hostName,port);
//            logger.info("连接成功建立");
            if(priKeyFile !=null && !"".equals(priKeyFile)){
                if(passphrase !=null && !"".equals(passphrase)){
                    jsch.addIdentity(priKeyFile, passphrase);
                }else{
                    jsch.addIdentity(priKeyFile);
                }
            }
            if(port >0){
                session=jsch.getSession(userName, hostName, port);
            }else{
                session=jsch.getSession(userName, hostName);
            }


            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking","no");
            sshConfig.put("PreferredAuthentications","publickey,gssapi-with-mic,keyboard-interactive,password");
            if (password != null) {
                session.setPassword(password);
            }
            session.setConfig(sshConfig);
            session.connect();
//            logger.info("用户" + username + "成功登陆");
            Channel channel = session.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp) channel;

            HashMap<String,Object> loginInfo = new HashMap<>();
            loginInfo.put("sftp",sftp);
            loginInfo.put("session",session);
            return loginInfo;
        } catch (JSchException e) {
            throw new RuntimeException("user login SFTP server occur exception:" + e);
        }
    }

    /**
     * 退出登陆
     *
     */
    private static void loginOut(  Session session,Channel channel){
        try {
            if(null != channel && channel.isConnected()){
                channel.disconnect();
            }
            if (null != session && session.isConnected()){
                session.disconnect();
            }
            log.info("关闭sftp" );
        } catch (Exception e) {
            log.warn("用户退出SFTP服务器出现异常:" + e);
        }
    }

    /**
     * 下载文件
     *
     * @param downloadFilePath 要下载的文件所在绝对路径
     * @param downloadFileName 要下载的文件名(sftp服务器上的文件名)
     * @param localPath 文件存放位置（文件所在绝对路径）
     *
     */
    public static int download(String userName, String password, int port, String hostName,
                         String priKeyFile, String passphrase,String downloadFilePath, String downloadFileName, String localPath) throws IOException {


        OutputStream outputStream = null;
        ChannelSftp sftp = null;
        Session session = null;
        try {
            File localFile = new File(localPath + "/" + downloadFileName);
            Map<String,Object> loginInfo = loginIn( userName,  password,  port,  hostName,priKeyFile,  passphrase);
            sftp = (ChannelSftp) loginInfo.get("sftp");
            session = (Session) loginInfo.get("session");

            log.info("待下载文件地址为:" + downloadFilePath + ",文件名为:" + downloadFileName + ",认证方式:");
            sftp.cd(downloadFilePath);
            sftp.ls(downloadFileName);
            outputStream = new FileOutputStream(localFile);
            String ss=  IOUtils.toString(sftp.get(downloadFileName), "utf-8");
            outputStream.write(Base64Util.decode(ss));
//            sftp.get(downloadFileName,outputStream);
            log.info("文件下载完成！");
            return 200;
        }catch (Exception e){
            return 500;
        }finally {
            if (null != outputStream){
                outputStream.close();
            }
            loginOut(session,sftp);
        }
    }

    /**
     * 上传文件
     *
     * @param uploadPath 上传SFTP完整路径
     * @param uploadFile 上传文件（完整路径）
     *
     */
    public static void upload(String userName, String password, int port, String hostName,
                       String priKeyFile, String passphrase,String uploadPath, String uploadFile) throws Exception{
        Assert.notNull(uploadPath,"upload path is not null");
        Assert.notNull(uploadFile,"upload file is not null");


        InputStream inputStream = null;
        ChannelSftp sftp = null;
        Session session = null;
        try {
            Map<String,Object> loginInfo = loginIn( userName,  password,  port,  hostName,priKeyFile,  passphrase);
            sftp = (ChannelSftp) loginInfo.get("sftp");
            session = (Session) loginInfo.get("session");

            log.info("待上传文件为:" + uploadFile + ",上传SFTP服务器路径:" + uploadPath );
            File file = new File(uploadFile);
            inputStream = new FileInputStream(file);
            try {
                sftp.cd(uploadPath);
            } catch (SftpException e) {
                log.error("SFTP器服务存放文件路径不存在");
                throw new RuntimeException("upload path is not exist");
            }
            sftp.put(inputStream,file.getName());
            log.info("上传文件成功！");
        } finally {
            if (null != inputStream){
                inputStream.close();
            }
            loginOut(session,sftp);
        }

    }


    /**
     * 在slf4j日志框架里打印JSch日志
     */
    class SettleJschLogPrint implements com.jcraft.jsch.Logger{

        @Override
        public boolean isEnabled(int i) {
            return true;
        }

        @Override
        public void log(int i, String s) {
            log.info(s);
        }
    }


    public JSONArray listfile(ChannelSftp sftp ) throws SftpException {

        JSONArray ret=new JSONArray();
        Vector<String> files = sftp.ls("*");
        for (int i = 0; i < files.size(); i++)
        {
            Object obj = files.elementAt(i);
            if (obj instanceof com.jcraft.jsch.ChannelSftp.LsEntry)
            {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry) obj;
                if (true && !entry.getAttrs().isDir())
                {
                    ret.put(entry.getFilename());
                }
                if (true && entry.getAttrs().isDir())
                {
                    if (!entry.getFilename().equals(".") && !entry.getFilename().equals(".."))
                    {
                        ret.put(entry.getFilename());
                    }
                }
            }
        }
        System.out.println(ret);
        return  ret;
    }
    public Vector<?> listFiles(ChannelSftp sftp,String directory) throws SftpException {
       return sftp.ls(directory);
    }

}
