package com.aote.utils;

import com.aote.util.ResourceHelper;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class PayUtil {

	static Logger log = Logger.getLogger(PayUtil.class);

	 /**
	  * 获取对应商户配置文件
	  * @param module
	  * @return
	  */
  public  static JSONObject getConfig(String module) {
  	String result = null;
		try {
			String path = ResourceHelper.class.getResource("/merch/" + module + "/config.json").getPath();
			path = java.net.URLDecoder.decode(path, "utf-8");
			log.debug(path);

			RandomAccessFile file = new RandomAccessFile(path, "r");
			byte[] b = new byte[(int) file.length()];
			file.read(b);
			file.close();
			result = new String(b, "UTF-8");
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
      return new JSONObject(result);
  }
  /**
	  * 获取不同pos对应的前台配置文件
	  * @param pos
	  * @return
	  */
 public  static JSONObject getPosConfig(String pos) {
 	String result = null;

		try {
			String path = ResourceHelper.class.getResource("/pos/" + pos + ".json").getPath();
			path = java.net.URLDecoder.decode(path, "utf-8");
			log.debug(path);
			RandomAccessFile file = new RandomAccessFile(path, "r");
			byte[] b = new byte[(int) file.length()];
			file.read(b);
			file.close();
			result = new String(b, "UTF-8");
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
     return new JSONObject(result);
 }
	public static JSONObject getAppConfig() {
		String result = null;

		try {
			String path = ResourceHelper.class.getResource("/app.json").getPath();
			path = URLDecoder.decode(path, "utf-8");
			log.debug(path);
			RandomAccessFile file = new RandomAccessFile(path, "r");
			byte[] b = new byte[(int)file.length()];
			file.read(b);
			file.close();
			result = new String(b, "UTF-8");
		} catch (Exception var4) {
			throw new RuntimeException(var4);
		}

		return new JSONObject(result);
	}
  /**
	  * 获取燃气公司配置文件
	  * @return
	  */
 public  static JSONObject getJsonFile() {
 	String result = null;
		try {
			String path = ResourceHelper.class.getResource("/pay.json").getPath();
			path = java.net.URLDecoder.decode(path, "utf-8");
			log.debug(path);
			RandomAccessFile file = new RandomAccessFile(path, "r");
			byte[] b = new byte[(int) file.length()];
			file.read(b);
			file.close();
			result = new String(b, "UTF-8");
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
     return new JSONObject(result);
 }


	/**
     * 获取当前时间戳，单位秒
     * @return
     */
    public static String getCurrentTimestamp() {
        return String.valueOf(System.currentTimeMillis()/1000);
    }

    /**
     * 获取当前时间戳，单位毫秒
     */
    public static String getCurrentTimestampMs() {
        return String.valueOf(System.currentTimeMillis());
    }

	/**
	 * 使用时间戳计算耗时，单位根据传入的时间判断
	 * @param end
	 * @param start
	 * @return
	 */
    public static String CalTimestampRange(String end,String start){
    	return String.valueOf(Long.parseLong(end) - Long.parseLong(start));
	}
	/**
	 * 将json格式的参数转成string签名串
	 * @param json
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	public static String json2Query(JSONObject json) {
		StringBuilder sb = new StringBuilder();
		Iterator<String> it = json.keys();
		ArrayList<String> list=(ArrayList)IteratorUtils.toList(it);
		Collections.sort(list);
		for(String k:list){
			try {
				if("".equals(json.get(k).toString())||json.get(k)==JSONObject.NULL||json.get(k)==null){
					continue;
				}else{
					sb.append(k+ "=" + json.get(k).toString() + "&");
				}
			} catch (JSONException e) {

				throw new RuntimeException(e);
			}
		}
		if (sb.length() > 0)
		{
			sb.deleteCharAt(sb.length()-1);
		}
		return sb.toString();
	}
	/**
	 * 将json格式的参数转成Map
	 * @param json
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	public static Map<String,String> json2Map(JSONObject json) {
		Map<String, String> paramMap = new HashMap<String, String>();
		Iterator<String> it = json.keys();
		ArrayList<String> list=(ArrayList)IteratorUtils.toList(it);
		Collections.sort(list);
		for(String k:list){
			try {
				if("".equals(json.get(k).toString())||json.get(k)==JSONObject.NULL||json.get(k)==null){
					continue;
				}else{
					paramMap.put(k,json.get(k).toString());
				}
			} catch (JSONException e) {

				throw new RuntimeException(e);
			}
		}
		return paramMap;
	}

	/**
	 * 将获取到的签名串转成json
	 * @param query
	 * @return
	 */
	public static JSONObject Query2json(String query){
		String[] strs=query.split("&");
		JSONObject json = new JSONObject();
		try {
			for(String param:strs){
				String[] vk = param.split("=");
				if (vk[1].startsWith("{")){
					json.put(vk[0], new JSONObject(vk[1]));
				}else {
					json.put(vk[0], vk[1]);
				}

			}
		} catch (JSONException e) {
			throw new RuntimeException(e);
		}
		return json;
	}

	/**
	 * 金额单位转换 分->元
	 * @param obj
	 * @return
	 */
	public static  String StrfenToYuan(Object obj) {
		if(obj ==null){
			return "0.00";
		}
		BigDecimal fee = new BigDecimal(obj.toString());
		fee = fee.divide(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
		return fee.toString();
	}
	/**
	 * 金额单位转换 分->元
	 * @param obj
	 * @return
	 */
	public static  double doublefenToYuan(Object obj) {
		if(obj ==null){
			return 0.00;
		}
		BigDecimal fee = new BigDecimal(obj.toString());
		fee = fee.divide(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
		return Double.parseDouble(fee.toString());
	}

	/**
	 * 金额单位转换 元->分
	 * @param obj
	 * @return
	 */
	public static  String Stryuan2Fen (Object obj){
		return String.valueOf(Intyuan2Fen(obj));
	}


	/**
	 * 金额单位转换 元->分
	 * @param obj
	 * @return
	 */
	public static  int Intyuan2Fen (Object obj){
		if(obj == null){
			return 0;
		}
		BigDecimal fee = new BigDecimal(obj.toString());
		fee = fee.multiply(new BigDecimal(100)).setScale(0, BigDecimal.ROUND_HALF_UP);
		return fee.intValue();
	}

	public static String getDoubleStr (Object obj) {
		if(obj ==null){
			return "0.00";
		}
		BigDecimal fee = new BigDecimal(obj.toString());
		return fee.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
	}

	/**
	 * 划价结果中字符串转double
	 * @return
	 */
	public static JSONObject  CalResultConvert(JSONObject json){
		JSONObject result = new JSONObject();
		Iterator<String> it = json.keys();
		ArrayList<String> list=(ArrayList)IteratorUtils.toList(it);
		Collections.sort(list);
		for(String k:list){
			//开始结束日期不做转换
			if("f_startdate".equals(k)|| "f_enddate".equals(k)){
				result.put(k,json.get(k).toString());
			}else{
				BigDecimal bigDecimal = new BigDecimal(json.get(k).toString()).setScale(2, BigDecimal.ROUND_HALF_UP);
				result.put(k,bigDecimal.doubleValue());
			}
		}
		log.debug(result);
		return result;
	}
	public static int Str2Int (String numStr) {
		if(numStr ==null){
			return 0;
		}
		return Integer.parseInt(numStr);
	}
	//是否超时
	public static boolean isTimeOut(String date){
		Date nowDate = new Date();
		String now = new SimpleDateFormat("yyyyMMddHHmmss").format(nowDate);
		return now.compareTo(date) >= 0;
	}

	/**
	 * 获取当前日期，日期格式自定义
	 * @param format
	 * @return
	 */
	public static String getNowDate(String format){
		return new SimpleDateFormat(format).format(new Date());
	}
	/**
	 * 获取指定日期的指定秒后的日期
	 * @return
	 */
	public static String getDateAfterSeconds (String format,String date,int seconds){
		String timeOut = "";
		try {
			Date nowdate = new SimpleDateFormat(format).parse(date);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(nowdate);
			calendar.add(Calendar.SECOND,seconds);
			timeOut= new SimpleDateFormat(format).format(calendar.getTime());
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
		return timeOut;
	}
	/**
	 * 获取指定日期的指定天数后的日期
	 * @return
	 */
	public static String getDateAfterDays(String format,String date,int days){
		try {
			Date nowdate = new SimpleDateFormat(format).parse(date);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(nowdate);
			calendar.add(Calendar.DAY_OF_MONTH,days);	//订单失效时间：45 SECOND	后
			return new SimpleDateFormat(format).format(calendar.getTime());
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 获取当前日期的指定天数后的日期
	 * @return
	 */
	public static String getDateAfterDays(String format,int days){
			Date nowdate = new Date();
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(nowdate);
			calendar.add(Calendar.DAY_OF_MONTH,days);
			return new SimpleDateFormat(format).format(calendar.getTime());
	}
	/**
	 * 获取指定日期的指定格式的日期字符串
	 * @return
	 * @throws ParseException
	 */
	public static String dateFormat(String format,String date,String toformat) throws ParseException{

			Date nowdate =new SimpleDateFormat(format).parse(date);
			return new SimpleDateFormat(toformat).format(nowdate);
	}

	/**
	 * 当前时间是否是本月最后一天的倒数多少小时范围内
	 * @param hours
	 * @return
	 */
	public static boolean isEndOfMonthLastHours(int hours){

		return isEndOfMonthLastMonutes(hours*60);
	}
	/**
	 * 当前时间是否是本月最后一天的倒数多少分钟范围内
	 * @param hours
	 * @return
	 */
	public static boolean isEndOfMonthLastMonutes(int minutes){
		Date nowdate = new Date();
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(nowdate);
		calendar.add(Calendar.MINUTE,minutes);
		return calendar.getTime().getMonth() > nowdate.getMonth();

	}

	public  static JSONObject  computeIotMoney(Object f_stair1price, Object f_collection){
		JSONObject sell = new JSONObject();
		BigDecimal money = new BigDecimal(f_collection + "");
		BigDecimal stair1price = new BigDecimal(f_stair1price.toString());//档案阶梯1
		BigDecimal meter_stair1price = stair1price.setScale(2, BigDecimal.ROUND_DOWN);//表上阶梯
		BigDecimal meter_money = money.multiply(meter_stair1price).divide(stair1price,2,BigDecimal.ROUND_HALF_UP);//结算充值到表金额
		BigDecimal difference = money.subtract(meter_money);

		sell.put("f_meter_money", meter_money.doubleValue());
		sell.put("f_difference", difference.doubleValue());

		return sell;
	}

	/**
	 *
	 * @param startMon
	 * @param endMon
	 * @return
	 */
	public boolean inLimitCycle(int startMon,int endMon){
		Calendar now = Calendar.getInstance();
		int month = now.get(Calendar.MONTH)+1;

		return (month >= endMon || month< startMon);
	}
	/**
	 * 生成随机字符串
	 * @return
	 */
	public static String getRandomString() {
		String base = "abcdefghijklmnopqrstuvwxyz0123456789";
		Random random = new Random();
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < 16; i++) {
			int number = random.nextInt(base.length());
			sb.append(base.charAt(number));
		}
		return sb.toString();
	}
    /**
     * 生成随机字符串
     * @return
     */
    public static String getRandomStringWithLen(int len) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /**
	 * 生成订单号
	 * @return
	 */
	public static String createTradeNo(){
		return UUID.randomUUID().toString().replaceAll("-", "");
	}


	public static String createTradeNo(String base){
		return base + new SimpleDateFormat("yyyyMMddHHmmssfff").format(new Date());
	}

	/**
	 * 根据传入的前缀以及uuid的位数生成商户订单号
	 * @param prefix
	 * @param num
	 * @return
	 */
	public static String createTradeNo(String prefix, int num){
		return prefix + getUUID(num);
	}

	/**
	 * 获取指定长度uuid
	 * @return
	 */
	public static  String getUUID(int len)
	{
		String uuid = UUID.randomUUID().toString().replaceAll("-", "");
		StringBuffer str = new StringBuffer();
		for (int i = 0; i < len; i++)
		{
			str.append(uuid.charAt(i));
		}
		return str.toString();
	}

	/**
	 * 计算微信等扣除手续费时用户承担费用的时候应交手续费
	 * @param basefee
	 * @param rate
	 * @return
	 */
	public static String convertCommissionCharge (String basefee,String rate){
		/**
		 * 手续费 = (基础金额 * 费率)/(1-费率)
		 */
			BigDecimal fee = new BigDecimal(basefee);
			BigDecimal baserate = new BigDecimal(rate);
			fee = fee.multiply(baserate).setScale(2, BigDecimal.ROUND_HALF_UP);
			fee = fee.divide(new BigDecimal(1).subtract(baserate),2,BigDecimal.ROUND_HALF_UP);
			System.out.println(fee.toString());
			return fee.toString();

	}
	/**
	 * URI编码
	 * @param json
	 * @return
	 */
	public static String URIEncode (JSONObject json) {
		String ret = URLEncoder.encode(json.toString());
		return ret;
	}

	/**
	 * 生成交易流水号
	 * @return
	 */
	public static String getSerialNumber () {
		String ret = getNowDate("yyyyMMddHHmmssSSS")+(int)(Math.random()*900+100);
        return ret;

	}

	/**
	 * 时间转换，long转固定类型
	 * @param date
	 * @param format
	 * @return
	 */
	public static String parseDate(Long date, String format) {

		Date datenew = new Date(date);

		return new SimpleDateFormat(format).format(datenew);

	}

    /**
     * 获取pos终端号与网点的对应配置文件
     * @param module
     * @return
     */
    public  static JSONObject getPosOrgConfig(String module) {
        String result = null;
        try {
            String path = ResourceHelper.class.getResource("/merch/" + module + "/posOrgConfig.json").getPath();
            path = java.net.URLDecoder.decode(path, "utf-8");
            log.debug(path);

            RandomAccessFile file = new RandomAccessFile(path, "r");
            byte[] b = new byte[(int) file.length()];
            file.read(b);
            file.close();
            result = new String(b, "UTF-8");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JSONObject(result);
    }

	/**
	 * 根据付款码判断是微信支付还是支付宝支付
	 * @param payCode
	 * @return
	 */
	public static String getPayment(String payCode){
		if (payCode.startsWith("1")) {
			return "微信";
		}
		if(payCode.startsWith("2")){
			return "支付宝";
		}
		return "未知";
	}

	public static JSONObject removeBrackets(String str){
		JSONObject result = new JSONObject(str.replace("[","").replace("]",""));
		return result;
	}

	public static JSONObject removeBrackets(JSONObject jo){
		String str = jo.toString();
		JSONObject result = new JSONObject(str.replace("[","").replace("]",""));
		return result;
	}

	public static boolean keyIsNotNull(JSONObject jo,String key){
		return !jo.isNull(key);
	}

	/**
	 * 系统跟踪号
	 * @param traceNo
	 * @return qrCodeResult
	 */
	public  static String addTraceNo(String traceNo,int len)  {
		String temp= String.valueOf(Integer.parseInt(traceNo)+1);
		String res=temp;
		for(int i=0;i<len-temp.length();i++){
			res="0"+res;
		}
		return res;
	}

	public static int  sumNumStrwithIndex(String numArrayStr ,int index){
		String [] nums = numArrayStr.split(",");
		int limitgas = 0;
		for (int i=0;i<index;i++){
			log.debug("nums["+i+"]: "+nums[i]);
			limitgas += Integer.parseInt(nums[i]);
		}
		return limitgas;
	}
	public static int getNumfromStr(String numstr,int index){
		log.debug("numstr:" + numstr);
		String [] nums = numstr.split(",");
		log.debug("nums[index+1]: "+nums[index-1]);
		int num = Integer.parseInt(nums[index-1]);
		return num;
	}
}
