package com.aote.utils;


import org.json.JSONArray;
import org.json.JSONObject;

public class ParamsConverter4ZSY {

    /**
     * 中石油计费接口响应数据转换
     * @param ratingServiceResponse
     * @return
     */
    public JSONObject convertRating(JSONObject ratingServiceResponse){
        JSONObject jo = new JSONObject();
        try {
            if(ratingServiceResponse.getString("ifStepPrice").equals("Y")) {
                //阶梯计费
                JSONArray array = new JSONArray();

                int multiStepRecordCount = ratingServiceResponse.getInt("multiStepRecordCount");
                JSONArray multiStepInfo = ratingServiceResponse.getJSONArray("multiStepInfo");
                int j = 0;
                for (int i = 1; i <= 3; i++) {
                    JSONObject stepInfo = multiStepInfo.getJSONObject(j);
                    String stepType = stepInfo.getString("stepType").substring(0,1);
                    if (i == Integer.parseInt(stepType)) {
                        // 阶梯上限
                        jo.put("f_stair" + i + "ceiling", 0);
                        // 阶梯剩余购气量
                        jo.put("f_stair" + i + "surplus", 0);

                        String[] sss = "111111".split(".");

//                    |--阶梯档位	stepType
//                    |--阶梯档位描述	stepTypeDesc
//                    |--本档气量	stepVolume
//                    |--本档单价	stepPrice
//                    |--本档金额	stepAmount
                        jo.put("f_stair" + i + "fee", stepInfo.getDouble("stepAmount"));
                        jo.put("f_stair" + i + "amount", stepInfo.getDouble("stepVolume"));
                        jo.put("f_stair" + i + "price", stepInfo.getDouble("stepPrice"));
                        JSONObject json = new JSONObject();
                        json.put("f_price_name", "阶梯" + i);
                        json.put("f_price", stepInfo.getDouble("stepPrice"));
                        json.put("f_gas", stepInfo.getDouble("stepVolume"));
                        json.put("f_money", stepInfo.getDouble("stepAmount"));
                        array.put(json);
                        j = (j < multiStepRecordCount-1) ? j+1 : j;
                    } else {
                        jo.put("f_stair" + i + "ceiling", 0);
                        // 阶梯剩余购气量
                        jo.put("f_stair" + i + "surplus", 0);

//                    |--阶梯档位	stepType
//                    |--阶梯档位描述	stepTypeDesc
//                    |--本档气量	stepVolume
//                    |--本档单价	stepPrice
//                    |--本档金额	stepAmount
                        jo.put("f_stair" + i + "fee", 0);
                        jo.put("f_stair" + i + "amount", 0);
                        jo.put("f_stair" + i + "price", 0);
                        JSONObject json = new JSONObject();
                        json.put("f_price_name", "阶梯" + i);
                        json.put("f_price", 0);
                        json.put("f_gas", 0);
                        json.put("f_money", 0);
                        array.put(json);
                    }
                }
                jo.put("chargenum", ratingServiceResponse.getDouble("gasFee"));
                jo.put("chargeprice", array);
                jo.put("sumamount", 0);
                jo.put("oughtamount", 0);
                jo.put("gas", 0);
            }
        }catch (Exception e){
            throw new RuntimeException(e);
        }
        return jo;
    }

//
//    public static JSONObject stringToJson(String condition){
//
//        JSONObject json = new JSONObject();
//
//        String card[] = condition.split("and");
//
//        json.put("f_card_id", card[0].split("=")[1].trim().replace("'",""));
//
//        json.put("f_alias",card[1].split("like")[1].replace("%","").trim().replace("'",""));
//
//        json.put("mdmCode",card[2].split("=")[1].trim().replace("'",""));
//
//        return json;
//
//    }

//    public static void main(String [] args){
//        String condition = "f_card_id = '100003579' and f_alias like '%ZJJK%'  and mdmCode = '9A6N'";
//
//        JSONObject jo = stringToJson(condition);
//
//        System.out.println(jo);
//
//    }




}
