package com.aote.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 *  Autor by mazj 2020.03.09
 */
public class DateUtil {

    public static String getNow(String reg) {
        SimpleDateFormat sdf = new SimpleDateFormat(reg);
        return sdf.format(new Date());
    }

    public static String getDateString(Date date,String reg){
        SimpleDateFormat sdf = new SimpleDateFormat(reg);
        return sdf.format(date);
    }

    public static String getDatetime(String reg) {
        SimpleDateFormat sdf = new SimpleDateFormat(reg);
        String datetime = sdf.format(new Date());
        return datetime.replaceAll(" ","").replaceAll("-","").replaceAll(":","");
    }

    /**
     *
     *  返回当前系统时间相加n秒后的时间，以表达式的形式返回
     * @param reg  时间表达式
     * @param seconds 相加的时间
     * @return
     */
    public static String nowAddSecond(String reg, int seconds){
        Calendar cal = Calendar.getInstance();//使用默认时区和语言环境获得一个日历。
        cal.add(Calendar.SECOND, seconds);//
        return getDateString(cal.getTime(),reg);
    }

    /**
     *
     * @param somedateStr
     * @return
     */
    public static int yearsBetweenNow(String somedateStr) throws ParseException {
        Date begindate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(somedateStr);
        Calendar beginc = Calendar.getInstance();
        beginc.setTime(begindate);
        Date enddate = new Date();
        Calendar endc = Calendar.getInstance();
        endc.setTime(enddate);
        int years = endc.get(Calendar.YEAR) - beginc.get(Calendar.YEAR);
        if(endc.get(Calendar.MONTH) > beginc.get(Calendar.MONTH)){
            years +=1;
        }else if(endc.get(Calendar.MONTH) == beginc.get(Calendar.MONTH)){
            if(endc.get(Calendar.DAY_OF_MONTH) > beginc.get(Calendar.DAY_OF_MONTH)){
                years +=1;
            }else if (endc.get(Calendar.DAY_OF_MONTH) == beginc.get(Calendar.DAY_OF_MONTH)) {
                if(endc.get(Calendar.HOUR_OF_DAY) > beginc.get(Calendar.HOUR_OF_DAY)){
                    years +=1;
                }
            }
        }
        return years;

    }

    public  static String addYears(String strDate,int years) throws  ParseException{
        Date begindate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(begindate);
        cal.add(Calendar.YEAR,years);
        return getDateString(cal.getTime(),"yyyy-MM-dd HH:mm:ss");
    }

}
