package com.aote.utils;

import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.SimpleFormatter;

public class DataConversion {
    /**
     * 提供简单的字符串转双精度浮点数加法运算
     */
    public static double stringAddNum(String num1, String num2) {
        double n1, n2;
        n1 = Double.parseDouble(num1);
        n2 = Double.parseDouble(num2);
        return n1 + n2;
    }

    /**
     * 同名方法重载
     */
    public static double stringAddNum(Integer num1, Integer num2) {
        return num1 + num2;
    }

    /**
     * 同名方法重载
     */
    public static double stringAddNum(double num1, double num2) {
        return num1 + num2;
    }

    public static double chuyiNum(Object num1, Object num2) {
        if (num1 instanceof Integer && num2 instanceof Integer) {
            return (Integer) num1 / (Integer) num2;
        } else if (num1 instanceof Integer && num2 instanceof BigDecimal) {
            return (Integer) num1 / ((BigDecimal) num2).doubleValue();
        } else if (num1 instanceof BigDecimal && num2 instanceof Integer) {
            return ((BigDecimal) num1).doubleValue() / (Integer) num2;
        } else {
            return ((BigDecimal) num1).doubleValue() / ((BigDecimal) num2).doubleValue();
        }
    }

    /**
     * 四舍五入规则舍去后两位小数点之后的数字
     */
    public static double clertPoint(BigDecimal num) {
        return num.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public static double conversionDouble(String num) {
        return new BigDecimal(num).doubleValue();
    }
    public static double conversionDouble(Integer num){
        return new BigDecimal(num).doubleValue();
    }
    public static double conversionDouble(BigDecimal num){
        return num.doubleValue();
    }
    /**
     * 结果集偶尔返回整数会被填装成Integer类型的整数
     */
    public static double clertPoint(Integer num) {
        return num;
    }

    /**
     * 提取json中的数据并封装成json数组返回
     */
    public static JSONObject getDataConversionArray(JSONObject json) {
        Map[] maps = new HashMap[3];
        Map data = new HashMap();
        data.put("f_gas", json.getDouble("f_stair1amount"));
        data.put("f_money", json.getDouble("f_stair1fee"));
        data.put("f_price", json.getDouble("f_stair1price"));
        data.put("f_price_name", "阶梯1");
        maps[0] = data;
        data = new HashMap();
        data.put("f_gas", json.getDouble("f_stair2amount"));
        data.put("f_money", json.getDouble("f_stair2fee"));
        data.put("f_price", json.getDouble("f_stair2price"));
        data.put("f_price_name", "阶梯2");
        maps[1] = data;
        data = new HashMap();
        data.put("f_gas", json.getDouble("f_stair3amount"));
        data.put("f_money", json.getDouble("f_stair3fee"));
        data.put("f_price", json.getDouble("f_stair3price"));
        data.put("f_price_name", "阶梯3");
        maps[2] = data;
        json.put("chargeprice", maps);
        return json;
    }
    /**
     * 是否采暖季
     * @param userfiles
     * @return
     */
    public static boolean isHeat(JSONObject userfiles) {
    	String now = new SimpleDateFormat("MM-dd").format(new Date());
    	if(now.compareTo(userfiles.getString("f_heatstart"))>=0&&now.compareTo("12-31")<=0 &&userfiles.getDouble("f_stair1heatamount")>0||
    			now.compareTo(userfiles.getString("f_heatend"))<=0&&now.compareTo("01-01")>=0 &&userfiles.getDouble("f_stair1heatamount")>0){
    		return true;
    	}
    	return false;
    }
    
//    public static JSONObject CalCeil (JSONObject userfiles,JSONObject )

    /**
     * 提供字符串检索功能
     *
     * @return -1就等于没检索到
     */
    public static int stringIndexof(String str, String data) {
        return str.indexOf(data);
    }

    public static JSONObject clearJSON(JSONObject json) {
        json.keys().forEachRemaining((str) -> {
            json.put(str, JSONObject.NULL);
        });
        return json;
    }

    /**
     * 获取当前时间
     */
    public static String getNowDate() {
        SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return si.format(new Date());
    }
}
