package com.aote.utils;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommonUtil {
    static Logger log = Logger.getLogger(CommonUtil.class);

    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static JSONArray getPosState(JSONArray jsonArray){
        JSONObject jsonObject=PayUtil.getJsonFile();
        //pos_offline_time的单位：分钟
        long intervalTime=jsonObject.getInt("pos_offline_time")*60*1000;
        JSONArray result=new JSONArray();
        if(jsonArray.length()>0){
            for(int i=0;i<jsonArray.length();i++){
                JSONObject resItem=new JSONObject();
                JSONObject item=jsonArray.getJSONObject(i);
                resItem.put("name",item.getString("name"));
                resItem.put("ename",item.getString("ename"));
                resItem.put("description",item.getString("f_description"));
                resItem.put("x",item.getString("loginip").split(",")[0]);
                resItem.put("y",item.getString("loginip").split(",")[1]);
                try {
                    Date date=sdf.parse(item.getString("logintime"));
                    if(System.currentTimeMillis()-date.getTime()>intervalTime){
                        resItem.put("state","offline");
                    }else{
                        resItem.put("state","online");
                    }
                } catch (Exception e) {
                    log.error("日期转换失败："+e.getMessage());
                    log.error("报文:"+jsonArray.toString());
                    e.printStackTrace();
                    resItem.put("state","offline");
                }
                result.put(resItem);
            }
        }
        return result;
    }


    public static JSONArray changeUsersView(JSONArray jsonArray){
        if(jsonArray.length()>0){
            for(int i=0;i<jsonArray.length();i++){
                JSONObject item=jsonArray.getJSONObject(i);
                String name=item.getString("f_user_name");
                String newName=name.replaceFirst("(.{1,1})","*");
                item.put("user_name",newName);
                String address=item.getString("f_address");
                String newAddress=address.replaceFirst("(.号楼)","*号楼");
                item.put("address",newAddress);
            }
        }
        return jsonArray;
    }
}
