package com.aote.utils;

import java.io.UnsupportedEncodingException;

import org.apache.commons.codec.binary.Base64;
import org.junit.Test;

public class Base64Util {

	/**
	 * 对给定的字符串进行base64解码操作
	 */
	public static byte[] decode(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return  Base64.decodeBase64(inputData.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 对给定的字符串进行base64加密操作
	 */
	public static byte[] encode(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return Base64.encodeBase64(inputData.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 对给定的字符串进行base64解码操作
	 */
	public static String decodeData(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return new String(Base64.decodeBase64(inputData.getBytes("UTF-8")), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 对给定的字符串进行base64加密操作
	 */
	public static String encodeData(String inputData) {
		try {
			if (null == inputData) {
				return null;
			}
			return new String(Base64.encodeBase64(inputData.getBytes("UTF-8")), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 对给定的byte[]进行base64加密操作
	 */
	public static String encode(byte[] bytes) {
		if (null == bytes) {
			return null;
		}
		return new String(Base64.encodeBase64(bytes));

	}
}
