package com.aote.utils;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.*;

/**
 * @auther qinlong
 * @date 2020-08-17 14:05
 */
public class BankFileUtil {
    private static Logger log = Logger.getLogger(BankFileUtil.class);

    public static JSONArray readFiles(String filePath,String reg,String charSet,int startLine,int removeLastLines) {
        File bankDirs = new File(filePath);
        File[] file = bankDirs.listFiles();

        JSONArray ja = new JSONArray();
        int index = 0;
        for (int i = 0; i < file.length ; i++) {
            if(file[i].isFile() && verifyFilName(file[i],reg)){
                try {
                    index ++;
                    readFile(file[i],charSet,ja,startLine,removeLastLines);
                    moveToNewPath(file[i],filePath+"\\bak",charSet);
                }catch (IOException e){
                    moveToNewPath(file[i],filePath+"\\error",charSet);
                }
            }
        }
        log.debug("共读取"+(index)+"个文件，读到"+ja.length()+"条数据");
        log.debug("strData:"+ja.toString());
        return ja;
    }

    private static void readFile(File file, String charSet,JSONArray ja,int startLine,int removeLastLines)throws IOException{
        BufferedReader bf =new BufferedReader(new InputStreamReader(new FileInputStream(
                file), charSet));
        String str = "";
        int index = 0;
        while((str = bf.readLine()) != null ){

            if (index < startLine) {
                index ++;
                continue;
            }

            JSONObject  json = new JSONObject();
            json.put("line",str);
            ja.put(json);
        }
        log.debug("removeLastLines:"+removeLastLines);
        if(removeLastLines >0){
            for(;removeLastLines>0;removeLastLines--){
                log.debug("removeLastLines:"+removeLastLines);
                ja.remove(ja.length()-1);
            }
        }
        bf.close();
    }
    private static boolean verifyFilName(File file,String reg){
         String fullName = file.getName();
         String fileName = fullName.split("\\.")[0];
         log.debug("fileName:"+fullName+"----"+fileName.matches(reg));
         return fileName.matches(reg);
    }

    private static void moveToNewPath(File oldFile, String target,String charSet) {

        // 获取新的路径
        File targatFile = new File(target);
        if(!targatFile.exists()){
            targatFile.mkdirs();
        }
        String newpath = target + "\\" + oldFile.getName();
        BufferedReader read = null;
        FileWriter write = null;
        try {
            read = new BufferedReader(new InputStreamReader(
                    new FileInputStream(oldFile), charSet));
            write = new FileWriter(new File(newpath), true);

            String temp;
            while ((temp = read.readLine()) != null) {
                write.write(temp);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                read.close();
                write.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
            deleteFile(oldFile);
        }
    }

    private static boolean deleteFile(File file) {
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }


}
