package com.aote.utils;

import org.apache.log4j.Logger;

import java.io.*;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;

public class AccountUtil {
    static Logger log = Logger.getLogger(AccountUtil.class);

    public void writeFile (String content, String path,String filename){
        Writer outTxt = null;
        File dirs = new File(path);
        if(!dirs.exists()){
            dirs.mkdirs();
        }
        File file = new File(path+File.separator+filename);
        if (file.exists()){
            file.delete();
        }
        try{

            outTxt = new OutputStreamWriter(new FileOutputStream(file,true), "UTF-8");
            outTxt.write(content);
            outTxt.close();
        }catch(IOException e){
            throw  new RuntimeException("写文件失败"+e.getMessage());
        }
    }
    public static String replace(String content,String oldstr,String newstr){
        return content.replace(oldstr,newstr);
    }

    /**
     * gZip解压方法
     */
    public static String unGZip(String str) {
        byte[] data = Base64Util.decode(str);
        byte[] b = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            GZIPInputStream gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            b = baos.toByteArray();
            baos.flush();
            baos.close();
            gzip.close();
            bis.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return new String(b);
    }
}
