package com.aote.union;

import com.alibaba.fastjson.JSON;
import com.aote.icbc.IcbcUtil;
import com.aote.utils.MD5Util;
import com.aote.utils.PayUtil;
import com.aote.utils.SSLClient;
import com.aote.wft.XmlUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


/**
 * @program: PayModule
 * @description: 银联支付工具类
 * @author: 李浩
 * @create: 2020-04-15 11:19
 **/
public class UnionUtil {

    static Logger log = Logger.getLogger(IcbcUtil.class);

    // 银联查询订单返回订单状态
    public static final HashMap<String, String> errorMap = new HashMap();
    static {
        errorMap.put("REFUND", "转入退款");
        errorMap.put("CLOSED", "已关闭");
        errorMap.put("REVOKED/REVERSE", "已撤销");
        errorMap.put("PAYERROR", "支付失败");
    }

    /**
     * 根据支付返回交易状态获取支付状态
     * @param key
     * @return
     */
    public static String getErrMsg(String key){
        return errorMap.get(key);
    }

    /**
     * 发送报文验签
     * @param sendData
     * @return
     */
    public static String getSign(JSONObject sendData, String key){
        String sendDataStr = PayUtil.json2Query(sendData);
        return MD5Util.sign(sendDataStr, "&key=" + key, "utf-8");
    }

    /**
     * 银联发送请求
     * @param sendData
     * @param url
     * @return
     */
    public static JSONObject post(JSONObject sendData, String url){
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try{
            HttpPost httpPost = new HttpPost(url);
            StringEntity entityParams = new StringEntity(XmlUtils.toXml(sendData),"utf-8");
            httpPost.setEntity(entityParams);
            httpPost.setHeader("Content-Type", "text/xml;charset=ISO-8859-1");
            client = new SSLClient();
            response = client.execute(httpPost);

            int StatusCode = response.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                throw new RuntimeException("银联平台连接错误，错误代码:" + StatusCode);
            }
            Map<String,String> resultMap = XmlUtils.toMap(EntityUtils.toByteArray(response.getEntity()), "utf-8");
            return new JSONObject(resultMap);
        }catch (Exception e){
            throw new RuntimeException(e);
        }finally {
            try {
                response.close();
                client.close();
            }catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /**
     * 验证签名
     * @param returnData
     * @param key
     * @return
     */
    public static boolean checkSign(JSONObject returnData, String key){
        Map map = (Map) JSON.parse(returnData.toString());
        return SignUtils.checkParam(map, key);
    }
}
