package com.aote.timer;

import com.aote.logic.LogicServer;
import com.aote.rs.SqlService;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class QueryOrderTask {
    @Autowired
    LogicServer logicServer ;

    @Autowired
    SqlService sql;

    static Logger log = Logger.getLogger(QueryOrderTask.class);

    //执行定时查询，定时器中时间设置为10秒
    public  void query(){
        try {

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tablename","t_weixinreturnxml");
            jsonObject.put("condition","f_bill_state = '0'");

            JSONObject jo = new JSONObject().put("data",jsonObject);

            String result = sql.txExecute("pos_singleTable",1,500, jo.toString());

            JSONArray jsonArray = new JSONArray(result);

            log.debug("查询到未支付账单"+jsonArray.length()+"条,开始查询");

            for (int i = 0 ; i < jsonArray.length(); i++){

                JSONObject json = jsonArray.getJSONObject(i);

                try{

                    logicServer.run("QureyOrderTimer",json);
                }catch (Exception e){
                    log.error("执行定时查询异常,错误信息:" , e);
                }

            }
        } catch (Exception e) {
            log.error("执行定时查询异常:" , e);
        }
        finally {
            log.info("执行定时查询完成");
        }
    }
}
