package com.aote.timer;

import com.aote.logic.LogicServer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @auther qinlong
 * @date 2020-08-17 15:51
 */
public class DealBankPaymentTask {
    /**
     * filePath             对账文件目录
     * reg                  文件名校验正则
     * charSet              编码格式
     * logic                执行的业务逻辑名
     * revenue              对应的营收版本
     * startLine            有效数据起始行，从0开始
     * removeLastLines      后面需要去掉的行数
     * 如果需要可以追加字段
     */

    private String filePath;

    private String reg;

    private String charSet;

    private String logic;

    private String revenue;

    private  String startLine;

    private  String removeLastLines;


    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setReg(String reg) {
        this.reg = reg;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public void setRevenue(String revenue) {
        this.revenue = revenue;
    }

    public void setStartLine(String startLine) {
        this.startLine = startLine;
    }

    public void setRemoveLastLines(String removeLastLines) {
        this.removeLastLines = removeLastLines;
    }

    public String getFilePath() {
        return filePath;
    }

    public String getReg() {
        return reg;
    }

    public String getCharSet() {
        return charSet;
    }

    public String getLogic() {
        return logic;
    }

    public String getRevenue() {
        return revenue;
    }

    public String getStartLine() {
        return startLine;
    }

    public String getRemoveLastLines() {
        return removeLastLines;
    }

    private static Logger log = Logger.getLogger(DealBankPaymentTask.class);
    @Autowired
    LogicServer logicServer ;

    public void run(){
        JSONObject data = new JSONObject();
        data.put("filePath",filePath);
        data.put("reg",reg);
        data.put("charSet",charSet);
        data.put("revenue",revenue);
        data.put("startLine",Integer.parseInt(startLine));
        data.put("removeLastLines",Integer.parseInt(removeLastLines));
        try {
            logicServer.run(logic, data);
        } catch (Exception e) {
            log.debug("对账文件处理异常："+e.getMessage());
        }

    }
}
