package com.aote.sxxh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;



import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import com.aote.abc.AbcUtil;
import com.aote.utils.PayUtil;
import com.icbc.api.internal.util.codec.Base64;
/**
 * 陕西信合支付插件
 * @author Lenovo
 *
 */
public class SxxhUtil {
	
	static Logger log = Logger.getLogger(SxxhUtil.class);
	/**
	 * 
	 * 校验数据格式
	 * @param strData
	 * @return
	 */
	public static boolean  verifyData(String strData){
		return strData != null && strData.startsWith("{");
	}
	/**
	 * 
	 * 校验查询或退款请求是否成功
	 * @param strData
	 * @return
	 */
	public static boolean  verifyReq(JSONObject json){
		return "000000".equals(json.getString("retCode")) &&"02".equals(json.getString("txnStat"));
	}
	/**
	 * 签名
	 * @throws Exception 
	 * @throws UnsupportedEncodingException 
	 * 
	 */
	public static String  sign(String transData,String pfxUrl,String pfxPwd) throws UnsupportedEncodingException, Exception{
		
		String path = SxxhUtil.class.getResource("/certs").getPath() + pfxUrl;
		//签名
		byte[] byteSign = SecureUtil.signBySoft(
				CertUtil.getSignCertPrivateKeyByStoreMap(path,pfxPwd),
				transData.getBytes("utf-8"));
		String signStr = Base64.encodeBase64String(byteSign);
		return signStr;
	}
	
	/**
	 * 陕西信合发送请求
	 * @param url
	 * @param req
	 * @param encoding
	 * @return
	 */
	public static String httpPost(String url,String req,String encoding) {
		log.debug("请求体"+req);
		HttpURLConnection httpConn = null;
		OutputStream out = null;
		BufferedReader in = null;
		String responseStr = null;
		try {
			URL urlClient = new URL(url);
			httpConn = (HttpURLConnection) urlClient.openConnection();
			setHttpConnection(httpConn);
			out = httpConn.getOutputStream();
			out.write(req.getBytes("utf-8"));
			out.flush();

			in = new BufferedReader(new InputStreamReader(
					httpConn.getInputStream(), "utf-8"));
			StringBuffer sb = new StringBuffer();
			String line;
			boolean firstLine = true;
			while ((line = in.readLine()) != null) {
				if (firstLine) {
					firstLine = false;
				} else {
					sb.append("\n");
				}
				sb.append(line);
			}
			return sb.toString();
		} catch (MalformedURLException e) {
			log.debug("陕西信合请求异常："+e.getMessage());
			e.printStackTrace();
			return "";
		} catch (IOException e) {
			log.debug("陕西信合请求异常："+e.getMessage());
			e.printStackTrace();
			return "";
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
				}
			}

		}
	}



	/**
	 * 设置请求属性信息
	 * 
	 * @param httpConn
	 * @throws java.net.ProtocolException
	 */
	private  static void setHttpConnection(HttpURLConnection httpConn)
			throws ProtocolException {
		httpConn.setRequestMethod("POST");
		httpConn.setConnectTimeout(5000);
		httpConn.setReadTimeout(50000);
		httpConn.setRequestProperty("Connection", "keep-alive");
		httpConn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.8");
		httpConn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
		httpConn.setRequestProperty("Accept", "application/json;charset=utf-8");
		httpConn.setRequestProperty(
				"User-Agent",
				"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.803.0 Safari/535.1");
		httpConn.setDoInput(true);
		httpConn.setDoOutput(true);

		if ("https".equalsIgnoreCase(httpConn.getURL().getProtocol())) {
			HttpsURLConnection husn = (HttpsURLConnection) httpConn;
			husn.setSSLSocketFactory(new BaseHttpSSLSocketFactory());
			//解决测试环境由于服务器证书问题导致HTTPS无法访问的情况
			husn.setHostnameVerifier(new HostnameVerifier() {
				@Override
				public boolean verify(String arg0, SSLSession arg1) {
					return true;
				}
			});
		}
	}

	/**
	 * 处理对账数据
	 *
	 * @param bankData
	 * @param bankname
	 */
	public  static JSONArray processBankData(String bankData,String bankname){
		log.debug(bankData);
		JSONArray result=new JSONArray();
		String [] bankrow=bankData.split("\r\n");
		log.debug(bankrow[0]+"      测试=== ");
		log.debug(bankrow.length+"      测试=== ");
		for (int i=0;i<bankrow.length;i++){

            String [] bankrowdata=bankrow[i].split("\\|");
			System.out.println(bankrowdata+"sasad");
            if(!bankrowdata[0].equals("01")||bankrowdata[0].equals("")){continue;}
                //保存单条记录
				JSONObject jo=new JSONObject();
				jo.put("f_merchant_id",bankrowdata[1]);
				jo.put("f_trade_date",bankrowdata[2]);
				jo.put("f_serial_id",bankrowdata[3]);
				jo.put("f_trade_cost",bankrowdata[4]);
				jo.put("f_bank_date",bankrowdata[5]);
				jo.put("f_trade_number",bankrowdata[6]);
				jo.put("f_bank_name",bankname);
			   result.put(jo);
		}
		return result;
	}

//	public static void main(String[] args) {
//
//		JSONObject jo=new JSONObject();
//		JSONArray res=new JSONArray();
//		jo.put("filedata","01|2049122400003696|20191029|27e7da384c27416ebf1d6e258f7fdb52|0.01|20541020|1012022054082116300184075140\r\n01|2049122400003696|20191029|f0302e8a506d4f2080c7afec19c58c0d|0.01|20541020|1012022054082115222084073396\r\n01|2049122400003696|20191029|79f507203638415b85601123041ba412|0.01|20541020|1012022054082116271184074988\r\n01|2049122400003696|20191029|76796a890f4a46eab25f314b5651c734|0.01|20541020|1012022054082114194784071472\r\n01|2049122400003696|20191029|ce3631fd1bc049d08bd52e81bc90124a|0.01|20541020|1012022054082115191884073361\r\n01|2049122400003696|20191029|0d76fca65133407897ef4c3d600ea9fb|0.01|20541020|1012022054082218021584077060\r\n01|2049122400003696|20191029|b59159539a414208858a113f10e7b000|0.01|20541020|1012022054082113554484071287\r\n01|2049122400003696|20191029|db81efb0294d45e3bdb02ff488621080|0.01|20541020|1012022054082116131684074757\r\n01|2049122400003696|20191029|ca7ddf2165e840e1aeeaf336c41e577f|0.01|20541020|1012022054082217472684075903\r\n01|2049122400003696|20191029|31f5a393215448059c6fa5f933dc1df5|0.01|20541020|1012022054082218050584077097\r\n01|2049122400003696|20191029|e142849f957945269762fcd91cc22b9c|0.01|20541020|1012022054082218102084077161\r\n01|2049122400003696|20191029|050bf5a715444b248e9ae3b9b98dbb0b|0.01|20541020|1012022054082116322384075162\r\n01|2049122400003696|20191029|e49de992389249ac87b332ae60d056a7|0.01|20541020|1012022054082318482984077632\r\n01|2049122400003696|20191029|cbb9d81fb3fe4c1b95c4d9a3f7f299cb|0.01|20541020|1012022054082218241884077397\r\n01|2049122400003696|20191029|5d5798825f6a47e897cca7e013982fac|0.01|20541020|1012022054082218073984078007\r\n01|2049122400003696|20191029|189c8877d23049c286c55a17081ae7d5|0.01|20541020|1012022054082114231284072549\r\n01|2049122400003696|20191029|824fcfef4b604a0cb40ad905a1f6ce7e|0.01|20541020|1012022054082217573384077003\r\n01|2049122400003696|20191029|778a5e2138b8484995ece68d708a06dc|0.01|20541020|1012022054082218190984077293\r\n01|2049122400003696|20191029|67684da9c01141be87e2b133865be386|0.01|20541020|1012022054082318294984077490\r\n01|2049122400003696|20191029|c69f32ab86ba4ae4ab69721308bd67bc|0.01|20541020|1012022054082114133284071402\r\n");
//		jo.put("bankname","农商银行");
//		res=processBankData(jo.getString("filedata"),jo.getString("bankname"));
//		System.out.println(res);
//	}
}
