package com.aote.siyangrcb;

import com.aote.ccb_ronglian.HttpClientUtil;
import com.aote.ccb_ronglian.ParseXML;
import com.aote.ccb_ronglian.Tool;
import com.aote.utils.HttpPlugin;
import com.aote.utils.PayUtil;
import com.aote.utils.SSLClient;
import com.google.common.collect.Maps;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


@Component
public class RcbUtil {

    static Logger log = Logger.getLogger(RcbUtil.class);

    private static String module="siyangrcb";

    public void setModule(String module){
        RcbUtil.module = module;
    }


    /**
     * 泗阳农商行获取二维码
     *
     * @param config
     * @param data
     * @return qrCodeResult
     */
    public static JSONObject getQrcode(JSONObject config, JSONObject data) {
        JSONObject qrCodeResult = new JSONObject();
        String payway = data.getString("payway");
        if ("union".equals(payway)) {
            qrCodeResult = getQrcodeByUnion(config, data);
        } else if ("ali".equals(payway)) {
            qrCodeResult = getQrcodeByAliPay(config, data);
        }
        return qrCodeResult;
    }

    /**
     * 银联主扫下单
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject getQrcodeByUnion(JSONObject config, JSONObject data) {


        JSONObject qrCodeResult = new JSONObject();

        //报文整形
        JSONObject params = new JSONObject();
        params.put("ThirdCode", "000454");
        params.put("version_id", "V1.0.0");
        params.put("shflag", data.getString("shflag"));
        params.put("attach", data.getString("attach"));
        params.put("amount", data.getString("total_fee"));
        params.put("transtype", "998001");
        params.put("orderTime", new SimpleDateFormat("yyyyMMddHHmmss")
                .format(new Date()));
        // 商户订单号(最长 32 位,商户需要保证订单的唯一性)
        params.put("orderNo", config.getString("merchId")
                + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())
                .toString());

        params.put("sourcetype", "0");
        params.put("Comments", "");
        params.put("shopno", config.getString("merchId"));
        params.put("terminal", "00001");
        params.put("orderDetails", "POS消费");

        try {
            //发送报文
            log.debug("发送==>" + config);
            qrCodeResult = rcbPostData(params.getString("payUrl"), config);
            String rtCode = qrCodeResult.getString("code");
            if (rtCode.equals("00")) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                qrCodeResult.put("code", 200);
                qrCodeResult.put("msg", "ok");
                qrCodeResult.put("url", qrCodeResult.getString("code_url"));
                qrCodeResult.put("f_out_trade_no", data.getString("out_trade_no"));
            } else {
                //失败
                log.debug("ReturnCode:" + rtCode);
                log.debug("下单请求失败ReturnMsg:" + qrCodeResult.getString("desc"));
                qrCodeResult.put("code", 500);
                qrCodeResult.put("msg", "下单请求失败：" + qrCodeResult.getString("desc"));
            }
        } catch (Exception e) {
            log.debug("下单请求异常:" + e.getMessage());
            qrCodeResult.put("code", 500);
            qrCodeResult.put("msg", "下单请求异常：" + e.getMessage());
        }
        return qrCodeResult;
    }

    /**
     * 支付宝主扫下单
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject getQrcodeByAliPay(JSONObject config, JSONObject data) {


        JSONObject qrCodeResult = new JSONObject();

        JSONObject params = new JSONObject();
        //报文整形
        params.put("ThirdCode", "000442");
        params.put("shflag", data.getString("shflag"));
        params.put("mer_id", config.getString("merchId"));
        params.put("device_id", config.getString("device_id"));
        params.put("appchannel_id", config.getString("appchannel_id"));
        params.put("device_info", "0000001");
        params.put("total_amount", data.getString("total_fee"));
        params.put("subject", config.getString("subject"));
        params.put("goods_id", config.getString("goods_id"));
        params.put("goods_name", config.getString("goods_name"));
        params.put("quantity", data.getString("quantity"));
        params.put("price", data.getString("price"));

        try {
            //发送报文
            log.debug("发送==>" + config);
            qrCodeResult = rcbPostData(config.getString("payUrl"), params);
            String returnCode = qrCodeResult.getString("return_code");
            if (returnCode.equals("00")) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                qrCodeResult.put("code", 200);
                qrCodeResult.put("msg", "ok");
                qrCodeResult.put("f_out_trade_no", data.getString("oldmerchantorigseqno"));
            } else {
                //失败
                log.debug("ReturnCode:" + returnCode);
                log.debug("下单请求失败ReturnMsg:" + qrCodeResult.getString("return_msg"));
                qrCodeResult.put("code", 500);
                qrCodeResult.put("msg", "下单请求失败：" + qrCodeResult.getString("return_msg"));
            }
        } catch (Exception e) {
            log.debug("下单请求异常:" + e.getMessage());
            qrCodeResult.put("code", 500);
            qrCodeResult.put("msg", "下单请求异常：" + e.getMessage());
        }
        return qrCodeResult;
    }

    /**
     * 农商行订单查询
     *
     * @param config
     * @return result
     */
    public static JSONObject orderQuery(JSONObject config, JSONObject data) {
        String deviceId=data.getString("device_id");
        if(deviceId!=null){
            data.put("org_device_id",deviceId);
            String newDeviceId=deviceId.substring(deviceId.length()-8,deviceId.length());
            data.put("device_id",newDeviceId);
        }
        JSONObject queryResult = new JSONObject();
        String payway = data.getString("pay_way");
        if (payway.equals("wx")) {
            queryResult = orderQueryByWX(config, data);
        } else if (payway.equals("union")) {
            queryResult = orderQueryByUnion(config, data);
        } else if (payway.equals("ali")) {
            queryResult = orderQueryByAliPay(config, data);
        }
        return queryResult;
    }

    /**
     * 微信订单查询
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject orderQueryByWX(JSONObject config, JSONObject data) {
        JSONObject result = new JSONObject();
        JSONObject responseJSON = new JSONObject();
        try {
            JSONObject params = new JSONObject();
            params.put("ThirdCode", "000430");
            params.put("mer_id", config.getString("merchId"));
            params.put("device_id", data.getString("device_id"));
            params.put("oldmerchantdatetime", data.getString("merchantdatetime"));
            params.put("oldmerchantorigseqno", data.getString("f_out_trade_no"));
            params.put("oldmerchantorigdate", data.getString("merchantdate"));
            //发送报文
            log.debug("发送==>" + params);

            //---------------------//

//
//            JSONObject orderInfo = new JSONObject();
//
//
//            //总金额
//            int total_amount = 100;
//            //商家优惠金额
//            int mdiscount_amount = 10;
//            //平台优惠金额
//            int discount_amount = 20;
//            //其他优惠金额
//            int othdiscount_amount = 10;
//            //总优惠金额
//            int coupon_fee = 40;
//
//
//            //订单总金额
//            orderInfo.put("f_total_fee",total_amount);
//
//            //行内系统订单号
//            orderInfo.put("f_transaction_id","1234567890");
//            //总优惠金额
//
//            //支付完成时间
//            orderInfo.put("f_time_end",PayUtil.getNowDate("HHmmss"));
//            //订单状态
//            orderInfo.put("f_bill_state",1);
//
//            //总优惠金额
//            orderInfo.put("f_coupon_fee", coupon_fee);
//            result.put("orderInfo",orderInfo);
//            result.put("code", 200);
//            result.put("msg", "ok");
//            //订单状态
//            result.put("pay_status", 1);

            //---------------------//


             responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);
            JSONObject orderInfo = new JSONObject();
            orderInfo.put("f_return_code", responseJSON.getString("ReturnCode"));
            orderInfo.put("f_return_msg", responseJSON.getString("ReturnMsg"));
            String retCode = responseJSON.getString("ReturnCode");
            if (retCode.equals("000000")) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                result.put("code", 200);
                result.put("msg", "ok");
                //订单状态
                int transstatus = Integer.valueOf(responseJSON.getString("transstatus"));
                int bill_state = 0;
                /**
                 * 转化支付状态，微信和系统记录的支付状态不一致
                 * 微信：00 成功；07 待处理；08 订单已关闭；09 订单已撤销；10 订单已退款；15 订单支付未支付；16 用户支付中；其他 失败
                 * 系统：0 未支付 1 已支付 2 超时/撤销/支付失败/..(不需要再继续查询的状态) 3 已退款
                 */
                switch (transstatus) {
                    case 0://支付成功
                        bill_state = 1;
                        break;
                    case 7:
                    case 15:
                    case 16://未支付完成
                        bill_state = 0;
                        break;
                    case 10://已经退款订单
                        bill_state = 3;
                        break;
                    default://默认为支付失败订单
                        bill_state = 2;
                        break;
                }

                //总金额
                int total_amount = Integer.parseInt(responseJSON.getString("total_amount"));
                //商家优惠金额
                int mdiscount_amount =responseJSON.getString("mdiscount_amount").trim().equals("")?0: Integer.parseInt(responseJSON.getString("mdiscount_amount"));
                //平台优惠金额
                int discount_amount = responseJSON.getString("discount_amount").trim().equals("")?0: Integer.parseInt(responseJSON.getString("discount_amount"));
                //其他优惠金额
                int othdiscount_amount =  responseJSON.getString("othdiscount_amount").trim().equals("")?0:Integer.parseInt(responseJSON.getString("othdiscount_amount"));
                //总优惠金额
                int coupon_fee = mdiscount_amount + discount_amount + othdiscount_amount;


                //订单总金额
                orderInfo.put("f_total_fee", total_amount);

                //行内系统订单号
                orderInfo.put("f_transaction_id", responseJSON.get("merchantseqno"));
                //总优惠金额

                //支付完成时间
                orderInfo.put("f_time_end", responseJSON.get("transdatetime"));
                //订单状态
                orderInfo.put("f_bill_state", String.valueOf(bill_state));

                //总优惠金额
                orderInfo.put("f_coupon_fee", coupon_fee);
                result.put("orderInfo", orderInfo);
                result.put("out_trade_no", responseJSON.getString("out_trade_no"));
                //订单状态
                result.put("pay_status", bill_state);
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "查询请求失败：" + responseJSON.getString("ReturnMsg"));
            }
        } catch (Exception e) {
            log.error("查询请求异常:" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "查询请求异常：" + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 支付宝订单查询
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject orderQueryByAliPay(JSONObject config, JSONObject data) {
        JSONObject responseJSON = new JSONObject();
        JSONObject result = new JSONObject();
        try {
            JSONObject params = new JSONObject();
            params.put("ThirdCode", "000432");
            params.put("mer_id", config.getString("merchId"));
            params.put("device_id", data.getString("device_id"));
            params.put("out_trade_no", data.getString("out_trade_no"));
            params.put("oldmerchantdatetime", data.getString("merchantdatetime"));
            params.put("oldmerchantorigseqno", data.getString("f_out_trade_no"));
            params.put("oldmerchantorigdate", data.getString("merchantdate"));
            //发送报文
            log.debug("发送==>" + params);

            //---------------------//

//
//            JSONObject orderInfo = new JSONObject();
//
//            orderInfo.put("f_return_code", "000000");
//            orderInfo.put("f_return_msg", "支付成功");
//
//                //订单状态
//            orderInfo.put("f_bill_state",String.valueOf(1));
//            result.put("orderInfo",orderInfo);
//            result.put("code", 200);
//            result.put("msg", "ok");
//                //订单状态
//            result.put("pay_status", 1);

            //---------------------//
             responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);
            String retCode = responseJSON.getString("ReturnCode");
            if (retCode.equals("000000")) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                JSONObject orderInfo = new JSONObject();
                result.put("code", 200);
                result.put("msg", "ok");
                //订单状态
                int transstatus = Integer.valueOf(responseJSON.getString("transstatus"));
                int bill_state = 0;
                /**
                 * 转化支付状态，微信和系统记录的支付状态不一致
                 * 微信：00 成功；07 待处理；08 订单已关闭；09 订单已撤销；10 订单已退款；15 订单支付未支付；16 用户支付中；其他 失败
                 * 系统：0 未支付 1 已支付 2 超时/撤销/支付失败/..(不需要再继续查询的状态) 3 已退款
                 */
                switch (transstatus) {
                    case 0://支付成功
                        bill_state = 1;
                        break;
                    case 7://未支付完成
                        bill_state = 0;
                        break;
                    default://默认为支付失败订单
                        bill_state = 2;
                        break;
                }
                orderInfo.put("f_return_code", responseJSON.getString("return_code"));
                orderInfo.put("f_return_msg", responseJSON.getString("return_msg"));

                //订单状态
                orderInfo.put("f_bill_state", String.valueOf(bill_state));
                result.put("orderInfo", orderInfo);
                //订单状态
                result.put("pay_status", bill_state);
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "查询请求失败：" + responseJSON.getString("return_msg"));
            }
        } catch (Exception e) {
            log.error("查询请求异常:" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "查询请求异常：" + e.getMessage());
        }
        return result;
    }

    /**
     * 银联订单查询
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject orderQueryByUnion(JSONObject config, JSONObject data) {
        JSONObject result = new JSONObject();
        JSONObject responseJSON = new JSONObject();
        try {
            JSONObject params = new JSONObject();
            params.put("version_id", "1");
            params.put("ThirdCode", "000455");
            params.put("shopno", config.getString("merchId"));
            params.put("terminal", data.getString("device_id"));
            params.put("orderNo", data.getString("f_out_trade_no"));
            params.put("orderTime", data.getString("merchantdatetime"));
            params.put("qr_code",  data.getString("out_trade_no"));

            //发送报文
            log.debug("发送==>" + params);

            //---------------------//

//            JSONObject orderInfo = new JSONObject();
//
//            orderInfo.put("f_return_code", "000000");
//            orderInfo.put("f_return_msg", "支付成功");
//
//            //订单状态
//            orderInfo.put("f_bill_state",String.valueOf(1));
//            result.put("orderInfo",orderInfo);
//            result.put("code", 200);
//            result.put("msg", "ok");
//            //订单状态
//            int transstatus = Integer.valueOf("00");
//
//            result.put("f_return_code", "00");
//            result.put("f_return_msg", "支付成功");
//
//            //订单状态
//            result.put("pay_status", 1);

            //---------------------//


             responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);
            String retCode = responseJSON.getString("ReturnCode");
            if (retCode.equals("000000")) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                result.put("code", 200);
                result.put("msg", "ok");
                //订单状态
                int transstatus = Integer.valueOf(responseJSON.getString("payStatus"));
                int bill_state = 0;
                /**
                 * 转化支付状态，微信和系统记录的支付状态不一致
                 * 微信：00 成功；07 待处理；08 订单已关闭；09 订单已撤销；10 订单已退款；15 订单支付未支付；16 用户支付中；其他 失败
                 * 系统：0 未支付 1 已支付 2 超时/撤销/支付失败/..(不需要再继续查询的状态) 3 已退款
                 */
                switch (transstatus) {
                    case 0://支付成功
                        bill_state = 1;
                        break;
                    case 2://未支付完成
                        bill_state = 0;
                        break;
                    default://默认为支付失败订单
                        bill_state = 2;
                        break;
                }
                JSONObject orderInfo = new JSONObject();

                orderInfo.put("f_return_code", responseJSON.getString("payStatus"));
                orderInfo.put("f_return_msg", responseJSON.getString("payDesc"));

                //订单状态
                orderInfo.put("f_bill_state", String.valueOf(bill_state));

                result.put("orderInfo", orderInfo);
                result.put("f_return_code", responseJSON.getString("payStatus"));
                result.put("f_return_msg", responseJSON.getString("ReturnMsg"));
                //订单状态
                result.put("pay_status", bill_state);
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "查询请求失败：" + responseJSON.getString("ReturnMsg"));
            }
        } catch (Exception e) {
            log.error("查询请求异常:" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "查询请求异常：" + e.getMessage());
        }
        return result;
    }

    /**
     * 农商行退款
     *
     * @param config
     * @return
     */
    public static JSONObject refund(JSONObject config, JSONObject data) {
        String deviceId=data.getString("device_id");
        if(deviceId!=null){
            data.put("org_device_id",deviceId);
            String newDeviceId=deviceId.substring(deviceId.length()-8,deviceId.length());
            data.put("device_id",newDeviceId);
        }
        String payway = data.getString("pay_way");
        if ("wx".equals(payway)) {
            return refundWX(config, data);
        } else if ("ali".equals(payway)) {
            return refundAliPay(config, data);
        } else {
            return refundUnion(config, data);
        }
    }

    /**
     * 微信订单退款
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject refundWX(JSONObject config, JSONObject data) {
        JSONObject responseJSON = new JSONObject();
        JSONObject result = new JSONObject();
        try {
            JSONObject params = new JSONObject();
            params.put("ThirdCode", "000442");
            params.put("mer_id", config.getString("merchId"));
            params.put("device_id", data.getString("device_id"));
            params.put("oldmerchantorigseqno", data.getString("f_out_trade_no"));
            params.put("oldmerchantdatetime", data.getString("merchantdatetime"));
            params.put("oldmerchantorigdate", data.getString("merchantdate"));
            params.put("transamount", data.getInt("money"));
            params.put("out_trade_no", data.getString("out_trade_no"));
            params.put("out_trade_date","");
            log.debug("退款请求参数为：" + params.toString());


            //---------------------------------//

//            result.put("code", 200);
//            result.put("msg", "ok");
//            log.debug("退款申请成功ReturnMsg!");


            //-----------------------------------//

             responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);
            int rtCode = Integer.valueOf(responseJSON.getString("ReturnCode"));
            if (rtCode == 0) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                result.put("code", 200);
                result.put("msg", "ok");
                log.debug("退款申请成功ReturnMsg:" + responseJSON.getString("ReturnMsg"));
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "退款请求失败：" + responseJSON.getString("ReturnMsg"));
            }
        } catch (Exception e) {

            log.error("退款请求异常:" + e.getMessage());
            e.printStackTrace();
            result.put("code", 500);
            result.put("msg", "退款请求异常：" + e.getMessage());
        }
        return result;
    }

    /**
     * 支付宝订单退款
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject refundAliPay(JSONObject config, JSONObject data) {
        JSONObject responseJSON = new JSONObject();
        JSONObject result = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("ThirdCode", "000443");
        params.put("mer_id", config.getString("merchId"));
//        params.put("device_id",data.getString("f_terminal_num"));
        params.put("device_id", data.getString("device_id"));
        params.put("oldmerchantorigseqno", data.getString("f_out_trade_no"));
        params.put("oldmerchantorigdate", data.getString("merchantdate"));
        params.put("out_trade_no", data.getString("f_out_trade_no"));
        params.put("refund_reason", "还钱");
        params.put("out_request_no","退款000123");
        params.put("goods_id", config.getString("goods_id"));
        params.put("goods_name", config.getString("goods_name"));
        params.put("refund_amount", data.getInt("money"));
        params.put("quantity", config.getString("quantity"));
        params.put("price", data.getInt("money"));

        try {

            //---------------------------------//

//            result.put("code", 200);
//            result.put("msg", "ok");
//            log.debug("退款申请成功ReturnMsg!");


            //-----------------------------------//


             responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);

            int rtCode = Integer.valueOf(responseJSON.getString("ReturnCode"));
            if (rtCode == 0) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                result.put("code", 200);
                result.put("msg", "ok");
                log.debug("退款申请成功ReturnMsg:" + responseJSON.getString("ReturnMsg"));
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "退款请求失败：" + responseJSON.getString("ReturnMsg"));
            }
        } catch (Exception e) {
            log.error("退款请求异常:" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "退款请求异常：" + e.getMessage());
        }
        return result;
    }

    /**
     * 银联订单退款
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject refundUnion(JSONObject config, JSONObject data) {

        JSONObject result = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("version_id", "1");
        params.put("ThirdCode", "000457");
        params.put("transtype", "999008");
        params.put("origOrderNo", data.getString("f_out_trade_no"));
        params.put("origOrderDate", data.getString("merchantdatetime"));
        params.put("amount", data.getInt("money"));
        params.put("orderTime",data.getString("merchantdatetime"));
        params.put("shopno", config.getString("merchId"));
        params.put("terminal", data.getString("device_id"));
        String orderNumber = config.getString("merchId")
                + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())
                .toString();
        params.put("orderNo", orderNumber);
        String orderTime = new SimpleDateFormat("yyyyMMddHHmmss")
                .format(new Date());
        params.put("orderTime", orderTime);
        try {


            //---------------------------------//

//            result.put("code", 200);
//            result.put("msg", "ok");
//            log.debug("退款申请成功ReturnMsg!");


            //-----------------------------------//


            JSONObject responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);

            int rtCode = Integer.valueOf(responseJSON.getString("ReturnCode"));
            if (rtCode == 0) {
                //业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
                result.put("code", 200);
                result.put("msg", "ok");
                log.debug("退款申请成功ReturnMsg:" + responseJSON.getString("payDesc"));
            } else {
                //失败
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("msg", "退款请求失败：" + responseJSON.getString("payDesc"));
            }
        } catch (Exception e) {
            log.error("退款请求异常:" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "退款请求异常：" + e.getMessage());
        }
        return result;
    }

    /**
     * 农商行转化报文并发送模块，报文格式JSON
     *
     * @param url 请求的url
     * @return result 发送的结果
     */
    private static JSONObject rcbPostData(String url, JSONObject params) {
        JSONObject responseJSON = new JSONObject();
        HttpPlugin httpPlugin = new HttpPlugin();
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher d = p.matcher(params.toString());
        String dataStr = d.replaceAll("");
//        responseJSON = httpPlugin.post(url, dataStr);
        responseJSON.put("code", 200);

        return responseJSON;
    }


    /**
     * z被扫下单，支付方式：微信，支付宝，银联
     *
     * @param data
     * @return
     */
    public static JSONObject payOnline(JSONObject config, JSONObject data) {

        String deviceId=data.getString("device_id");
        if(deviceId!=null){
            data.put("org_device_id",deviceId);
            String newDeviceId=deviceId.substring(deviceId.length()-8,deviceId.length());
            data.put("device_id",newDeviceId);
        }
        JSONObject obj = null;
        try {
            log.debug("在线支付传入参数:" + data);
            String payWay = data.getString("payway");
            if ("wx".equals(payWay)) {
                obj = payOnlineByWX(config, data);
            } else if ("ali".equals(payWay)) {
                obj = payOnlineByAliPay(config, data);
            } else {
                obj = payOnlineByUnion(config, data);
            }

        } catch (Exception e) {
            log.error("支付报错:"+e.getMessage());
            e.printStackTrace();
        }
        return obj;
    }


    /**
     * 微信客户被扫下单
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject payOnlineByWX(JSONObject config, JSONObject data) throws IOException {


        JSONObject result = new JSONObject();
        JSONObject params = new JSONObject();
        String time_start = PayUtil.getNowDate("yyyyMMddHHmmss");
        //此订单100s后过期
        String time_expire = PayUtil.getDateAfterSeconds("yyyyMMddHHmmss", time_start, 100);
        JSONObject posOrgConfig=PayUtil.getPosOrgConfig(module);

        // 清空JSONObject
        params.put("tellerid", data.getString("device_id"));
        params.put("ThirdCode", "000438");
        params.put("mer_id", config.getString("merchId"));
        params.put("device_id", data.getString("device_id"));
        params.put("describe", config.getString("describe"));
        params.put("total_fee", data.getString("total_fee"));
        params.put("fee_type", "CNY");
        params.put("bodydesc", config.getString("bodydesc"));
        params.put("spbill_create_ip", data.getString("spbill_create_ip"));
        //支付授权码
        params.put("auth_code", data.getString("auth_code"));
        params.put("goods_id", config.getString("goods_id"));
        params.put("goods_name", config.getString("goods_name"));
        params.put("quantity", config.getString("quantity"));
        params.put("price", data.getString("price"));
        params.put("shopseq", posOrgConfig.getJSONObject(data.getString("org_device_id")).getString("tenimalid"));
        params.put("shopname", posOrgConfig.getJSONObject(data.getString("org_device_id")).getString("outlets"));
        params.put("mac", data.getString("mac"));


        log.debug("发起交易请求参数params集合：" + params.toString());


        //---------------------//


//        result.put("f_bill_state","00");
//        result.put("code",200);
//        result.put("merchantdate", PayUtil.getNowDate("yyyyMMdd"));
//        result.put("merchantdatetime", PayUtil.getNowDate("HHmmss"));
//        result.put("merchantseqno", PayUtil.getNowDate("HHmmss")+"1234567890");
//        result.put("f_time_out",time_expire);

        //---------------------//


        JSONObject responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);

        if (responseJSON != null) {
            if (responseJSON.get("ReturnCode").equals("000000")) {
                log.debug("支付成功");
                result.put("f_bill_state", "00");
                result.put("code", 200);
                result.put("merchantdate", responseJSON.getString("oldmerchantorigdate"));
                result.put("merchantdatetime", "");
                result.put("merchantseqno", responseJSON.getString("oldmerchantorigseqno"));
                result.put("out_trade_no",responseJSON.getString("out_trade_no"));
                result.put("f_time_out", time_expire);
            } else {
                log.error("支付失败");
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("f_bill_state", "01");
                result.put("code", 500);
            }
            result.put("message", responseJSON.get("ReturnMsg"));
        } else {
            result.put("code", 500);
            result.put("f_bill_state", "01");
            result.put("message", "银行未响应！");
            log.error("发起支付请求银行未响应");
        }
        return result;
    }

    /**
     * 支付宝主扫下单
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject payOnlineByAliPay(JSONObject config, JSONObject data) throws IOException {
        JSONObject result = new JSONObject();
        JSONObject params = new JSONObject();
        JSONObject posOrgConfig=PayUtil.getPosOrgConfig(module);

        // 清空JSONObject
//        params.put("tellerid", config.getString("device_id"));
        params.put("ThirdCode", "000439");
        params.put("mer_id", config.getString("merchId"));
        params.put("device_id", data.getString("device_id"));
        params.put("auth_code", data.getString("auth_code"));
        params.put("subject", config.getString("subject"));
        params.put("goods_id", config.getString("goods_id"));
        params.put("goods_name", config.getString("goods_name"));
        params.put("bodydesc", posOrgConfig.getJSONObject(data.getString("org_device_id")).getString("outlets"));
        params.put("quantity", data.getString("quantity"));
        params.put("price", data.getString("price"));
        params.put("total_amount",data.getString("total_fee"));
        params.put("discountable_amount","0");
        params.put("undiscountable_amount",data.getString("total_fee"));

        String time_start = PayUtil.getNowDate("yyyyMMddHHmmss");
        //此订单100s后过期
        String time_expire = PayUtil.getDateAfterSeconds("yyyyMMddHHmmss", time_start, 100);
        log.debug("发起交易请求参数params集合：" + params.toString());


        //---------------------//


//        result.put("f_bill_state","00");
//        result.put("code",200);
//        result.put("merchantdate", PayUtil.getNowDate("yyyyMMdd"));
//        result.put("merchantdatetime", PayUtil.getNowDate("HHmmss"));
//        result.put("merchantseqno", PayUtil.getNowDate("HHmmss")+"1234567890");
//        result.put("f_time_out",time_expire);

        //---------------------//


        JSONObject responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);

        if (responseJSON != null) {
            if (responseJSON.get("ReturnCode").equals("000000")) {
                log.debug("支付成功");
                result.put("f_bill_state", "00");
                result.put("code", 200);
                result.put("merchantdate", responseJSON.getString("oldmerchantorigdate"));
                result.put("merchantseqno", responseJSON.getString("oldmerchantorigseqno"));
                result.put("out_trade_no", responseJSON.getString("out_trade_no"));
                result.put("merchantdatetime", "");
                result.put("f_time_out", time_expire);
            } else {
                log.error("支付失败");
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("f_bill_state", "01");
                result.put("code", 500);
            }
            result.put("message", responseJSON.get("ReturnMsg"));

        } else {
            result.put("f_bill_state", "01");
            result.put("code", 500);
            result.put("message", "银行未响应！");
            log.error("发起支付请求银行未响应");
        }
        return result;
    }

    /**
     * 银联主扫下单
     *
     * @param config
     * @param data
     * @return
     */
    public static JSONObject payOnlineByUnion(JSONObject config, JSONObject data) throws ParseException, IOException, DocumentException, InterruptedException {
        JSONObject result = new JSONObject();
        JSONObject params = new JSONObject();
        // 清空JSONObject
        params.put("transtype", "999007");
        params.put("ThirdCode", "000456");
        params.put("shopno", config.getString("merchId"));
        params.put("terminal", data.getString("device_id"));
        params.put("amount", data.getString("total_fee"));
        String orderTime = new SimpleDateFormat("yyyyMMddHHmmss")
                .format(new Date());
        String orderDate = new SimpleDateFormat("yyyyMMdd")
                .format(new Date());
        params.put("orderTime", orderTime);
        params.put("qrNO", data.getString("auth_code"));
//        params.put("qrNO", "6228849701885947066");
        String orderNumber = config.getString("merchId")
                + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())
                .toString();
        // 商户订单号(最长 32 位,商户需要保证订单的唯一性)
        params.put("orderNo", orderNumber);

        log.debug("发起交易请求参数params集合：" + params.toString());

        String time_start = PayUtil.getNowDate("yyyyMMddHHmmss");
        //此订单100s后过期
        String time_expire = PayUtil.getDateAfterSeconds("yyyyMMddHHmmss", time_start, 100);


        //---------------------//


//        result.put("f_bill_state","00");
//        result.put("code",200);
//        result.put("merchantdate", PayUtil.getNowDate("yyyyMMdd"));
//        result.put("merchantdatetime", orderTime);
//        result.put("merchantseqno", orderNumber);
//        result.put("f_time_out",time_expire);

        //---------------------//


        JSONObject responseJSON = tcpRequest(config.getString("serverIp"), config.getString("port"),params);

        if (responseJSON != null) {
            String code = responseJSON.getString("ReturnCode");
            if ("000000".equals(code)) {//00支付成功,01支付中
                log.debug("支付成功");
                log.debug("支付同步响应报文" + responseJSON.toString());
                result.put("f_bill_state", "00");
                result.put("code", 200);
                result.put("message", responseJSON.get("payDesc"));
                result.put("f_time_out", time_expire);
                result.put("merchantseqno", orderNumber);
                result.put("merchantdatetime", orderTime);
                result.put("merchantdate", orderDate);

                result.put("out_trade_no", responseJSON.getString("qr_code"));



            } else {//支付失败
                log.error("支付失败");
                log.error("请求参数："+params.toString());
                log.error("响应报文："+responseJSON.toString());
                result.put("code", 500);
                result.put("f_bill_state", "失败");
                result.put("message", responseJSON.get("ReturnMsg"));
            }
        } else {
            result.put("f_bill_state", "失败");
            result.put("code", 500);
            result.put("message", "银行未响应！");
            log.error("订单号:" + orderNumber + "发起支付请求银行未响应");
        }
        return result;
    }

    private Map constructAttritebutesMap() {
        Map<String, String> attributes = new HashMap<>();
        attributes.put("templatecode", "000129");
        attributes.put("transcode", "PUBINC");
        attributes.put("channelcode", "013");
        attributes.put("channeldate", "20170412");
        attributes.put("templatecode", "00000003");
        attributes.put("channelseq", "00000003");
        attributes.put("brno", "320919900");
        attributes.put("tellerno", "3117");
        attributes.put("terminalno", "320919900B01");
        attributes.put("chktellerno", "pts/2");
        attributes.put("areacode", "110063");
        attributes.put("itemno", "00");
        attributes.put("tradeno", "000081");
        attributes.put("chkdate", "20170728");
        return attributes;
    }

    /**
     * 发起单笔支付交易查询请求
     *
     * @param orderNumber
     * @return
     * @throws FileNotFoundException
     * @throws DocumentException
     * @throws UnsupportedEncodingException
     */
    public Map<String, String> sendPayOrderQuery(JSONObject config, String orderNumber)
            throws FileNotFoundException, DocumentException,
            UnsupportedEncodingException {
        Map<String, String> httpMap = Maps.newTreeMap();
        httpMap.put("version", "2.0");
        httpMap.put("charset", "UTF-8");
        httpMap.put("signMethod", "MD5");
        httpMap.put("transType", "01");
        httpMap.put("payType", "B2C");
        // 商户编号
        httpMap.put("merId", config.getString("merchId"));
        // 查询时间(当前交易发起时间，不能与当前时间相差超过 10 分钟)
        httpMap.put("queryTime", new SimpleDateFormat(
                "yyyyMMddHHmmss").format(new Date()));
        // 商户订单号(最长 32 位,商户需要保证订单的唯一性)
        httpMap.put("orderNumber", orderNumber);
        httpMap = Tool.addSign(httpMap, config.getString("signkey"));
        String httpPost = HttpClientUtil.httpPost(config.getString("queryUrl"), httpMap, "UTF-8");
        String xml = Tool.readStringXml(httpPost, config.getString("signkey"), "MD5", "UTF-8");
        Map<String, String> resultMap = ParseXML.xmlToMap(xml);
        return resultMap;
    }


    public static JSONObject tcpRequest(String ip,String port,JSONObject data) {
        //创建套接字对象,去请求服务器的ServerSocket
        Socket socket = new Socket();
        BufferedWriter writer = null;
        BufferedReader br = null;
        String line=null;
        String result="";
        String res = data.toString()+"gas-request";
        try {
            log.debug("请求服务器---------ip:"+ip+",port:"+port);
            log.debug("请求参数:"+res);
            socket.connect(new InetSocketAddress(ip,Integer.valueOf(port)),30000);
            socket.setSoTimeout(120000);
            socket = new Socket(ip, Integer.valueOf(port));           //获得输出流
            br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter pw = new PrintWriter(socket.getOutputStream());
            pw.print(res);
            pw.flush();
            while ((line=br.readLine())!=null) {
                result+=line;
            }
            log.debug("socket响应数据为："+result);
            return new JSONObject(result);
        } catch (Exception e) {
            log.error("socket获取数据出错:"+e.getMessage());
            e.printStackTrace();
        } finally {
            try {
                if (writer != null)
                    writer.close();
                if (socket != null)
                    socket.close();
                if(br!=null){
                    br.close();
                }
            } catch (IOException e) {
                log.error("scoket流关闭出错:"+e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void testRefoundWX() {
        JSONObject config=new JSONObject();
        JSONObject data=new JSONObject();
        data.put("f_out_trade_no","0000678768");
        data.put("merchantdatetime","");
        data.put("merchantdate","20191114");
        data.put("out_trade_no","V201911140082910267");
        data.put("money","13000");
        config.put("merchId", "924318249000001");
        data.put("device_id", "90001108");
        config.put("serverIp","10.0.1.2");
        config.put("port","30602");
        System.out.println("result:"+RcbUtil.refundWX(config,data).toString());
    }
    public static void testRefoundAlipay() {
        JSONObject config=new JSONObject();
        JSONObject data=new JSONObject();
        data.put("f_out_trade_no","0000678770");
        data.put("merchantdatetime","");
        data.put("merchantdate","20191114");
        data.put("out_trade_no","0000678770");
        data.put("money","26000");
        config.put("merchId", "924318249000001");
        data.put("device_id", "90001108");
        config.put("serverIp","10.0.1.2");
        config.put("port","30602");
        config.put("goods_id","rh001");
        config.put("goods_name","天然气100");
        config.put("quantity","1");
        System.out.println("result:"+RcbUtil.refundAliPay(config,data).toString());
    }
    public static void testQuery() {
        JSONObject config=new JSONObject();
        JSONObject data=new JSONObject();
        data.put("f_out_trade_no","0000003700");
        data.put("merchantdatetime","");
        data.put("merchantdate","20191017");
        data.put("out_trade_no","V201910170001951835");
        data.put("money","260");
        config.put("merchId", "903210000000011");
        data.put("device_id", "93230001");
        config.put("serverIp","10.0.1.2");
        config.put("port","30602");
        System.out.println("result:"+RcbUtil.refundWX(config,data).toString());
    }


    public static String getOutlets(String deviceId){
        JSONObject posOrgConfig=PayUtil.getPosOrgConfig(module);
        String outlets=posOrgConfig.getJSONObject(deviceId).getString("outlets");
        deviceId=deviceId.substring(deviceId.length()-4,deviceId.length());
        outlets+="-"+deviceId;
        return outlets;
    }

    /**
     * 盱眙农商行聚合支付
     * @param seandData
     * @param url
     * @return qrCodeResult
     */
    public  static JSONObject httpsPost(JSONObject seandData,String url)  {
        try {
            HttpClient httpclient = new SSLClient();
            HttpPost postRequest = new HttpPost(url);


            postRequest.setEntity(new StringEntity(seandData.toString(), "UTF-8"));

            HttpResponse httpResponse = httpclient.execute(postRequest);

            int StatusCode = httpResponse.getStatusLine().getStatusCode();
            if (StatusCode != 200) {//
                throw new RuntimeException("农商行请求失败，错误代码:" + StatusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            JSONObject result=new JSONObject(rs);
            return result;
        }catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
