package com.aote.rs;

import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;

import com.aote.ccb_ronglian.AppUtils;
import com.aote.ccb_ronglian.CcbUtil;
import com.aote.ccb_ronglian.HttpClientUtil;
import com.aote.ccb_ronglian.Tool;
import com.aote.icbc_chengran.Qrcode;
import com.aote.logic.LogicServer;
import com.aote.utils.HttpPlugin;
import com.aote.utils.PayUtil;
import com.aote.wft.XmlUtils;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.Base64;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.aote.utils.QRCodeUtil;

@Path("/pay")
@Component
@Transactional
public class PayService {
	@Autowired
	LogicServer logicServer ;

	static Logger log = Logger.getLogger(PayService.class);


	/**
	 * 生成二维码图片
	 * @param resp
	 * @param req
	 * @throws Exception
	 */
	@GET
	@Path("/paintCode")
	public void paintCode(@Context HttpServletResponse resp, @Context HttpServletRequest req)
			throws Exception
	{
		resp.setContentType("image/jpeg;charset=utf-8");
		OutputStream output = resp.getOutputStream();
		String url = req.getParameter("url");
		log.debug("二维码生成前链接"+url);
		url = url.replace("|", "&").replace("{","%7B").replace("\"","%22").replace(":","%3A")
				.replace("}", "%7D").replace(",", "%2C").replace("%2F", "/").replace("%3A//", "://");
		QRCodeUtil.encode(url, output);
		log.debug("二维码生成后链接：" + url);
		output.close();
	}
	@GET
	@Path("/paintCommonCode")
	public void paintCode2(@Context HttpServletResponse resp, @Context HttpServletRequest req)
			throws Exception
	{
		resp.setContentType("image/jpeg;charset=utf-8");
		OutputStream output = resp.getOutputStream();
		String url = req.getParameter("url");
		log.debug(url);
		QRCodeUtil.encode(url, output);
		log.debug("二维码链接：" + url);
		output.close();
	}

	@GET
	@Path("/paintCommonCodes")
	public void getCode(@Context HttpServletResponse resp, @Context HttpServletRequest req) throws IOException {
		// 设置响应流信息
		resp.setContentType("image/jpeg;charset=utf-8");

		OutputStream stream = resp.getOutputStream();
		log.debug("查看stream"+stream);

		//type是1，生成活动详情、报名的二维码，type是2，生成活动签到的二维码
		String content = req.getParameter("url");
		String x = req.getParameter("X");
		String t = req.getParameter("T");
		String p = req.getParameter("P");
		String i = req.getParameter("I");
		String n = req.getParameter("N");
		String l = req.getParameter("L");


		String url = content + "&X="+ x + "&T="+ t + "&P="+ p + "&I="+ i + "&N="+ n + "&L="+ l;
		log.debug("url"+url);
		//获取一个二维码图片
		BitMatrix qrCode2 = Qrcode.createQrCode2(url, stream);
//		String path = FileSystemView.getFileSystemView().getHomeDirectory() + File.separator + "testQrcode";
//		String fileName = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".jpg";
//		String qrCode = Qrcode.createQrCode(url, path, fileName);
//		log.debug("文件路径"+qrCode);
//		//以流的形式输出到前端
//		MatrixToImageWriter.writeToStream(bitMatrix , "jpg" , stream);
	}


	@POST
	@Path("/xyhfbackinfo")
	public  void xyhfPayBack(@Context HttpServletRequest request,
							   @Context HttpServletResponse response){

			String returnStr = "";
			PrintWriter out = null;
			log.debug("西银惠付异步回调");
		try {
			out= response.getWriter();
			boolean ischeck = false;

			// 获取异步通知数据
			InputStream ins = request.getInputStream();
			BufferedReader br = new BufferedReader(new InputStreamReader(ins,
					"utf-8"));
			String backinfo = br.readLine();
			log.debug("回调报文："+backinfo);
			JSONObject json = new JSONObject(backinfo);
			String result = logicServer.run("xyhfPayBack", json).toString();
			log.debug("西银惠付回调执行业务逻辑结果："+result);
			returnStr = "{\"H_RSP_CODE\": \"1\",\"H_RSP_MSG\":\"success\"}";
		} catch (Exception e) {
			returnStr = "{\"H_RSP_CODE\": \"0\",\"H_RSP_MSG\":\"erro\"}";

			log.debug("西银惠付回调处理异常:" + returnStr + ","+e.getMessage());
			//					e.printStackTrace();
		} finally{
			if(out != null){
				out.print(returnStr);
				out.close();
			}
		}
	}

	@POST
	@Path("/sxxhbackinfo")
	public  String sxxhPayBack(@Context HttpServletRequest request,
			@Context HttpServletResponse response,String value){
		log.debug("sxxhPayBack===>" + value);
		String result = "";
		try {
			 result = logicServer.run("sxxhPayBack", value).toString();
		} catch (Exception e) {
			log.error(e.getMessage());
		}
		return result;
	}

	@POST
	@Path("/icbcbackinfo")
	public String icbcPayBack(@Context HttpServletRequest request,
							  @Context HttpServletResponse response,String value){
		try{
			log.debug("icbcPayBack===>"+ value);

			String  decodeStr = URLDecoder.decode(value,"utf-8");
			JSONObject data = PayUtil.Query2json(decodeStr);

			String result = logicServer.run("icbcPayBack", data).toString();
			return result;
		}catch(Exception e){
			log.error("icbcPayBack===>" + e.getMessage());
		}
		return "";
	}
	@POST
	@Path("/ningxiaccbbackinfo")
	public void ningxiaccbPayBack(@Context HttpServletRequest request,
							  @Context HttpServletResponse response){
		try {
		Map<String,String[]> requestMap = request.getParameterMap();
		//获取到的map中value为String[],需要进行处理
		Map<String,String> map = HttpPlugin.parseRequestParamMap(requestMap);
		Gson gson = new Gson();
		JSONObject data = new JSONObject(gson.toJson(map));
		String result = "";
		log.debug("ningxiaccbbackinfoJson===>" + data.toString());
			result = logicServer.run("ningxiaccbPayBack", data).toString();
		} catch (Exception e) {
			log.error("ningxiaccbbackinfoErro===>" + e.getMessage());
		}

	}
	@POST
	@Path("/ccbbackinfo")
	public void ccbPayBack(@Context HttpServletRequest request,
								  @Context HttpServletResponse response,String value){
		try {
			Map<String,String[]> requestMap = request.getParameterMap();
			//获取到的map中value为String[],需要进行处理
			Map<String,String> map = HttpPlugin.parseRequestParamMap(requestMap);
			Gson gson = new Gson();
			JSONObject data = new JSONObject(gson.toJson(map));
			String result = "";
			log.debug("ccbbackinfoJson===>" + data.toString());
			result = logicServer.run("ccbPayBack", data).toString();
		} catch (Exception e) {
			log.error("ccbbackinfoErro===>" + e.getMessage());
		}

	}
	@POST
	@Path("/wftbackinfo")
	public void wftPayBack(@Context HttpServletRequest request,
			@Context HttpServletResponse response){
		boolean check = false;
		PrintWriter pw = null;
		String respString = "success";
		try {
			request.setCharacterEncoding("utf-8");
			response.setCharacterEncoding("utf-8");
			response.setHeader("Content-type", "text/html;charset=UTF-8");
			pw = response.getWriter();
			String reqString = XmlUtils.parseRequst(request);
			JSONObject data = XmlUtils.toJson(reqString.getBytes(), "utf-8");
			log.debug("wft接收到支付回调data："+data);
			String result = logicServer.run("wftPayBack", data).toString();
			JSONObject ret = new JSONObject(result);
			if(ret.getInt("code")!= 200){
				respString= ret.getString("msg");
			}
			pw.write(respString);
		} catch (Exception e) {
			pw.write("fail");
			log.debug("接收支付结果错误，失败原因："+e.getMessage());
		}finally {
			if(pw!= null)
				pw.close();
		}
	}

	/**
	 * 接收生成文件是否成功异步通知
	 *
	 * @param str
	 * @return
	 */
	@POST
	@Path("/yulinccbbackinfo")
	public void buildFileAsynResponse(@Context HttpServletRequest request,
									  @Context HttpServletResponse response,String str) {
		log.debug("对账单异步通知："+str);
		Tool tool = new Tool();
		JSONObject config = PayUtil.getConfig("yulinyc");
		Map<String, String> map = Maps.newHashMap();
		AppUtils.convertRetToMap(str, map);
		if ("1".equals(map.get("fileStatus"))) {// 文件生成成功
			map = CcbUtil.getDownFileMap(map.get("billDate"), map.get("billType"), map
					.get("fileName"),map.get("merId"));

			map = tool.addSign(map,config.getString("signkey"));
			log.debug("发起下载文件请求map参数集合："+map.toString());
			String res = HttpClientUtil.httpPost(config.getString("billDownloadUrl"),
					map, "UTF-8");
			if (StringUtils.isNotBlank(res)) {
				Map<String, String> responseMap = Maps.newHashMap();
				AppUtils.convertRetToMap(res, responseMap);
				if ("00".equals(responseMap.get("respCode"))) {
					String fileName = responseMap.get("fileName");
					String fileContent = responseMap.get("fileContent");
					String billType = responseMap.get("billType");
					log.debug(fileName + ":对账单下载成功");
					byte[] base64RespByte = new Base64().decode(fileContent);
					int condition = tool.writeFile(config,fileName, base64RespByte);
					if (condition == 0) {
						// 读取文件，并将数组转为JSON格式
						JSONArray array = tool.readFileToJSON(config.getString("accountFileUrl") + fileName);
						log.debug("从"+config.getString("accountFileUrl") + fileName+"读取的JSONArray："+array.toString());
						if (array != null) {
							// 读取成功后存储到数据库中
							if("02".equals(billType)){//交易对账单
								JSONObject data = new JSONObject();
								data.put("rows",array);
								log.debug(fileName+"：为交易对账单，savePayDetailToDB()");
								try {
									String result = logicServer.run("saveCcbBankPayment",data).toString();
									JSONObject ret = new JSONObject(result);
									if(ret.getInt("code")== 200){
										log.debug("交易对账单保存成功");
									}else{
										log.debug("交易对账单保存失败");
									}
								} catch (Exception e) {
									log.debug("保存交易对账单失败，失败原因："+e.getMessage());
								}
//								tool.savePayDetailToDB(array, "t_bank_payment");
							}else if("03".equals(billType)){//退款对账单
								log.debug(fileName+"：为退款对账单，saveRefundDetailToDB()");
							}else if("01".equals(billType)){//清算对账单
								log.debug(fileName+"：为清算对账单");
							}
						}
					}
				} else {
					log.debug("对账单下载失败,respMsg=" + responseMap.get("respMsg"));
				}
			}
		} else {
			log.debug("对账单生成失败");
		}
	}
	/**
	 * 招行聚合支付-支付回调
	 * @param request
	 * @param response
	 * @return
	 */
	@GET
	@Path("/cmbPayBack")
	public  String zhydPayBack(@Context HttpServletRequest request,
							   @Context HttpServletResponse response){
		String result = "notify_success";
		try {

			String str = request.getQueryString();
				logicServer.run("cmbPayBack", PayUtil.Query2json(str));
		} catch (Exception e) {
			result = "notify_fail";
			log.error(e.getMessage());
		}
		return result;
	}

}
