package com.aote.ningxiaccb;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.junit.Test;
import org.xml.sax.InputSource;


import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

public class CcbPayUtil {
    static Logger log = Logger.getLogger(CcbPayUtil.class);

    //生成订单号
    // 最长30位。
    //建议按以下规则生成订单号：商户代码后9位+自定义字符串（不超21位）；
    //字符串可包含数字、字母、下划线；
    //商户需保证订单号唯一。
    public static String getOrderNum(String merchId){
        String subfix = System.currentTimeMillis()+"";
        String orderNum = merchId.substring(6)+ new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())+subfix.substring(subfix.length()-7);
        return orderNum;
    }

    public static String sign(JSONObject data,JSONObject config){
        StringBuffer tmp = new StringBuffer(); //验签字段
        tmp.append("MERCHANTID=");
        tmp.append(data.get("MERCHANTID"));
        tmp.append("&POSID=");
        tmp.append(data.get("POSID"));
        tmp.append("&BRANCHID=");
        tmp.append(data.get("BRANCHID"));
        tmp.append("&ORDERID=");
        tmp.append(data.get("ORDERID"));
        tmp.append("&PAYMENT=");
        tmp.append(data.get("PAYMENT"));
        tmp.append("&CURCODE=");
        tmp.append(data.get("CURCODE"));
        tmp.append("&TXCODE=");
        tmp.append(data.get("TXCODE"));
        tmp.append("&REMARK1=");
        tmp.append(data.get("REMARK1"));
        tmp.append("&REMARK2=");
        tmp.append(data.get("REMARK2"));
        tmp.append("&RETURNTYPE=");
        tmp.append(data.get("RETURNTYPE"));
        tmp.append("&TIMEOUT=");
        tmp.append(data.get("TIMEOUT"));
        tmp.append("&PUB=");
        tmp.append(config.get("Pub"));//商户公钥后30位
        log.debug(tmp.toString());
        return md5Str(tmp.toString(),0);
    }
    /**
     * 计算消息摘要。
     * @param offset 数据偏移地址。
     * @return 摘要结果。(16字节)
     */
    public static String md5Str(String str, int offset)
    {
        try
        {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] b = str.getBytes("UTF8");
            md5.update(b, offset, b.length);
            return byteArrayToHexString(md5.digest());
        }
        catch (NoSuchAlgorithmException ex)
        {
            ex.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException ex)
        {
            ex.printStackTrace();
            return null;
        }
    }

    /**
     *
     * @param b byte[]
     * @return String
     */
    public static String byteArrayToHexString(byte[] b)
    {
        String result = "";
        for (int i = 0; i < b.length; i++)
        {
            result += byteToHexString(b[i]);
        }
        return result;
    }

    private static String[] hexDigits =
            {
                    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b",
                    "c", "d", "e", "f"};

    /**
     * 将字节转换为对应的16进制明文
     * @param b byte
     * @return String
     */
    public static String byteToHexString(byte b)
    {
        int n = b;
        if (n < 0)
        {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String httpGet(String url,String code) {
        log.debug("GetPage:"+url);
        String content = null;
        HttpClient httpClient = new HttpClient();
        //设置header
        httpClient.getParams().setParameter(HttpMethodParams.USER_AGENT,"Mozilla/5.0 (X11; U; Linux i686; zh-CN; rv:1.9.1.2) Gecko/20090803 Fedora/3.5.2-2.fc11 Firefox/3.5.2");
        GetMethod method = new GetMethod(url);
        try {
            int statusCode = httpClient.executeMethod(method);
            log.debug("httpClientUtils::statusCode="+statusCode);
            log.debug(method.getStatusLine());
            content = new String(method.getResponseBody(), code);

        } catch (Exception e) {
            log.debug("time out");
            e.printStackTrace();
        } finally {
            if(method!=null) {
                method.releaseConnection();
                method = null;
                httpClient = null;
            }
        }
        return content;
    }

    public static String httpPost(String url, JSONObject data, String code) {
        log.debug("GetPage:"+url);
        String content = null;

        HttpClient httpClient = new HttpClient();
        //设置header
        httpClient.getParams().setParameter(HttpMethodParams.USER_AGENT,"Mozilla/5.0 (X11; U; Linux i686; zh-CN; rv:1.9.1.2) Gecko/20090803 Fedora/3.5.2-2.fc11 Firefox/3.5.2");

        //代理设置
        //httpClient.getHostConfiguration().setProxy("128.128.176.74", 808);

        PostMethod method = new PostMethod(url);
        Iterator it = data.keySet().iterator();


        while (it.hasNext()) {
            String key = it.next() + "";
            Object o = data.get(key);
            if (o != null && o instanceof String) {
                method.addParameter(new NameValuePair(key, o.toString()));
            }
            if (o != null && o instanceof String[]) {
                String[] s = (String[]) o;
                if (s != null)
                    for (int i = 0; i < s.length; i++) {
                        method.addParameter(new NameValuePair(key, s[i]));
                    }
            }
        }
        try {

            int statusCode = httpClient.executeMethod(method);

            log.debug("httpClientUtils::statusCode="+statusCode);

            log.debug(method.getStatusLine());
            content = new String(method.getResponseBody(), code);

        } catch (Exception e) {
            log.debug("time out");
            e.printStackTrace();
        } finally {
            if(method!=null) {
                method.releaseConnection();
                method = null;
                httpClient = null;
            }
        }
        return content;

    }

    public static String httpPost(String url, JSONObject data) {
        //编码：UTF-8
        return httpPost(url, data, "UTF-8");
    }
    /**
     * 转XMLJSON
     * @author
     * @param xmlBytes
     * @param charset
     * @return
     * @throws DocumentException
     * @throws Exception
     */
    public static JSONObject toJson(byte[] xmlBytes,String charset) throws DocumentException{
        SAXReader reader = new SAXReader(false);
        InputSource source = new InputSource(new ByteArrayInputStream(xmlBytes));
        source.setEncoding(charset);
        Document doc = reader.read(source);
        JSONObject result = toJson(doc.getRootElement());
        return result;
    }
    public static JSONObject toJson(Element element){
        JSONObject result = new JSONObject();
        List<Element> els = element.elements();
        for(Element el : els){

            if(el.elements().size() > 0){
                result.put(el.getName().toUpperCase(), toJson(el));
            } else {
                result.put(el.getName().toUpperCase(), el.getTextTrim());
            }
        }
        return result;
    }
//    public static JSONObject xmlPost(String xml,String requesturl){
//        String encoding = "GB18030";
//        try {
//        HttpClient httpClient = new DefaultHttpClient();
//        HttpPost post = new HttpPost(requesturl);
//        post.addHeader("Content-Type","application/x-www-form-urlencoded");
//        String param = "requestXml="+URLEncoder.encode(xml,encoding);
//        post.setEntity(new StringEntity(param.toString(), encoding));
//        HttpResponse response = httpClient.execute(post);
//
//        int code = response.getStatusLine().getStatusCode();
//        log.debug("状态码"+code);
//
//        } catch (Exception e) {
////            // TODO Auto-generated catch block
////            throw new RuntimeException(e);
//        }
//    }
    /**
     * 根据建行demo发送请求
     * @param xml
     * @param requesturl
     * @return
     */
    public static JSONObject xmlConnPost (String xml,String requesturl){
        OutputStream out = null;
        BufferedReader bf = null;
        JSONObject json = new JSONObject();
        try {
            String encoding = "GB18030";
            String param = "requestXml="+URLEncoder.encode(xml,encoding);
            URL url = new URL(requesturl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置超时时间
            conn.setConnectTimeout(10 * 1000);
            //打开读写数据
            conn.setDoOutput(true);
            conn.setDoInput(true);
            //设置请求头
            conn.addRequestProperty("Content-Type","application/x-www-form-urlencoded");
            conn.addRequestProperty("Content-Length",String.valueOf(param.length()));
            conn.addRequestProperty("Connection","close");
            //  发送请求
            out = conn.getOutputStream();
            out.write(param.getBytes(encoding));
            out.flush();
            out.close();

            //读取返回数据
            boolean connRet = (conn.getResponseCode() == 200);
            if(connRet){
                bf = new BufferedReader(new InputStreamReader(conn.getInputStream(),encoding));
            }else {
                bf = new BufferedReader(new InputStreamReader(conn.getErrorStream(),encoding));
            }
            String bfLine = null;
            StringBuffer sbf = new StringBuffer();
            while((bfLine = bf.readLine())!= null){
                sbf.append(bfLine);
            }
            log.debug("返回的xml"+sbf.toString());
            if(connRet){
                json = toJson(sbf.toString().getBytes(),encoding);
                json.put("code",200);
            }else {
                json.put("code",500);
                json.put("msg",sbf.toString());
            }
        }catch  (Exception e) {
            json.put("code",500);
            json.put("msg",e.getMessage());
        }finally {
            try{
                if(bf != null){
                    bf.close();
                }
                if (out != null){
                    out.close();
                }
            }catch(IOException e){
                log.debug(e.getMessage());
            }
        }
        return json;
    }
    /**
     * 生成交易序列号
     * @return
     */
    public static String getSerialNum() {
        String ret = System.nanoTime() + "";
        if(ret.length() == 14){
            int num = (new Random()).nextInt(99);
            ret += String.format("%02d", num);
        }
        return ret;
    }
    /**
     * 查询请求xml参数构造
     * @param data
     * @return
     */
    public static String queryXml(JSONObject data){
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1002</TX_CODE>  \n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n" +
                "<START></START>\n" +
                "<STARTHOUR></STARTHOUR>\n" +
                "<STARTMIN></STARTMIN>\n" +
                "<END></END>\n" +
                "<ENDHOUR></ENDHOUR>\n" +
                "<ENDMIN></ENDMIN>\n <KIND>");
        tmpXml.append(data.get("KIND"));
        tmpXml.append("</KIND>\n<ORDER>");
        tmpXml.append(data.get("ORDER"));
        tmpXml.append("</ORDER>\n<ACCOUNT>");
        tmpXml.append("</ACCOUNT>\n<DEXCEL>");
        tmpXml.append(data.get("DEXCEL"));
        tmpXml.append("</DEXCEL>\n<MONEY>");
        tmpXml.append("</MONEY>\n<NORDERBY>");
        tmpXml.append(data.get("NORDERBY"));
        tmpXml.append("</NORDERBY>\n<PAGE>");
        tmpXml.append(data.get("PAGE"));
        tmpXml.append("</PAGE>\n<POS_CODE>");
        tmpXml.append("</POS_CODE>\n<STATUS>");
        tmpXml.append(data.get("STATUS"));
        tmpXml.append("</STATUS>\n<Mrch_No>");
        tmpXml.append("</Mrch_No>\n" +
                "</TX_INFO>\n" +
                "</TX>\n");
        return tmpXml.toString();
    }
    /**
     * 退款请求xml参数构造
     * @param data
     * @return
     */
    public static String refundXml(JSONObject data){
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1004</TX_CODE>  \n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n<MONEY>");
        tmpXml.append(data.get("MONEY"));
        tmpXml.append("</MONEY>\n<ORDER>");
        tmpXml.append(data.get("ORDER"));
        tmpXml.append("</ORDER>\n<REFUND_CODE>");
        tmpXml.append("</REFUND_CODE>\n</TX_INFO>\n" +
                "<SIGN_INFO></SIGN_INFO>\n" +
                "<SIGNCERT></SIGNCERT>\n" +
                "</TX>\n" );
        return tmpXml.toString();
    }

    /**
     * 请求流水文件下载xml参数构造
     * @param data
     * @return
     */
    public static String fileDownloadXml(JSONObject data){
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1005</TX_CODE>\n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n" +
                "<DATE>");
        tmpXml.append(data.get("DATE"));
        tmpXml.append("</DATE>\n<KIND>");
        tmpXml.append(data.get("KIND"));
        tmpXml.append("</KIND>\n<FILETYPE>");
        tmpXml.append(data.get("FILETYPE"));
        tmpXml.append("</FILETYPE>\n<TYPE>0");
        tmpXml.append("</TYPE>\n<NORDERBY>");
        tmpXml.append("</NORDERBY>\n<POS_CODE>");
        tmpXml.append("</POS_CODE>\n<ORDER>");
        tmpXml.append("</ORDER>\n<STATUS>1");
        tmpXml.append("</STATUS>\n<BILL_FLAG>");
        tmpXml.append("</BILL_FLAG>\n<Mrch_No>");
        tmpXml.append("</Mrch_No>\n<GROUP_FLAG>");
        tmpXml.append("</GROUP_FLAG>\n" +
                "</TX_INFO>\n" +
                "</TX>\n");
        return tmpXml.toString();
    }
    /**
     * 文件下载xml参数构造
     * @param data
     * @return
     */
    public static String downloadXml(JSONObject data){
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>6W0111</TX_CODE>\n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n" +
                "<SOURCE>");
        tmpXml.append(data.get("SOURCE"));
        tmpXml.append("</SOURCE>\n<FILEPATH>merchant/shls");
        tmpXml.append("</FILEPATH>\n<LOCAL_REMOTE>");
        tmpXml.append(data.get("LOCAL_REMOTE"));
        tmpXml.append("</LOCAL_REMOTE>\n" +
                "</TX_INFO>\n" +
                "</TX>\n");
        return tmpXml.toString();
    }


    @Test
    public  void testXmlToJson(){
        String xml = "<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n" +
                "<TX>\n" +
                "<REQUEST_SN>2019052117043034</REQUEST_SN>\n" +
                "<CUST_ID>105871000004111</CUST_ID>\n" +
                "<USER_ID>105871000004111-003</USER_ID>\n" +
                "<PASSWORD>nx95533</PASSWORD>\n" +
                "<TX_CODE>5W1002</TX_CODE>  \n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n" +
                "<START></START>\n" +
                "<STARTHOUR></STARTHOUR>\n" +
                "<STARTMIN></STARTMIN>\n" +
                "<END></END>\n" +
                "<ENDHOUR></ENDHOUR>\n" +
                "<ENDMIN></ENDMIN>\n" +
                " <KIND>0</KIND>\n" +
                "<ORDER>00000411120190521170353363</ORDER>\n" +
                "<ACCOUNT></ACCOUNT>\n" +
                "<DEXCEL>1</DEXCEL>\n" +
                "<MONEY></MONEY>\n" +
                "<NORDERBY>1</NORDERBY>\n" +
                "<PAGE>1</PAGE>\n" +
                "<POS_CODE></POS_CODE>\n" +
                "<STATUS>3</STATUS>\n" +
                "<Mrch_No></Mrch_No>\n" +
                "</TX_INFO>\n" +
                "</TX>";
        try {
            JSONObject json = toJson(xml.getBytes(),"GB2312");
            System.out.println(json.toString());
        } catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}
