package com.aote.icbc_chengran;

import com.alibaba.fastjson.JSONArray;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.rs.EntityService;
import com.aote.rs.LogicService;
import com.aote.utils.PayUtil;
import com.jcraft.jsch.*;
import com.jcraft.jsch.ChannelSftp.LsEntry;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Pattern;

/**
 * @author 86151
 */
@Component
@EnableScheduling
public class SFTPIcbcUtil {

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private EntityService entityService;

    @Autowired
    LogicServer logicServer ;

    @Autowired
    LogicService logicService ;

    private static Logger log = Logger.getLogger("SFTPutil");

    private ChannelSftp sftp;
    private Session session;
    /**
     * 用户名
     */
    private String userName;
    //密码，不使用，可忽略
    private String password;
    //私钥地址,自行修改
    private String privateKey;
    //sftp服务器连接IP,自行修改
    private String host;
    //sftp端口号,如不同,可修改
    private int port = 8001;
    //本地存放地址,自行修改
//	private static String localPath = "C:/Users/Desktop/";
    private String localPath;
    //sftp下载路径,自行修改，写到../download/目录下
    private String sftpPath;
    //指定文件名前缀，无前缀可为""
    private String startFormat;
    //指定文件名后缀，无后缀可为""
    private String endFormat;
    //单个下载时，填写文件全名
    private String fileName;


    //基于密码认证的sftp
    public SFTPIcbcUtil(String username, String password, String host, int port) {
        this.userName = username;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    //基于秘钥认证的sftp
    public SFTPIcbcUtil(String username, String host, int port, String privateKey) {
        this.userName = username;
        this.host = host;
        this.port = port;
        this.privateKey = privateKey;
    }

    public SFTPIcbcUtil() {
    }

    //连接sftp服务器
    public void ConnectSftp() {
        try {
            log.setLevel(Level.INFO);
            JSch jsch = new JSch();
            if (privateKey != null) {
                // 设置私钥
                jsch.addIdentity(privateKey);
            }

            session = jsch.getSession(userName, host, port);
            if (log.isInfoEnabled()) {
                log.info("Session created.");
            }
            if (password != null) {
                session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");

            session.setConfig(config);
            session.connect();

            if (log.isInfoEnabled()) {
                log.info("Session connected.");
            }

            Channel channel = session.openChannel("sftp");

            channel.connect();

            sftp = (ChannelSftp) channel;
            try {
                Class channelSftp = ChannelSftp.class;
                Field field = null;
                try {
                    field = channelSftp.getDeclaredField("server_version");
                } catch (NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
                field.setAccessible(true);
                try {
                    field.set(sftp, 2);
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            if (log.isInfoEnabled()) {
                log.info("Connected to " + host + ".");
            }
        } catch (JSchException e) {
            e.printStackTrace();
        }
    }

    //关闭连接server
    public void DisconnectSftp() {
        if (this.sftp != null) {
            if (this.sftp.isConnected()) {
                this.sftp.disconnect();
                if (log.isInfoEnabled()) {
                    log.info("sftp is closed already");
                }
            }
        }
        if (this.session != null) {
            if (this.session.isConnected()) {
                this.session.disconnect();
                if (log.isInfoEnabled()) {
                    log.info("session is closed already");
                }
            }
        }
    }


    public void cd(String directory) throws SftpException {
        if (directory != null && !"".equals(directory) && !"/".equals(directory)) {
            sftp.cd(directory);
        }
    }

    //下载单个文件
    //@param remotePath 		下载目录
    //@param remoteFileName 	下载的文件
    //@param localPath: 		本地保存路径
    //@param localFileName：       保存文件名
    public boolean downloadFile(String remotePath, String remoteFileName, String localPath, String localFileName) {
        log.info("download:" + remotePath + "  downloadFile:" + remoteFileName + "  saveFile:" + localPath);

        FileOutputStream fileoutput = null;
        try {
//			if (directory != null && !"".equals(directory)){
//				sftp.cd(directory);
//			}
            File file = new File(localPath + localFileName);
            fileoutput = new FileOutputStream(file);
            sftp.get(remotePath + remoteFileName, fileoutput);
            if (log.isInfoEnabled()) {
                log.info("===DownloadFile:" + remoteFileName + " success from sftp.");
            }
            return true;
        } catch (SftpException | FileNotFoundException e) {
            e.printStackTrace();

        } finally {
            if (fileoutput != null) {
                try {
                    fileoutput.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }


    //批量下载文件
    //	@param remotePath:远程下载目录（以路径符号结束，可以为相对路径“）
    //	@param localPath： 本地保存目录，以路径符号结束
    //	@param fileFormat： 下载文件格式
    //	@param fileEndFormat: 下载文件格式
    //	@param del: 下载后是否删除sftp文件
    public List<String> batchDownLoadFile(String remotePath, String localPath, String fileFormat, String fileEndFormat, boolean del) throws UnsupportedEncodingException {
        List<String> filenames = new ArrayList<String>();
        try {
            //connect();
            Vector v = listFiles(remotePath);
            //sftp.cd(remotePath);
            if (v.size() > 0) {
                System.out.println("本次处理文件个数不为零，开始下载。。。fileSize=" + v.size());
                Iterator it = v.iterator();
                while (it.hasNext()) {
                    LsEntry entry = (LsEntry) it.next();
                    String filename = entry.getFilename();
                    filename = new String(filename.getBytes("UTF-8"), "UTF-8");
                    SftpATTRS attrs = entry.getAttrs();
                    if (!attrs.isDir()) {
                        boolean flag = false;
                        String localFileName = localPath + filename;
                        fileFormat = fileFormat == null ? "" : fileFormat.trim();
                        fileEndFormat = fileEndFormat == null ? "" : fileEndFormat.trim();
                        //三种情况
                        if (fileFormat.length() > 0 && fileEndFormat.length() > 0) {
                            if (filename.startsWith(fileFormat) && filename.endsWith(fileEndFormat)) {
                                flag = downloadFile(remotePath, filename, localPath, filename);
                                if (flag) {
                                    filenames.add(localFileName);
                                    if (flag) {
                                        filenames.add(localFileName);
                                        if (flag && del) {
                                            deleteSFTP(remotePath, filename);
                                        }
                                    }
                                }
                            }
                        } else if (fileFormat.length() > 0 && "".equals(fileEndFormat)) {
                            if (filename.startsWith(fileFormat)) {
                                flag = downloadFile(remotePath, filename, localPath, filename);
                                if (flag) {
                                    filenames.add(localFileName);
                                    if (flag && del) {
                                        deleteSFTP(remotePath, filename);
                                    }
                                }
                            }
                        } else if (fileEndFormat.length() > 0 && "".equals(fileFormat)) {
                            if (filename.endsWith(fileEndFormat)) {
                                flag = downloadFile(remotePath, filename, localPath, filename);
                                if (flag) {
                                    filenames.add(localFileName);
                                    if (flag && del) {
                                        deleteSFTP(remotePath, filename);
                                    }
                                }
                            }
                        } else {
                            flag = downloadFile(remotePath, filename, localPath, filename);
                            if (flag) {
                                filenames.add(localFileName);
                                if (flag && del) {
                                    deleteSFTP(remotePath, filename);
                                }
                            }
                        }
                    }
                }
            }
            if (log.isInfoEnabled()) {
                log.info("download file is success:remotePath=" + remotePath + "and localPath=" + localPath + ",file size is" + v.size());
            }
        } catch (SftpException e) {
            e.printStackTrace();
        } finally {
            //this.disconnect();
        }
        return filenames;
    }


    //删除本地文件
    public boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        boolean rs = file.delete();
        if (rs && log.isInfoEnabled()) {
            log.info("delete file success from local");
        }
        return rs;
    }


    //删除sftp文件
    public void deleteSFTP(String directory, String deleteFile) {
        try {
            sftp.rm(directory + deleteFile);
            if (log.isInfoEnabled()) {
                log.info("delete file success from sftp");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    //如果目录不存在就创建目录
    public void mkdirs(String path) {
        File f = new File(path);
        String fs = f.getParent();
        f = new File(fs);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    //列出目录下的文件
    public Vector listFiles(String directory) throws SftpException {
        // TODO Auto-generated method stub
        sftp.setFilenameEncoding("utf-8");
        return sftp.ls(directory);
    }


//    @Scheduled(cron = "0 0/3 * * * ? ")
//    @Transactional(rollbackFor = Exception.class)
    public void icbcDownload() {
        HashMap<Integer, String> hashMap = new HashMap<>();
        hashMap.put(0, "yanchuan");
        JSONObject json = new JSONObject();
        for (int i = 0; i < hashMap.size(); i++) {
            json = downloadFileIcbc(hashMap.get(i));
            log.debug("分公司下载账单" + hashMap.get(i));
            System.out.println("分公司下载账单" + hashMap.get(i));
        }
    }

    public JSONObject downloadFileIcbc(String config) {

        JSONObject payConfig = PayUtil.getConfig(config);
        String privateKey = payConfig.getString("idRsa");
        String username = payConfig.getString("username");
        String host = payConfig.getString("host");
        int port = Integer.parseInt(payConfig.getString("port"));
        String sftpPath = payConfig.getString("sftpPath");
        String localPath = payConfig.getString("localPath");
        String endFormat = ".csv";


        SFTPIcbcUtil sftp = null;

        try {
            // 登录sftp服务器
            sftp = new SFTPIcbcUtil(username, host, port, privateKey);
            sftp.ConnectSftp();
            // 获取当前日期的前一天 对账文件为T+1
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Calendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            calendar.add(Calendar.DATE, -1);
            String lastDate = sdf.format(calendar.getTime());
            // 拼接文件名
            String file = lastDate + "_中国工商银行特约商户统一对账单明细清单_260911990050_线下_财务" + endFormat;
            //单个文件下载
            boolean oneFiledown = sftp.downloadFile(sftpPath, file, localPath, file);
            // 如果文件下载成功，解析账单文件，保存数据库
            if (oneFiledown) {
                billParsing(localPath,file);
            } else {
                log.debug("下载账单失败" + false);
            }
            System.out.println("Download file: " + oneFiledown);

        } catch (Exception e) {
            System.out.println(e.getMessage());
        } finally {
            sftp.DisconnectSftp();
        }
        return null;
    }

    /**
     * 下载文件成功后，解析对账文件保存数据
     *
     * @param file
     * @throws FileNotFoundException
     */
    private void billParsing(String localPath, String file) throws FileNotFoundException {
        // 拼接文件路径名称，获取文件
        String csvFile = localPath + file;
        String line = "";
        String cvsSplitBy = ",";
        // 读取文件内容
        DataInputStream in = new DataInputStream(new FileInputStream(new File(csvFile)));
        JSONArray jsonArray = new JSONArray();
        JSONObject json = new JSONObject();
        int flag = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "GBK"))) {
            ArrayList<String> arr = new ArrayList();
            // 跳过前两行数据进行读取，后存放至集合中
            while ((line = br.readLine()) != null) {
                flag++;
                if (flag > 2) {
                    arr.add(line);
                }
            }
            String[] split = new String[0];
            System.out.println("开始保存数据库");
            // 这里不读取文件最后两行
            for (int i = 0; i < arr.size() - 2; i++) {
                // 读取文件每一行后，以逗号分隔进行截取
                split = arr.get(i).split(cvsSplitBy);
                // 截取后的数据通过正则表达式，去除错误内容
                for (int a = 0; a < split.length; a++) {
                    split[a] = prasetoString(split[a]);
                }
                // 遍历每一行数组，获取所需字段保存数据库
                for (int j = 0; j < split.length; j++) {
                    System.out.println("查看数组下标" + j + "：" + split[j]);
                    // 交易时间
                    json.put("f_trade_date", prasetoString(split[1]) + " " + split[2]);
                    // 交易类型
                    json.put("f_trade_type", split[5]);
                    // 订单号
                    json.put("f_serial_id", split[9]);
                    // 总费用
                    json.put("f_total_charge", split[13]);
//                    entityServer.partialSave("t_bank_payment", json.toString());
                    logicServer.run("icbcChengRanSaveBill",json.toString());
                }
            }
            System.out.println("保存数据库结束");
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }


    /**
     * 正则表达式替换特殊字符
     *
     * @param parsestr
     * @return
     */
    private String prasetoString(String parsestr) {
        if (parsestr == null || "".equals(parsestr)) {
            return "";
        }
        String regEx = "(=|\"|\\s*)";
        Pattern p = Pattern.compile(regEx);
        java.util.regex.Matcher m = p.matcher(parsestr);
        return m.replaceAll("").trim();
    }

    {
    }

}
