package com.aote.icbc;


import com.aote.utils.PayUtil;
import com.icbc.api.request.QrcodeRejectRequestV2;
import com.icbc.api.response.QrcodeRejectResponseV2;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;


import com.aote.utils.SHA256withRSAUtil;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.request.QrcodeGenerateRequestV2;
import com.icbc.api.request.QrcodeGenerateRequestV2.QrcodeGenerateRequestV2Biz;
import com.icbc.api.response.QrcodeGenerateResponseV2;

import com.icbc.api.request.QrcodeQueryRequestV2;
import com.icbc.api.request.QrcodeQueryRequestV2.QrcodeQueryRequestV2Biz;
import com.icbc.api.response.QrcodeQueryResponseV2;

import com.icbc.api.request.QrcodeRejectRequestV2;
import com.icbc.api.request.QrcodeRejectRequestV2.QrcodeRejectRequestV2Biz;
import com.icbc.api.response.QrcodeRejectResponseV2;

import java.io.*;

/**
 * 工商银行支付工插件类，所有请求通过工行sdk实现
 * @auther qinlong
 *
 */
public class IcbcUtil {
	static Logger log = Logger.getLogger(IcbcUtil.class);

	/**
	 * 工商银行下单请求
	 * @param config
	 * @param data
	 * @return
	 */
	public static JSONObject getQrcode(JSONObject config,JSONObject data){
		JSONObject result = new JSONObject();
		try {
			log.debug("config==>"+config);
			log.debug("data==>"+data);
			String privateKey = SHA256withRSAUtil.loadKeyByFile(config.getString("privateKey"));
			String publicKey = SHA256withRSAUtil.loadKeyByFile(config.getString("publicKey"));
			log.debug("privateKey==>"+privateKey);
			log.debug("publicKey==>"+publicKey);
			String signType = config.has("signType")?config.getString("signType"):IcbcConstants.SIGN_TYPE_RSA;
			DefaultIcbcClient client = new DefaultIcbcClient(config.getString("appId"), signType, privateKey,publicKey);

			QrcodeGenerateRequestV2 request = new QrcodeGenerateRequestV2();

			//请求url
			log.debug("请求url==>"+config.getString("payUrl"));
			request.setServiceUrl(config.getString("payUrl"));

			QrcodeGenerateRequestV2Biz bizContent = new QrcodeGenerateRequestV2Biz();
			//商户号
			bizContent.setMerId(config.getString("merchId"));
			//e生活档案编号
			bizContent.setStoreCode(config.getString("storeCode"));
			//支付回调地址
			bizContent.setNotifyUrl(config.getString("backUrl"));
			//订单号
			bizContent.setOutTradeNo(data.getString("out_trade_no"));
			//金额
			bizContent.setOrderAmt(data.getString("order_amt"));
			//日期
			bizContent.setTradeDate(data.getString("trade_date"));
			//时间
			bizContent.setTradeTime(data.getString("trade_time"));
			//二维码有效期，单位：秒，必须小于24小时
			bizContent.setPayExpire(data.getString("pay_expire"));
			//商户是否开启通知接口 0-否；1-是，默认值0
			bizContent.setNotifyFlag(data.getString("notify_flag"));
			bizContent.setSpFlag("0");
			bizContent.setTporderCreateIp(data.getString("tporder_create_ip"));
			bizContent.setAttach(data.getString("attach"));

			request.setBizContent(bizContent);
			QrcodeGenerateResponseV2 response;
			response = client.execute(request, "msgId");
			if (response.isSuccess()) {
				//业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据
				result.put("code",200);
				result.put("msg","ok");
				result.put("url",response.getQrcode());
				result.put("f_out_trade_no",data.getString("out_trade_no"));
			} else {
				//失败
				log.debug("ReturnCode:"+response.getReturnCode());
				log.debug("下单请求失败ReturnMsg:"+response.getReturnMsg());
				result.put("code",500);
				result.put("msg","下单请求失败："+response.getReturnMsg());
			}
		} catch (IcbcApiException e) {
			log.debug("下单请求异常:"+e.getMessage());
			result.put("code",500);
			result.put("msg","下单请求异常："+e.getMessage());
		}
		return result;
	}


	/**
	 * 工商银行订单查询
	 * @param config
	 * @param out_trade_no
	 * @return
	 */
	public static JSONObject orderQuery(JSONObject config,String out_trade_no){
		JSONObject result = new JSONObject();
		try {

			String privateKey = SHA256withRSAUtil.loadKeyByFile(config.getString("privateKey"));
			String publicKey = SHA256withRSAUtil.loadKeyByFile(config.getString("publicKey"));

			log.debug("privateKey==>"+privateKey);
			log.debug("publicKey==>"+publicKey);
			String signType = config.has("signType")?config.getString("signType"):IcbcConstants.SIGN_TYPE_RSA;
			DefaultIcbcClient client = new DefaultIcbcClient(config.getString("appId"), signType, privateKey,publicKey);
			QrcodeQueryRequestV2 request = new QrcodeQueryRequestV2();

			//请求url
			log.debug("请求url==>"+config.getString("queryUrl"));
			request.setServiceUrl(config.getString("queryUrl"));

			QrcodeQueryRequestV2Biz bizContent = new QrcodeQueryRequestV2Biz();
			//商户号
			bizContent.setMerId(config.getString("merchId"));

			//订单号
			bizContent.setOutTradeNo(out_trade_no);

			request.setBizContent(bizContent);
			QrcodeQueryResponseV2 response;
			response = client.execute(request, "msgId");
			if (response.isSuccess()) {
				//业务成功处理，请根据接口文档用response.getxxx()获取同步返回的业务数据

				result.put("code",200);
				result.put("msg","ok");
				//订单状态
				result.put("pay_status",response.getPayStatus());
				if("1".equals(response.getPayStatus())){
					JSONObject orderInfo = new JSONObject();
					orderInfo.put("f_return_code",response.getReturnCode());
					orderInfo.put("f_return_msg",response.getReturnMsg());
					//订单总金额
					orderInfo.put("f_total_fee",Integer.parseInt(response.getTotalAmt()));

					//行内系统订单号
					orderInfo.put("f_transaction_id",response.getOrderId());
					//总优惠金额
					orderInfo.put("f_coupon_fee",Integer.parseInt(response.getTotalDiscAmt()));

					//支付完成时间
					orderInfo.put("f_time_end",response.getPayTime());
					//订单状态
					orderInfo.put("f_bill_state","1");

					result.put("orderInfo",orderInfo);
				}
			} else {
				//失败
				log.debug("ReturnCode:"+response.getReturnCode());
				log.debug("查询请求失败ReturnMsg:"+response.getReturnMsg());
				result.put("code",500);
				result.put("msg","查询请求失败："+response.getReturnMsg());
			}
		} catch (IcbcApiException e) {
			log.debug("查询请求异常:"+e.getMessage());
			result.put("code",500);
			result.put("msg","查询请求异常："+e.getMessage());
		}
		return result;
	}

	/**
	 * 工商银行退款
	 * @param config
	 * @param out_trade_no
	 * @return
	 */
	public static JSONObject refund(JSONObject config,String out_trade_no,Integer money){
		JSONObject result = new JSONObject();
		try {

			String privateKey = SHA256withRSAUtil.loadKeyByFile(config.getString("privateKey"));
			String publicKey = SHA256withRSAUtil.loadKeyByFile(config.getString("publicKey"));

			log.debug("privateKey==>"+privateKey);
			log.debug("publicKey==>"+publicKey);
            String signType = config.has("signType")?config.getString("signType"):IcbcConstants.SIGN_TYPE_RSA;
            DefaultIcbcClient client = new DefaultIcbcClient(config.getString("appId"), signType, privateKey,publicKey);

			QrcodeRejectRequestV2 request = new QrcodeRejectRequestV2();
			//请求url
			log.debug("请求url==>"+config.getString("refundUrl"));
			request.setServiceUrl(config.getString("refundUrl"));

			QrcodeRejectRequestV2Biz bizContent = new QrcodeRejectRequestV2Biz();
			//商户号
			bizContent.setMerId(config.getString("merchId"));

			//订单号
			bizContent.setOutTradeNo(out_trade_no);
			String refundNo= PayUtil.createTradeNo();
			log.debug("退款流水号："+refundNo+"，原订单号:"+out_trade_no);
			bizContent.setRejectNo(refundNo);
			bizContent.setRejectAmt(money + "");

			request.setBizContent(bizContent);
			QrcodeRejectResponseV2 response;
			response = client.execute(request, "msgId");
			if (response.isSuccess()) {

				result.put("code",200);
				result.put("msg","退款申请成功ReturnMsg:"+response.getReturnMsg());
				log.debug("退款申请成功ReturnMsg:"+response.getReturnMsg());

			} else {
				//失败
				log.debug("ReturnCode:"+response.getReturnCode());
				log.debug("退款失败ReturnMsg:"+response.getReturnMsg());
				result.put("code",500);
				result.put("msg","退款请求失败："+response.getReturnMsg());
			}
		} catch (IcbcApiException e) {
			log.debug("退款请求异常:"+e.getMessage());
			result.put("code",500);
			result.put("msg","退款请求异常："+e.getMessage());
		}
		return result;
	}

	/**
	 * 工行验签
	 * @param json
	 * @param config
	 * @return
	 */
	public static boolean checkParam(JSONObject json, JSONObject config){
		return true;
	}

	/**
	 * 保存收费记录获取数据
	 * @param map
	 * @return
	 */
	public static JSONObject toReturnData(JSONObject map) {
		JSONObject bizContent = map.has("biz_content") ? map.getJSONObject("biz_content") : null;
		JSONObject result = new JSONObject();
		if (bizContent == null)
			return result;
		result.put("f_appid", map.has("app_id")?map.getString("app_id"):"");
		result.put("f_sign", map.has("sign")?map.getString("sign"):"");

		result.put("f_card_id", bizContent.has("card_no")?bizContent.getString("card_no"):"");
		result.put("f_openid", bizContent.has("cust_id")?bizContent.getString("cust_id"):"");
		result.put("f_return_code", bizContent.has("return_code")?bizContent.getString("return_code"):"");
		result.put("f_mch_id", bizContent.has("mer_id")?bizContent.getString("mer_id"):"");
		result.put("f_bank_type", "icbc");
		result.put("f_total_fee", bizContent.has("total_amt")?(int)Integer.valueOf(bizContent.getInt("total_amt")):0);
		result.put("f_out_trade_no", bizContent.has("out_trade_no")?bizContent.getString("out_trade_no"):"");
		result.put("f_time_end", bizContent.has("pay_time")?bizContent.getString("pay_time"):"");
		result.put("f_bill_state", "1");

		return result;
	}

	/**
	 * 账单解析
	 * @param path  账单地址
	 * @param flag  支付或退款
	 * @return
	 */
	public static JSONArray dealBankDile(String path,boolean flag) throws IOException {
		JSONArray  ret=new JSONArray();

		File file=new File(path);
		BufferedReader br = new BufferedReader(new FileReader(file));
		String line = "";
		line = br.readLine();
		while(line != null) {
			String [] ss =line.split(";");
			JSONObject jo =new JSONObject();
			jo.put("f_trade_number",ss[0]);  //流水号
			jo.put("f_serial_id",ss[1]);  //订单号
			jo.put("f_trade_date",ss[2]);  //交易时间
			if(flag){
				jo.put("f_total_charge",Integer.valueOf(ss[4]));  //交易金额 （分）
			}else {
				jo.put("f_total_charge",-Integer.valueOf(ss[4]));  //交易金额 （分）
			}

			jo.put("f_remarks",ss[5]);
			ret.put(jo);
			line = br.readLine();
		}
		return ret;
	}

}
