package com.aote.cmb;

import com.aote.utils.PayUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by dell on 2019/8/7.
 * AES加密handleEncrypt
 * AES解密decrypt
 * 2--16转换 byte2hex
 * 16--2转换 hex2byte
 * sign生成 sign
 * sha-1生成 sha-1
 * md5生成  getMd5
 */
public class CmbTool {
    static Logger log = Logger.getLogger(CmbTool.class);
    //算法
    private static String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static String KEY_ALGORITHM = "AES";

    /**
     * 数据加密
     * @param obj 内容
     * @param OPEN_KEY 密钥
     * @return  加密后的内容
     * @throws Exception
     */
    public static String handleEncrypt(JSONObject obj,String OPEN_KEY) throws Exception {
        String data = encrypt(obj.toString(), OPEN_KEY);
        log.debug("加密后的data= " + data);
        return data;
    }
    public static String encrypt(String sSrc, String sKey) throws Exception {
        log.debug("====data加密前的明文= " + sSrc);
        SecretKeySpec skeySpec = new SecretKeySpec(sKey.getBytes("ASCII"), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(sSrc.getBytes("UTF-8"));
        return byte2hex(encrypted);
    }
    public static String byte2hex(byte[] result) {
        StringBuffer sb = new StringBuffer(result.length * 2);
        for (int i = 0; i < result.length; i++) {
            int hight = ((result[i] >> 4) & 0x0f);
            int low = result[i] & 0x0f;
            sb.append(hight > 9 ? (char) ((hight - 10) + 'a') : (char) (hight + '0'));
            sb.append(low > 9 ? (char) ((low - 10) + 'a') : (char) (low + '0'));
        }
        return sb.toString();
    }
    public static String decrypt(String sSrc, String sKey) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(sKey.getBytes("ASCII"), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, skeySpec);
        byte[] encrypted1 = hex2byte(sSrc);
        byte[] original = cipher.doFinal(encrypted1);
        return new String(original, "UTF-8");
    }
    /**
     * 十六进制字符串转byte数组
     */
    public static byte[] hex2byte(String strhex) {
        if (strhex == null)
            return null;

        int l = strhex.length();
        if (l % 2 == 1)
            return null;

        byte[] b = new byte[l / 2];
        for (int i = 0; i != l / 2; ++i)
            b[i] = (byte) Integer.parseInt(strhex.substring(i * 2, i * 2 + 2), 16);

        return b;
    }
    /**
     * AES解密结束
     * @return
     */



    /**
     * sha-1加密
     * @param str
     * @return
     */
    public static String sha1Data(String str){
        if (null == str || 0 == str.length()){
            return null;
        }
        char[] hexDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes("UTF-8"));

            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xf];
                buf[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(buf).toLowerCase();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**
     * sha-1加密结束
     * @param data
     * @return
     */
    /**
     * md5加密
     * @param str
     * @return str
     */
    public static String getMd5(String str){
            return getMD5String(str.getBytes());
        }
    public static String getMD5String(byte[] bytes) {
        messagedigest.update(bytes);
        return bufferToHex(messagedigest.digest()).toLowerCase();
    }
    private static String bufferToHex(byte bytes[]) {
        return bufferToHex(bytes, 0, bytes.length);
    }
    private static String bufferToHex(byte bytes[], int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; l++) {
            appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }
    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xf0) >> 4];// 取字节中高 4 位的数字转换, >>>
        // 为逻辑右移，将符号位一起右移,此处未发现两种符号有何不同
        char c1 = hexDigits[bt & 0xf];// 取字节中低 4 位的数字转换
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }
    protected static char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6',
            '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

    protected static MessageDigest messagedigest = null;
    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException nsaex) {

            nsaex.printStackTrace();
        }
    }
    /**
     * md5加密结束
     * @param data
     * @return
     */
    /**
     * sign生成
     * @return boolean
     */
    public static String sign(String data,String open_id,String open_key,String timestamp){
        String str="data="+data+"&open_id="+open_id+"&open_key="+open_key+"&timestamp="+timestamp;
        return getMd5(sha1Data(str));
    }
    public static String getSendStr(JSONObject obj){
        String send_str="open_id="+obj.getString("open_id")+"&timestamp="+obj.getString("timestamp")+"&data="+obj.getString("aesData")+"&sign="+obj.getString("sign");
//        String send_str = PayUtil.json2Query(obj);
        return send_str;
    }
    public static JSONObject sendPost(String url, String pararm) {
        // post请求返回结果
        BasicHttpParams httpParams = new BasicHttpParams();
        // 通过网络与服务器建立连接的超时时间 ? Httpclient包中通过 ?个异步线程去创建与服务器的socket连接，这就是该socket连接的超时时 ?
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        // Socket读数据的超时时间，即从服务器获取响应数据 ?要等待的时间
        HttpConnectionParams.setSoTimeout(httpParams, 30000);
        DefaultHttpClient httpClient = new DefaultHttpClient(httpParams);
        JSONObject jsonResult = null;
        HttpPost method = new HttpPost(url);
        JSONObject jsonObject;
        try {
            if (null != pararm) {
                // 解决中文乱码问题
                StringEntity entity = new StringEntity(pararm, "utf-8");
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/x-www-form-urlencoded");
                method.setEntity(entity);
            }
            log.debug("请求URL====>" + url);
            log.debug("请求参数===>" + pararm);
            HttpResponse result = httpClient.execute(method);
            if (result.getStatusLine().getStatusCode() == 200 ) {
                jsonObject = new JSONObject(EntityUtils.toString(result.getEntity(), "utf-8"));
            }else{
                jsonObject = new JSONObject();
                jsonObject.put("errcode","1");
                jsonObject.put("msg","http请求错误"+ result.getStatusLine().getStatusCode());
            }
        } catch (Exception e) {
            jsonObject = new JSONObject();
            jsonObject.put("errcode","1");
            jsonObject.put("msg","发生异常"+ e.getMessage());

        }
        return jsonObject;
    }
    //验签
    public static boolean unsign(JSONObject json,String OPEN_KEY){
        log.debug(json);
//        int errcode=json.getInt("errcode");
//        String data=json.getString("data");
        String sign=json.getString("sign");
//        log.debug("sign==>"+sign);
//        Long timestamp=json.getLong("timestamp");
//        String msg=json.getString("msg");
//        String str="data="+data+"&errcode="+errcode+"&msg="+msg+"&open_key="+OPEN_KEY+"&timestamp="+timestamp;
        json.remove("sign");
        json.put("open_key",OPEN_KEY);
        String rtsign=CmbTool.getMd5(CmbTool.sha1Data(PayUtil.json2Query(json)));
        log.debug("rtsign==>"+rtsign);
        return rtsign.equals(sign);
    }

    //Json加工
    public static String JsonToString(JSONObject json){
//        String str="";
//        if(json.length()==1) {
//            for(String s:json.keySet()){
//                str=str+s+"="+json.getString(s);
//            }
//        }
//       else{
//            for(String s:json.keySet()){
//                str=str+s+"="+json.getString(s)+"&";
//            }
//            str=str.substring(0,str.length()-1);
//        }
//        return str;
        return PayUtil.json2Query(json);
    }
    public static JSONObject StringToJson(String str){
//        JSONObject obj=new JSONObject();
//        String[] arr = new String[2];
//        for(String temp:str.split("&")){
//            arr=temp.split("=");
//            obj.put(arr[0],arr[1]);
//        }
//        return obj;
        return PayUtil.Query2json(str);
    }
    public static JSONObject getRs(JSONObject obj,String OPEN_KEY) throws Exception {
        JSONObject json=new JSONObject();
//        System.out.println(obj);
        if(obj.getInt("errcode")== 0 && unsign(obj,OPEN_KEY)){
            String rtdata = CmbTool.decrypt(obj.getString("data"),OPEN_KEY);
            log.debug("rtdata:"+rtdata);

            json=new JSONObject(rtdata);
            json.put("code",200);
            json.put("flag","succ");
            json.put("msg","本次请求处理成功");
            String status = json.getString("status");
            //1：交易成功 2.待支付 4.取消 9.等待密码
//                //订单状态  0-待支付 ，1-已支付，2-超时/撤销/支付失败/..(不需要再继续查询的状态)， 3-已退款
//                if (status.equals("1")) obj.put("f_bill_state","1");
//                if (status.equals("2")) obj.put("f_bill_state","0");
//                if (status.equals("4")) obj.put("f_bill_state","2");
//                if (status.equals("9")) obj.put("f_bill_state","0");
            if (status.equals("1")) json.put("f_bill_state","1");
            if (status.equals("2")) json.put("f_bill_state","0");
            if (status.equals("4")) json.put("f_bill_state","2");
            if (status.equals("9")) json.put("f_bill_state","0");
        }
        else if(unsign(obj,OPEN_KEY)){
            json.put("code",500);
            json.put("flag","fail");
            json.put("msg",obj.getInt("errcode"));
        }
        else {
            json.put("code",500);
            json.put("flag","fail");
            json.put("msg","验签失败");
        }
        return json;
    }
    public static boolean unsignBack(JSONObject obj,String OPEN_KEY){
        String ord_no = obj.getString("ord_no");
        String timestamp = obj.getString("timestamp");
        String rand_str = obj.getString("rand_str");
        String out_no = obj.getString("out_no");
        String status = obj.getString("status");
        String sign = obj.getString("sign");
        String str="open_key="+OPEN_KEY+"&ord_no="+ord_no+"&out_no="+out_no+"&rand_str="+rand_str+"&status="+status+"&timestamp="+timestamp;
        obj.remove("sign");
        obj.put("open_key",OPEN_KEY);
        return sign.equals(CmbTool.getMd5(CmbTool.sha1Data(str)));
//        return sign.equals(CmbTool.getMd5(CmbTool.sha1Data(PayUtil.json2Query(obj))));
    }
}
