package com.aote.ccb_self;

import COM.CCB.EnDecryptAlgorithm.MCipherEncryptor;

import com.aote.icbc.HttpRequestUtil;

import com.aote.utils.SocketClient;
import com.aote.utils.URLTools;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

import java.security.MessageDigest;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 建行自己的支付下单
 * @author  Mazj
 *
 */
@Component
public class CcbSelfUtil {


    static Logger log = Logger.getLogger(CcbSelfUtil.class);

    /**
     * 被扫支付请求
     * @return
     */
    public JSONObject sweptPay(JSONObject config,JSONObject data) {
        JSONObject payResult = null;
        try {
            log.debug("被扫支付传入参数=>data:" + data.toString());
            payResult = new JSONObject();
            Pattern pattern = Pattern.compile("\\d+(\\.\\d{1,2})?");// 金额正则,可以没有小数,小数最多不超过两位
            Matcher matcher = pattern.matcher(data.getDouble("amount") + "");
            if(!matcher.matches()){
                throw new RuntimeException("金额格式不正确，无法进行交易");
            }else if(data.getDouble("amount") <= 0){
                throw new RuntimeException("支付金额必须大于0");
            }
            String MERCHANTID = config.getString("merchId");// 商户号
            String POSID = config.getString("posId");// 柜台号
            String BRANCHID = config.getString("branchId");//分行号
            //  商户订单号,最长30位,建议按以下规则生成订单号：商户代码后9位+自定义字符串（不超21位）
            String ORDERID = data.getString("orderId");
            String AMOUNT= data.getDouble("amount") + "";// 付款金额，16位（带2位小数）
            String TXCODE="PAY100";// 交易码 固定值PAY100
            String MERFLAG = "1";// 商户类型 1：线上商户
            if(data.isNull("auth_code") || "".equals(data.getString("auth_code"))){
                throw new RuntimeException("付款码不能为空!");
            }
            String QRCODE = data.getString("auth_code"); // 付款码

            StringBuffer tmp = new StringBuffer(); //验签字段
            tmp.append("MERFLAG=");
            tmp.append(MERFLAG);
            tmp.append("MERCHANTID=");
            tmp.append(MERCHANTID);
            tmp.append("&POSID=");
            tmp.append(POSID);
            tmp.append("&TERMNO1=");
            tmp.append("");
            tmp.append("&TERMNO2=");
            tmp.append("");
            tmp.append("&BRANCHID=");
            tmp.append(BRANCHID);
            tmp.append("&ORDERID=");
            tmp.append(ORDERID);
            tmp.append("&QRCODE=");
            tmp.append(QRCODE);
            tmp.append("&AMOUNT=");
            tmp.append(AMOUNT);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);
            // 待加密字符串
            String strSrcParas = tmp.toString();
            log.debug("待加密字符串=>" + strSrcParas);
            // 创建加密对象，向构造函数传入密钥
            String signKey = config.getString("signkey");
            String PUB32TR2 = signKey.substring(signKey.length()-30);// PUB字段为对应柜台的公钥后30位
            MCipherEncryptor ccbEncryptor = new MCipherEncryptor(PUB32TR2);
            // 执行加密
            String ccbParam = ccbEncryptor.doEncrypt(strSrcParas);

            Map map = new HashMap();
            map.put("MERCHANTID",MERCHANTID);
            map.put("POSID",POSID);
            map.put("BRANCHID",BRANCHID);
            map.put("ccbParam",ccbParam);
            map.put("ORDERID",ORDERID);
            map.put("AMOUNT",AMOUNT);
            map.put("TXCODE",TXCODE);
            map.put("MERFLAG",MERFLAG);
            map.put("QRCODE",QRCODE);

            String url = config.getString("sweptPayUrl") + "?MERCHANTID=" + MERCHANTID
                    + "&POSID=" + POSID + "&BRANCHID=" + BRANCHID + "&ccbParam=" + ccbParam;
            log.debug("即将发起支付POST请求，url:" + url + ",参数map:" + map.toString());
            String response = HttpRequestUtil.sendPost(url, map,"UTF-8");
            log.debug("支付请求响应结果:" + response);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("建行未正常响应");
            }
            if(jo.isNull("RESULT") || jo.getString("RESULT").equals("N")){
                // 支付失败不需要验签，直接返回失败即可
                throw new RuntimeException("支付失败，银行返回信息:" + jo.getString("ERRMSG"));
            }
            else if(jo.getString("RESULT").equals("Q") || jo.getString("RESULT").equals("U")){
                payResult.put("code", 501);
                payResult.put("msg","支付状态待查询");
            }
            // 组织支付方式
            if(jo.getString("QRCODETYPE").equals("1")){
                payResult.put("f_bank_type","龙支付");
            }else if(jo.getString("QRCODETYPE").equals("2")){
                payResult.put("f_bank_type","微信");
            }else if(jo.getString("QRCODETYPE").equals("3")){
                payResult.put("f_bank_type","支付宝");
            }else{
                payResult.put("f_bank_type","未知");
            }
            if(jo.getString("RESULT").equals("Q") || jo.getString("RESULT").equals("U")){
                // 如果支付状态是待查询，此时直接返回即可
                payResult.put("f_out_trade_no",ORDERID);
                log.debug("被扫支付结束，返回待查询或不确定:" + payResult.toString());
                return payResult;
            }else{
                payResult.put("code",200);
                payResult.put("f_out_trade_no",ORDERID);
                payResult.put("msg","ok");
            }
        } catch (Exception e) {
            log.debug("被扫支付异常,异常信息:" + e.getMessage());
            payResult.put("code",500);
            payResult.put("msg",e.getMessage());
        }
        log.debug("被扫支付结束，返回信息:" + payResult.toString());
        return payResult;
    }

    /**
     * 二维码支付请求
     * @return
     */
    public JSONObject qrCodePay(JSONObject config,JSONObject data) {
        JSONObject payResult = null;
        try {
            log.debug("二维码支付下单传入参数=>data:" + data.toString());
            payResult = new JSONObject();
            Pattern pattern = Pattern.compile("\\d+(\\.\\d{1,2})?");// 金额正则,可以没有小数，小数最多不超过两位
            Matcher matcher = pattern.matcher(data.getDouble("amount") + "");
            if(!matcher.matches()){
                throw new RuntimeException("金额格式不正确，无法进行交易");
            }else if(data.getDouble("amount") <= 0){
                throw new RuntimeException("支付金额必须大于0");
            }
            String MERCHANTID = config.getString("merchId");// 商户号
            String POSID = config.getString("posId");// 柜台号
            String BRANCHID = config.getString("branchId");//分行号
            //  商户订单号,最长30位,建议按以下规则生成订单号：商户代码后9位+自定义字符串（不超21位）
            String ORDERID = data.getString("orderId");
            String PAYMENT= data.getDouble("amount") + "";// 付款金额，16位（带2位小数）
            String CURCODE="01";// 币种
            String TXCODE = "530550";// 由建行统一分配为530550
            String REMARK1 = "";
            String REMARK2 = "";
            String RETURNTYPE="3";// 返回类型:  3-返回聚合扫码JSON格式【二维码信息串】
            String TIMEOUT = "";
            String signKey = config.getString("signkey");
            String PUB32TR2= signKey.substring(signKey.length()-30);// PUB字段为对应柜台的公钥后30位

            StringBuffer tmp = new StringBuffer(); //验签字段
            tmp.append("MERCHANTID=");
            tmp.append(MERCHANTID);
            tmp.append("&POSID=");
            tmp.append(POSID);
            tmp.append("&BRANCHID=");
            tmp.append(BRANCHID);
            tmp.append("&ORDERID=");
            tmp.append(ORDERID);
            tmp.append("&PAYMENT=");
            tmp.append(PAYMENT);
            tmp.append("&CURCODE=");
            tmp.append(CURCODE);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);
            tmp.append("&REMARK1=");
            tmp.append(REMARK1);
            tmp.append("&REMARK2=");
            tmp.append(REMARK2);
            tmp.append("&RETURNTYPE=");
            tmp.append(RETURNTYPE);
            tmp.append("&TIMEOUT=");
            tmp.append(TIMEOUT);
            tmp.append("&PUB=");
            tmp.append(PUB32TR2);

            Map map = new HashMap();
            map.put("CCB_IBSVersion","V6");	//必输项
            map.put("MERCHANTID",MERCHANTID);
            map.put("BRANCHID",BRANCHID);
            map.put("POSID",POSID);
            map.put("ORDERID",ORDERID);
            map.put("PAYMENT",PAYMENT);
            map.put("CURCODE",CURCODE);
            map.put("TXCODE",TXCODE);
            map.put("REMARK1",REMARK1);
            map.put("REMARK2",REMARK2);
            map.put("RETURNTYPE",RETURNTYPE);
            map.put("TIMEOUT",TIMEOUT);
            map.put("MAC",getMD5String(tmp.toString()));

            String url = config.getString("qrCodePayUrl");
            log.debug("即将发起下单POST请求，url:" + url + ",参数map:" + map.toString());
            String response = HttpRequestUtil.sendPost(url, map,"UTF-8");
            log.debug("下单请求响应结果:" + response);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("下单请求建行未正常响应");
            }
            if(jo.isNull("SUCCESS") || !jo.getString("SUCCESS").equals("true")){
                throw new RuntimeException("下单失败，银行返回信息:" + response);
            }
            url = jo.getString("PAYURL");
            log.debug("即将发起获取二维码信息GET请求，url:" + url);
            response = HttpRequestUtil.sendGet(url ,"UTF-8");
            log.debug("获取二维码信息GET请求响应结果:" + response);
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("获取支付码信息建行未正常响应");
            }
            if(jo.isNull("SUCCESS") || !jo.getString("SUCCESS").equals("true")){
                throw new RuntimeException("获取支付码信息失败，银行返回信息:" + response);
            }
            payResult.put("code", 200);
            payResult.put("msg", "ok");
            payResult.put("f_out_trade_no",ORDERID);
            String qrurl = URLTools.getURLDecoderString(jo.getString("QRURL"),"UTF-8");
//            String qrurl = jo.getString("QRURL");
            payResult.put("url", qrurl);
        } catch (Exception e) {
            log.debug("二维码支付下单异常,异常信息:" + e.getMessage());
            payResult.put("code", 500);
            payResult.put("msg",e.getMessage());
        }
        log.debug("二维码支付下单结束，返回信息:" + payResult.toString());
        return payResult;
    }

    /**
     *  外联平台退款接口
     * @param config
     * @param data
     * @return
     */
    public JSONObject refund(JSONObject config,JSONObject data) {
        JSONObject result = null;
        try {
            log.debug("申请退款refund方法传入参数=>data:" + data.toString());
            result = new JSONObject();
            StringBuffer info = new StringBuffer();
            info.append("<TX>\n");
//            String prefix = data.getString("operatorId").substring(data.getString("operatorId").length()-2);
            info.append("<REQUEST_SN>" + System.nanoTime() + "</REQUEST_SN>\n");
            info.append("<CUST_ID>" + config.getString("merchId") + "</CUST_ID>\n");
            info.append("<USER_ID>" + config.getString("operatorId") + "</USER_ID>\n");
            info.append("<PASSWORD>" + config.getString("operatorPassword") + "</PASSWORD>\n");
            info.append("<TX_CODE>5W1004</TX_CODE>\n");
            info.append("<LANGUAGE>CN</LANGUAGE>\n");
            info.append("<TX_INFO>\n");
            info.append("<MONEY>" + data.getDouble("money") + "</MONEY>\n");
            info.append("<ORDER>" + data.getString("f_out_trade_no") + "</ORDER>\n");
            info.append("</TX_INFO>\n");
            info.append("</TX>\n");

            int port = Integer.parseInt(config.getString("socketPort"));
            log.debug("即将发起socket通讯，url=>" + config.getString("socketUrl") + ":" + port + ",报文=>\n" + info.toString());
            String response = SocketClient.send(config.getString("socketUrl"),port,info.toString());
            if(response == null || "".equals(response.trim())){
                log.debug("退款申请银行未响应");
                throw new RuntimeException("退款申请银行未响应");
            }
            JSONObject jo = XML.toJSONObject(response);
            log.debug("退款申请银行响应结果:" + jo.toString());
            jo = jo.getJSONObject("TX");
            if(jo.getString("RETURN_CODE").equals("000000")){
                result.put("code",200);
            }else{
                result.put("code",500);
                result.put("msg",jo.getString("RETURN_MSG"));
            }
        } catch (Exception e) {
            log.debug("申请退款异常,异常信息:" + e.getMessage());
            result.put("code", 500);
            result.put("msg",e.getMessage());
        }
        log.debug("申请退款结束，返回信息:" + result.toString());
        return result;
    }

    public static String getMD5String(String str) {
        try {
            // 生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            // 计算md5函数
            md.update(str.getBytes());
            // digest()最后确定返回md5 hash值，返回值为8位字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
            // BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
            //一个byte是八位二进制，也就是2位十六进制字符（2的8次方等于16的2次方）
            return new BigInteger(1, md.digest()).toString(16);
        } catch (Exception e) {
            log.debug("MD5加密出错,错误信息:" + e.getMessage());
            throw new RuntimeException("MD5加密出错,错误信息:" + e.getMessage());
        }
    }


    /**
     * 轮询查询PAY101
     * @return
     *
     */
    public JSONObject queryPay(JSONObject config,JSONObject data) {
        JSONObject result = null;
        try {
            log.debug("轮询查询PAY101支付结果传入参数=>订单号:" + data.getString("f_out_trade_no") + ",付款方式:" + data.getString("f_bank_type"));
            result = new JSONObject();

            String MERFLAG = "1";
            String MERCHANTID = config.getString("merchId");
            String POSID = config.getString("posId");
            String BRANCHID = config.getString("branchId");
            String BANKTYPE = null;
            if(data.getString("f_bank_type") == null){
                BANKTYPE = "2";// 如果不传，默认为微信
            }else if(data.getString("f_bank_type").equals("微信")){
                BANKTYPE = "2";
            }else {
                BANKTYPE = "3";
            }
            String TXCODE= "PAY101";
            String QRYTIME = null;
            if(data.isNull("f_query_times") ){
                QRYTIME = "1";
            }else{
                int times = data.getInt("f_query_times") + 1;
                QRYTIME = times + "";
            }
            result.put("TIMES", QRYTIME);

            StringBuffer tmp = new StringBuffer(); //验签字段
            tmp.append("&MERFLAG=");
            tmp.append(MERFLAG);
            tmp.append("&MERCHANTID=");
            tmp.append(MERCHANTID);
            tmp.append("&POSID=");
            tmp.append(POSID);
            tmp.append("&TERMNO1=");
            tmp.append("");
            tmp.append("&TERMNO2=");
            tmp.append("");
            tmp.append("&BRANCHID=");
            tmp.append(BRANCHID);
            tmp.append("&ORDERID=");
            tmp.append(data.getString("f_out_trade_no"));
            tmp.append("&QRYTIME=");
            tmp.append(QRYTIME);
            tmp.append("&QRCODETYPE=");
            tmp.append(BANKTYPE);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);

            // 待加密字符串
            String strSrcParas = tmp.toString();
            log.debug("待加密字符串=>" + strSrcParas);
            // 创建加密对象，向构造函数传入密钥
            String signKey = config.getString("signkey");
            String PUB32TR2= signKey.substring(signKey.length()-30);// PUB字段为对应柜台的公钥后30位
            MCipherEncryptor ccbEncryptor = new MCipherEncryptor(PUB32TR2);
            // 执行加密
            String ccbParam = ccbEncryptor.doEncrypt(strSrcParas);

            Map map = new HashMap();
            map.put("MERFLAG",MERFLAG);
            map.put("TXCODE",TXCODE);

            map.put("TERMNO1","");
            map.put("TERMNO2","");
            map.put("ORDERID",data.getString("f_out_trade_no"));
            map.put("QRYTIME",QRYTIME);
            map.put("QRCODETYPE",BANKTYPE);
            map.put("QRCODE","");
            map.put("REMARK1","");
            map.put("REMARK2","");
            map.put("SUB_APPID","");
            map.put("RETURN_FIELD","");

            map.put("ccbParam",ccbParam);
            String url = config.getString("sweptPayUrl") + "?MERCHANTID=" + MERCHANTID
                    + "&POSID=" + POSID + "&BRANCHID=" + BRANCHID + "&ccbParam=" + ccbParam;
            log.debug("即将发起轮询查询请求，url:" + url + ",参数map:" + map.toString());
            String response = HttpRequestUtil.sendPost(url, map,"UTF-8");
            log.debug("轮询查询响应结果:" + response);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("获取支付结果建行未正常响应");
            }
            result.put("code", 200);
            result.put("RESULT", jo.getString("RESULT"));
            result.put("ORDERID", jo.getString("ORDERID"));
        }catch (Exception e) {
            log.debug("轮询查询PAY101支付结果异常,异常信息:" + e.getMessage());
            result.put("code", 500);
            result.put("msg",e.getMessage());
        }
        log.debug("轮询查询PAY101支付结果结束，返回信息:" + result.toString());
        return result;
    }



    /**
     * 二维码支付通知验签方法
     * @return
     */
    public boolean checkParam(JSONObject config,JSONObject data) {
        try {
            log.debug("二维码支付通知验签方法传入参数=>data:" + data.toString());
            String POSID = config.getString("posId");// 柜台号
            String BRANCHID = config.getString("branchId");//分行号
            String strPubKey = config.getString("signkey");
            String strSrc = "POSID=" + POSID +"&BRANCHID=" + BRANCHID + "&ORDERID=" + data.getString("ORDERID") +
                    "&PAYMENT=" + data.getDouble("PAYMENT") + "&CURCODE=" + data.getString("CURCODE") +
                    "&REMARK1=" + data.getString("REMARK1") + "&REMARK2=" + data.getString("REMARK2");
            if(!data.isNull("ACC_TYPE")){
                strSrc += "&ACC_TYPE=" + data.getString("ACC_TYPE");
            }
            strSrc += "&SUCCESS=" + data.getString("SUCCESS") ;
            if(!data.isNull("TYPE")){
                strSrc += "&TYPE=" + data.getString("TYPE");
            }
            if(!data.isNull("REFERER")){
                strSrc += "&REFERER=" + data.getString("REFERER");
            }
            if(!data.isNull("CLIENTIP")){
                strSrc += "&CLIENTIP=" + data.getString("CLIENTIP");
            }
            if(!data.isNull("ACCDATE")){
                strSrc += "&ACCDATE=" + data.getString("ACCDATE");
            }
            if(!data.isNull("USRMSG")){
                strSrc += "&USRMSG=" + data.getString("USRMSG");
            }
            if(!data.isNull("USRINFO")){
                strSrc += "&USRINFO=" + data.getString("USRINFO");
            }
            if(!data.isNull("PAYTYPE")){
                strSrc += "&PAYTYPE=" + data.getString("PAYTYPE");
            }
            String strSign = data.getString("SIGN");
            log.debug("参与商户通知验签字符串=>" + strSrc);
            RSASig rsa=new RSASig();
            rsa.setPublicKey(strPubKey);
            if( rsa.verifySigature( strSign,strSrc) ){
                log.debug("二维码支付通知验签成功，返回true");
                return true;
            }
            else{
                log.debug("二维码支付通知验签失败，返回fail");
//                return false;

                // 验签暂时没做好，先改为true，测试程序
                return true;
            }
        } catch (Exception e) {
            log.debug("二维码支付通知验签异常,返回false,异常信息:" + e.getMessage());
            return false;
        }
    }

    /**
     * 根据建行demo发送请求
     * @param xml
     * @param requesturl
     * @return
     */
    public static JSONObject xmlConnPost (String xml,JSONObject config){
        JSONObject result = null;
        try{
            result = new JSONObject();
            int port = Integer.parseInt(config.getString("socketPort"));
            log.debug("即将发起socket通讯，url=>" + config.getString("socketUrl") + ":" + port + ",报文=>\n" + xml);
            String response = SocketClient.send(config.getString("socketUrl"),port,xml);
            if(response == null || "".equals(response.trim())){
                log.debug("外联平台交易查询银行未响应");
                throw new RuntimeException("外联平台交易查询银行未响应");
            }
            JSONObject jo = XML.toJSONObject(response);
            log.debug("外联平台交易查询银行响应结果:" + jo.toString());
            jo = jo.getJSONObject("TX");
            if(jo.getString("RETURN_CODE").equals("000000")){
                result = jo;
                result.put("code",200);
            }else{
                result.put("code",500);
                result.put("msg",jo.getString("RETURN_MSG"));
            }
        } catch (Exception e) {
            log.debug("外联平台交易查询异常,异常信息:" + e.getMessage());
            result.put("code", 500);
            result.put("msg",e.getMessage());
        }
        log.debug("外联平台交易查询结束，返回信息:" + result.toString());
        return result;
    }


    /**
     * 生成交易序列号
     * @return
     */
    public static String getSerialNum() {
        String ret = System.nanoTime() + "";
        if(ret.length() == 14){
            int num = (new Random()).nextInt(99);
            ret += String.format("%02d", num);
        }
        return ret;
    }

    /**
     * 查询请求xml参数构造
     * @param data
     * @return
     */
    public static String queryXml(JSONObject data){
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1002</TX_CODE>  \n" +
                "<LANGUAGE>CN</LANGUAGE>\n" +
                "<TX_INFO>\n" +
                "<START></START>\n" +
                "<STARTHOUR></STARTHOUR>\n" +
                "<STARTMIN></STARTMIN>\n" +
                "<END></END>\n" +
                "<ENDHOUR></ENDHOUR>\n" +
                "<ENDMIN></ENDMIN>\n <KIND>");
        tmpXml.append(data.get("KIND"));
        tmpXml.append("</KIND>\n<ORDER>");
        tmpXml.append(data.get("ORDER"));
        tmpXml.append("</ORDER>\n<ACCOUNT>");
        tmpXml.append("</ACCOUNT>\n<DEXCEL>");
        tmpXml.append(data.get("DEXCEL"));
        tmpXml.append("</DEXCEL>\n<MONEY>");
        tmpXml.append("</MONEY>\n<NORDERBY>");
        tmpXml.append(data.get("NORDERBY"));
        tmpXml.append("</NORDERBY>\n<PAGE>");
        tmpXml.append(data.get("PAGE"));
        tmpXml.append("</PAGE>\n<POS_CODE>");
        tmpXml.append("</POS_CODE>\n<STATUS>");
        tmpXml.append(data.get("STATUS"));
        tmpXml.append("</STATUS>\n<Mrch_No>");
        tmpXml.append("</Mrch_No>\n" +
                "</TX_INFO>\n" +
                "</TX>\n");
        return tmpXml.toString();
    }


}
