package com.aote.ccb_ronglian.quartz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.aote.ccb_ronglian.Crypto;
import com.aote.ccb_ronglian.HttpClientUtil;
import com.google.common.collect.Maps;

public class DzCCBTask {
	static Logger log = Logger.getLogger(DzCCBTask.class);
	public boolean finished = true;

	//发起生成退款对账文件请求
	public String sendBuildRefundFileRequest(JSONObject config) {
		Map<String, String> map;
		try {
			map = getRefundAccountMap(config);
			map = addSign(map,config);
			log.debug("发起生成退款对账文件请求参数："+map.toString());
			return HttpClientUtil.httpPost(config.getString("billDownloadUrl"), map, "UTF-8");
		} catch (ParseException e) {
			return null;
		}

	}

	//发起生成交易对账文件请求
	public String sendBuildPayFileRequest(JSONObject config) {
		Map<String, String> map;
		try {
			map = getPayAccountMap(config);
			map = addSign(map,config);
			log.debug("发起生成交易对账文件请求参数："+map.toString());
			return HttpClientUtil.httpPost(config.getString("billDownloadUrl"), map, "UTF-8");
		} catch (ParseException e) {
			return null;
		}

	}

	//发起生成清算对账文件请求
	public String sendBuildClearingFileRequest(JSONObject config) {
		Map<String, String> map;
		try {
			map = getClearingAccountMap(config);
			map = addSign(map,config);
			log.debug("发起生成清算对账文件请求参数："+map.toString());
			return HttpClientUtil.httpPost(config.getString("billDownloadUrl"), map, "UTF-8");
		} catch (ParseException e) {

			return null;
		}

	}

	//获取清算对账文件接口参数集合
	public Map<String,String> getClearingAccountMap(JSONObject config) throws ParseException {
		Map<String,String> map = Maps.newTreeMap();
		map.put("version", "2.0");
		map.put("charset", "UTF-8");
		map.put("signMethod", "MD5");
		map.put("transCode", "F001");
		map.put("merId", config.getString("merchId"));
		//交易日期/清算日期/退款日期
//		map.put("billDate", PayConf.TRANSFILEDATE);
		map.put("billDate", config.getString("billDate"));
//		map.put("billDate", new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("yyyyMMdd").parse("20171226")));
		//对账单类型:01-清算对账单,02-交易对账单,03-退款对账单
		map.put("billType", "01");
		map.put("fileType", "01");
		map.put("transTime", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
		map.put("backEndUrl", config.getString("billDownloadBackUrl"));
		return map;
	}

	//获取交易对账文件接口参数集合
	public Map<String,String> getPayAccountMap(JSONObject config) throws ParseException {
		Map<String,String> map = Maps.newTreeMap();
		map.put("version", "2.0");
		map.put("charset", "UTF-8");
		map.put("signMethod", "MD5");
		map.put("transCode", "F001");
		map.put("merId", config.getString("merchId"));
		//交易日期/清算日期/退款日期
		map.put("billDate",config.getString("transFileDate"));
//		map.put("billDate", new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("yyyyMMdd").parse("20171227")));
		//对账单类型:01-清算对账单,02-交易对账单,03-退款对账单
		map.put("billType", "02");
		map.put("fileType", "01");
		map.put("transTime", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
		map.put("backEndUrl", config.getString("billDownloadBackUrl"));
		return map;
	}

	//获取退款对账文件接口参数集合
	public Map<String,String> getRefundAccountMap(JSONObject config) throws ParseException {
		Map<String,String> map = Maps.newTreeMap();
		map.put("version", "2.0");
		map.put("charset", "UTF-8");
		map.put("signMethod", "MD5");
		map.put("transCode", "F001");
		map.put("merId", config.getString("merchId"));
		//交易日期/清算日期/退款日期
		map.put("billDate",config.getString("refundFileDate"));
//		map.put("billDate", new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("yyyyMMdd").parse("20171227")));
		//对账单类型:01-清算对账单,02-交易对账单,03-退款对账单
		map.put("billType", "03");
		map.put("fileType", "01");
		map.put("transTime", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
		map.put("backEndUrl", config.getString("billDownloadBackUrl"));
		return map;
	}

	/**
	 * MD5加盐，加盐后将sign放入集合返回
	 * @param map
	 * @return
	 */
	public Map<String,String> addSign(Map<String, String> map,JSONObject config) {
		String sign = "";
		for (java.util.Map.Entry<String, String> e : map.entrySet()) {
			sign += e.getKey() + "=" + e.getValue() + "&";
		}
		sign += Crypto.GetMessageDigest(config.getString("signkey"), "MD5", "UTF-8");
		sign = Crypto.GetMessageDigest(sign, "MD5", "UTF-8");
		map.put("sign", sign);
		return map;
	}
}
