package com.aote.ccb_ronglian.quartz;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.aote.utils.PayUtil;
import org.json.JSONObject;
import org.apache.log4j.Logger;

import com.aote.ccb_ronglian.AppUtils;

public class DzCCBJob{

	static Logger log = Logger.getLogger(DzCCBJob.class);
	private DzCCBTask dzCCBtask = new DzCCBTask();

	public void setDzCCBTask(DzCCBTask dzCCBtask) {
		this.dzCCBtask = dzCCBtask;
	}

	public void down() {
		File file = null;
		String str = null;
		String transFileDate = new SimpleDateFormat("yyyyMMdd").format(AppUtils.getNextDay(new Date()));
		String refundFileDate = new SimpleDateFormat("yyyyMMdd").format(AppUtils.getNextDay(new Date()));
		JSONObject config = PayUtil.getConfig("yulinyc");
		config.put("transFileDate",transFileDate);
		config.put("refundFileDate",refundFileDate);
//		PayConf.TRANSFILEDATE = "20180202";
//		PayConf.REFUNDFILEDATE = "20180202";

		log.debug("获取文件定时器开始触发：");
		while(true){
			try {
				Thread.sleep(1000*60);
			} catch (InterruptedException e) {
				e.printStackTrace();
				throw new RuntimeException("线程沉睡报错:" + e.getMessage());
			}
			str = config.getString("accountFileUrl")+"trans-"+config.getString("merchId")+"-"+config.getString("transFileDate")+"-txt.zip";
			file = new File(str);
			if(file.exists()){
				log.debug(str + "交易对账单已存在，即将获取退款对账文件");
				str = config.getString("accountFileUrl")+"refund-"+config.getString("merchId")+"-"+config.getString("refundFileDate")+"-txt.zip";
				file = new File(str);
				if(file.exists()){
					log.debug(str + "退款对账单已存在，break");
					break;
				}else{
					log.debug(str + "退款对账单不存在,即将发起生成退款文件请求");
					dzCCBtask.sendBuildRefundFileRequest(config);
				}
			}else{
				log.debug(str + "交易对账单不存在,即将发起生成交易文件请求");
				//发送生成交易对账文件请求
				dzCCBtask.sendBuildPayFileRequest(config);
			}
		}

	}

}
