package com.aote.ccb_ronglian;

import com.aote.utils.*;
import com.aote.wft.XmlUtils;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.util.Map;


/**
 * @auther qinlong
 * @date 2020-03-23 10:54
 */
public class ccbRLUtil {
    static Logger log = Logger.getLogger(ccbRLUtil.class);

    public static String sign(JSONObject sendData, JSONObject config) {
        String sign = "" ;
        if(!sendData.has("signMethod")||"MD5".equals(sendData.getString("signMethod"))){
            String queryStr = PayUtil.json2Query(sendData)+"&"+MD5Util.encode(config.getString("secretKey"),"UTF-8");
            sign = MD5Util.encode(queryStr,"UTF-8");
        }
        return sign;
    }
    public  static boolean verify(JSONObject returnData,JSONObject config){
        boolean result = false;
        String sign = returnData.getString("sign");
        returnData.remove("sign");
        String preStr = PayUtil.json2Query(returnData);
        if(!returnData.has("signMethod")||"MD5".equals(returnData.getString("signMethod"))) {
            String signRecieve = MD5Util.sign(preStr, "&" + MD5Util.encode(config.getString("secretKey"),"UTF-8"),"UTF-8");
            result = sign.equalsIgnoreCase(signRecieve);
        }
        return result;
    }

    /**
     * 建行-融联发送请求并将返回的xml转成json
     * @param seandData
     * @param config
     * @param url
     * @return
     */
    public static JSONObject postWithXml (JSONObject seandData,JSONObject config,String url){
        try {

//            Map<String, String> paramMap = PayUtil.json2Map(seandData);
            String queryStr =  PayUtil.json2Query(seandData);
            log.debug("请求报文："+queryStr);
            String res = HttpClientUtil.httpPost(url,queryStr,"UTF-8");
            log.debug("返回报文："+res);
            String[] strs = res.split("&");
            String xml = strs[0].replace("content=","");
            String sign = strs[1].replace("sign=","");
            xml = Base64Util.decodeData(xml);
            log.debug("解析出来的的xml："+xml);
            //验签
            boolean verify = false;
            if("MD5".equals(config.get("signMethod"))){
                String content = xml+"&"+MD5Util.encode(config.getString("secretKey"),"UTF-8");
               String tempSign = MD5Util.encode(content,"UTF-8");
                verify = tempSign.equalsIgnoreCase(sign);
            }
            if(!verify){
                log.debug("验签错误："+xml+"&"+sign);
                throw new RuntimeException("验签错误："+xml+"&"+sign);
            }
            JSONObject result = XmlUtils.toJson(xml.getBytes("UTF-8"),"UTF-8");

            return result;

        }catch (Exception e) {
            log.debug("建行-融联连接异常："+e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /**
     * 建行-融联发送请求并将返回的xml转成json
     * @param url
     * @param seandData
     * @return
     */
    public static JSONObject post(String url,JSONObject seandData){
        try {

//            Map<String, String> paramMap = PayUtil.json2Map(seandData);
            String queryStr =  PayUtil.json2Query(seandData);
            log.debug("请求报文："+queryStr);
            String res = HttpClientUtil.httpPost(url,queryStr,"UTF-8");
            log.debug("返回报文："+res);


            return new JSONObject(res);

        }catch (Exception e) {
            log.debug("建行-融联连接异常："+e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }


}
