package com.aote.ccb_ronglian;

import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.*;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;


public class Tool {

	private static final Logger log = Logger.getLogger(Tool.class);
	/**
	 * 读取文件并将其数据转为JSON格式
	 *
	 * @param filePath
	 * @return
	 * @throws IOException
	 * @throws JSONException
	 */
	public static JSONArray readFileToJSON(String filePath) {
		ZipFile zf = null;
		BufferedReader reader = null;
		JSONArray array = new JSONArray();
		ZipEntry ze = null;
		try {
			zf = new ZipFile(filePath);
			ZipInputStream zin = new ZipInputStream(new FileInputStream(
					filePath));
			// ZipEntry 类用于表示 ZIP 文件条目。
			while ((ze = zin.getNextEntry()) != null) {
				if (ze.isDirectory()) {
					continue;
				}
				reader = new BufferedReader(new InputStreamReader(zf
						.getInputStream(ze), "utf-8"));
				String line = null;
				JSONObject obj = null;
				int a = 0;
				String[] dir = null;
				String[] content = null;
				while ((line = reader.readLine()) != null) {
					if(a++==0){
						dir = line.split("\\|");
					}else{
						content = line.split("\\|");
						obj = new JSONObject();
						for(int i=0;i<dir.length;i++){
							try {
								if(i > content.length-1){
									obj.put(dir[i], "");
								}else{
									obj.put(dir[i], content[i]);
								}
							} catch (JSONException e) {
								log.debug(ze.getName()+":读取时出错，具体出错位置："+line);
								e.printStackTrace();
								throw new RuntimeException("读取.zip文件转换至JSON时失败:"+e.getMessage());
							}
						}
						array.put(obj);
					}
				}
				log.debug(ze.getName()+":读取成功");
			}
			return array;
		} catch (IOException e) {
			log.debug("解析ZIP异常：" + e.getMessage());
			e.printStackTrace();
			throw new RuntimeException("解析ZIP异常：" + e.getMessage());
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException e) {
					log.debug("关闭输入流失败:" + e.getMessage());
					e.printStackTrace();
					throw new RuntimeException("关闭输入流失败:" + e.getMessage());
				}
			}
		}
	}

	public static void convertRetToMap(String res, Map<String, String> map) {
		if (StringUtils.isNotBlank(res)) {
			String[] resArray = res.split("&");
			if (resArray.length != 0)
				for (String arrayStr : resArray) {
					if (arrayStr == null)
						continue;
					if ("".equals(arrayStr.trim())) {
						continue;
					}
					int index = arrayStr.indexOf("=");
					if (-1 == index) {
						continue;
					}
					map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
				}
		}
	}

	/**
	 * MD5加盐，加盐后将sign放入集合返回
	 *
	 * @param map
	 * @return
	 */
	public static Map<String, String> addSign(Map<String, String> map,String signkey) {
		String sign = "";
		for (Map.Entry<String, String> e : map.entrySet()) {
			sign += e.getKey() + "=" + e.getValue() + "&";
		}
		log.debug(sign);
		sign += Crypto.GetMessageDigest(signkey, "MD5",
				"UTF-8");
		sign = Crypto.GetMessageDigest(sign, "MD5", "UTF-8");
		map.put("sign", sign);
		return map;
	}


	/**
	 * 响应报文解析
	 *
	 * @param xml
	 * @param signKey
	 * @return String
	 */

	public static String readStringXml(String xml, String signKey, String signMethod,
								String charset) {

		String respMsg = StringUtils.EMPTY;

		if (StringUtils.isBlank(xml))
			return respMsg;

		List<String> strings = Splitter.on('&').splitToList(xml);

		if (strings.size() != 2)
			return respMsg;

		String content = new String(new org.apache.commons.net.util.Base64().decode(StringUtils
				.substringAfter(strings.get(0), "=")), Charset.forName(charset));
		String sign = StringUtils.substringAfter(strings.get(1), "=");

		String calcSign = StringUtils.EMPTY;
		if ("MD5".equalsIgnoreCase(signMethod)) {
			calcSign = Crypto.GetMessageDigest(content + "&"
							+ Crypto.GetMessageDigest(signKey, "MD5", charset), "MD5",
					charset);
		} else if ("RSA".equalsIgnoreCase(signMethod)) {
			if (JsptCertService.validate(content, sign, charset)) {
				calcSign = sign;
			}
		}

		if (!calcSign.equals(sign)) {
			System.out.println("签名错误");
			return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><document>签名错误</document>";
		}

		respMsg = content;
		if (StringUtils.contains(content, "<paynum>")
				&& StringUtils.contains(content, "</paynum>")) {
			String[] searchStrings = StringUtils.substringsBetween(content,
					"<paynum>", "</paynum>");
			String[] replaceStrings = new String[searchStrings.length];
			for (int i = 0; i < replaceStrings.length; i++) {
				try {
					if ("MD5".equals(signMethod)) {
						replaceStrings[i] = EnDe3DES.DeEnycrptDes(
								searchStrings[i], signKey);
					} else {
						replaceStrings[i] = JsptCertService.decryptedData(
								searchStrings[i], charset);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			respMsg = StringUtils.replaceEach(content, searchStrings,
					replaceStrings);
		}

		try {
			Document doc = DocumentHelper.parseText(content);
			Element rootElt = doc.getRootElement();

			String respCode = rootElt.elementText("respCode");
			if ("00".equals(respCode)) {
				System.out.println("单笔查询成功：");
				System.out.println(content);
			} else if ("03".equals(respCode)) {
				System.out.println("无此记录");
			} else if ("04".equals(respCode)) {
				System.out.println("数据格式错误");
			} else if ("05".equals(respCode)) {
				System.out.println("商户订单号,原始流水号不能全部为空");
			} else if ("06".equals(respCode)) {
				System.out.println("签名校验未通过");
			}
		} catch (Exception e) {
			System.out.println("返回的XML文件解析错误!" + e);
			respMsg = "解析失败";
		}

		return respMsg;
	}

	/**
	 * 将文件流写出至指定路径
	 *
	 * @param filePath
	 * @param bytes
	 * @return int 0:写出成功，1：文件已存在，2：文件未找到异常，3：读写错误异常,4:创建文件失败
	 */
	public static int writeFile(JSONObject config,String fileName, byte[] bytes) {
		String path = config.getString("accountFileUrl");
		if (!config.getString("accountFileUrl").endsWith(File.separator)) {
			path = config.getString("accountFileUrl") + File.separator;
		}
		File dir = new File(path);
		if (dir.exists()) {
			File f = new File(path + fileName);
			if (f.exists()) {
				log.debug(fileName+":写出失败，原因：文件已存在");
				return 1;
			}
		} else {
			if (!dir.mkdirs()) {
				log.debug(fileName+":写出失败，原因：创建文件失败");
				return 4;
			}
		}
		OutputStream out = null;
		try {
			out = new FileOutputStream(path + fileName);
			out.write(bytes);
			out.flush();
			log.debug(fileName+":写出成功");
			return 0;
		} catch (FileNotFoundException e) {
			log.debug(fileName+":写出失败，原因：未找到文件..."+e.getMessage());
			return 2;
		} catch (IOException e) {
			log.debug(fileName+":写出失败，原因：读写错误异常..."+e.getMessage());
			return 3;
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					throw new RuntimeException("关闭输出流失败");
				}
			}
		}
	}

}
