package com.aote.ccb_ronglian;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParseXML {
	public static Map<String ,String> xmlToMap(String str) throws FileNotFoundException, DocumentException, UnsupportedEncodingException {
		Map<String,String> map=new HashMap<String, String>();
		// 创建SAXReader
		SAXReader reader = new SAXReader();
		Document document = reader.read(new ByteArrayInputStream(str.getBytes("UTF-8")));
		// 获取根节点
		Element root = document.getRootElement();
		// 获取根节点下所有子节点
		List<Element> list = root.elements();
		List<Element> childList = null;
		for(int i=0;i<list.size();i++){
			childList = list.get(i).elements();
			if(!childList.isEmpty()){
				for (Element e : childList) {
					map.put(e.getName(), e.getTextTrim());
				}
				continue;
			}
			map.put(list.get(i).getName(), list.get(i).getTextTrim());
		}
		return map;
	}

}
