package com.aote.ccb_ronglian;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class JsptCertService {

    protected static Logger logger = LoggerFactory.getLogger(JsptCertService.class);

    /**
     * 敏感信息加密并做base64(卡号，手机号，cvn2,有效期）<br>
     *
     * @param data         送 phoneNo,cvn2,有效期<br>
     * @param encoding<br>
     * @return 加密的密文<br>
     */
    public static String encryptData(String data, String encoding) {
        return JsptCertUtil.encryptData(data, encoding, JsptCertInit.getEncryptCertPublicKey());
    }

    /**
     * 解密并做base64解码(卡号，手机号，cvn2,有效期）
     *
     * @param encryptedData 加密后的字符串
     * @param charsetName   字符集
     * @return 原始字符串
     */
    public static String decryptedData(String encryptedData, String charsetName) {
        return JsptCertUtil.decryptedData(encryptedData, charsetName, JsptCertInit.getSignCertPrivateKey());
    }
    /**
     * 请求报文签名(使用配置文件中配置的私钥证书加密)<br>
     * 功能：对请求报文进行签名,并计算赋值certid,signature字段并返回<br>
     *
     * @param reqData  请求报文map<br>
     * @param encoding 上送请求报文域encoding字段的值<br>
     * @return　签名后的map对象<br>
     */
    public static String sign(Map<String, String> reqData, String encoding) {
        return JsptCertUtil.sign(reqData, encoding);
    }

    /**
     * 验证签名(SHA-1摘要算法)<br>
     *
     * @param rspData  返回报文数据<br>
     * @param encoding 上送请求报文域encoding字段的值<br>
     * @return true 通过 false 未通过<br>
     */
    public static boolean validate(Map<String, String> rspData, String encoding) {
        logger.info("验签处理开始");
        if (StringUtils.isEmpty(encoding)) {
            encoding = JsptCertUtil.DEFAULT_CHARSET;
        }
        String stringSign = rspData.get(JsptCertUtil.sign);
        // 将Map信息转换成key1=value1&key2=value2的形式
        String stringData = JsptCertUtil.coverMap2String(rspData);
        logger.info("待验签返回报文串：[" + stringData + "]");
        try {
            // 验证签名需要用银联发给商户的公钥证书.
            return JsptCertUtil.validateSignBySoft(
                    JsptCertInit.getEncryptCertPublicKey(),
                    JsptCertUtil.base64Decode(stringSign.getBytes(encoding)),
                    JsptCertUtil.sha1X16(stringData,
                            encoding));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public static boolean validate(String rspData, String sign, String encoding) {

        logger.info("验签处理开始");
        if (StringUtils.isEmpty(encoding)) {
            encoding = JsptCertUtil.DEFAULT_CHARSET;
        }
        logger.info("待验签返回报文串：[" + rspData + "]");
        try {
            // 验证签名需要用银联发给商户的公钥证书.
            return JsptCertUtil.validateSignBySoft(JsptCertInit.getEncryptCertPublicKey(),
                    JsptCertUtil.base64Decode(sign.getBytes(encoding)),
                    JsptCertUtil.sha1X16(rspData, encoding));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

}
