package com.aote.ccb_ronglian;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class JsptCertInit {

	protected static Logger logger = LoggerFactory.getLogger(JsptCertInit.class);

	//客户端私钥证书（填写证书路径）
	private static final String ENCRYPTCERT = "D:\\jspt_payconf\\cert\\mch10001.p12";
	//	private static final String ENCRYPTCERT = "/home/jspt/jspt_payconf/mch10001/mch10001.p12";
	//服务端公钥证书（填写证书路径）
	private static final String SIGNCERTPATH = "D:\\jspt_payconf\\cert\\jspt.cer";
//	private static final String SIGNCERTPATH = "/home/jspt/jspt_payconf/mch10001/jspt.cer";

	//私钥证书密码
	private static final String PWD = "mch10001";
//    private static final String PWD = "jspt_test_00000";

	/** 证书容器. */
	private static KeyStore keyStore = null;

	/** 密码加密证书 */
	private static X509Certificate encryptCert = null;

	static {
		init();
	}

	/**
	 * 初始化所有证书.
	 */
	public static void init() {
		addProvider();
		// 单证书模式,初始化配置文件中的签名证书
		initSignCert();
		initEncryptCert();// 初始化加密公钥证书
	}

	/**
	 * 添加签名，验签，加密算法提供者
	 */
	private static void addProvider() {
		if (Security.getProvider("BC") == null) {
			Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
			logger.info("add BC provider");
		} else {
			Security.removeProvider("BC"); // 解决eclipse调试时tomcat自动重新加载时，BC存在不明原因异常的问题。
			Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
			logger.info("re-add BC provider");
		}
	}

	/**
	 * 加载签名证书
	 */
	public static void initSignCert() {
		try {
			keyStore = getKeyInfo(ENCRYPTCERT, PWD,"PKCS12");
			logger.info("InitSignCert Successful. CertId=[" + getSignCertId() + "]");
		} catch (IOException e) {
			logger.error("InitSignCert Error", e);
		}
	}

	/**
	 * 将证书文件读取为证书存储对象
	 * @param pfxkeyfile 证书文件名
	 * @param keypwd 证书密码
	 * @param type 证书类型
	 * @return  证书对象
	 * @throws IOException
	 */
	public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
		logger.info("加载签名证书==>" + pfxkeyfile);
		FileInputStream fis = null;
		try {
			KeyStore ks = KeyStore.getInstance(type, "BC");
			logger.info("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]");
			fis = new FileInputStream(pfxkeyfile);
			char[] nPassword = null;
			nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
			ks.load(fis, nPassword);
			return ks;
		} catch (Exception e) {
			if (Security.getProvider("BC") == null) {
				logger.info("BC Provider not installed.");
			}
			logger.error("getKeyInfo Error", e);
			if ((e instanceof KeyStoreException) && "PKCS12".equals(type)) {
				Security.removeProvider("BC");
			}
			return null;
		} finally {
			if (null != fis)
				fis.close();
		}
	}

	/**
	 * 获取签名证书中的证书序列号（单证书）
	 *
	 * @return 证书的物理编号
	 */
	public static String getSignCertId() {
		try {
			Enumeration<String> aliasenum = keyStore.aliases();
			String keyAlias = null;
			if (aliasenum.hasMoreElements()) {
				keyAlias = aliasenum.nextElement();
			}
			X509Certificate cert = (X509Certificate) keyStore.getCertificate(keyAlias);
			return cert.getSerialNumber().toString();
		} catch (Exception e) {
			logger.error("getSignCertId Error", e);
			return null;
		}
	}

	/**
	 * 加载密码加密证书 目前支持有两种加密
	 */
	private static void initEncryptCert() {
		logger.info("加载敏感信息加密证书==>" + SIGNCERTPATH);
		if (!StringUtils.isEmpty(SIGNCERTPATH)) {
			encryptCert = initCert(SIGNCERTPATH);
			logger.info("LoadEncryptCert Successful");
		} else {
			logger.info("WARN: acpsdk.encryptCert.path is empty");
		}
	}

	private static X509Certificate initCert(String path) {
		X509Certificate encryptCertTemp = null;
		CertificateFactory cf = null;
		FileInputStream in = null;
		try {
			cf = CertificateFactory.getInstance("X.509", "BC");
			in = new FileInputStream(path);
			encryptCertTemp = (X509Certificate) cf.generateCertificate(in);
			// 打印证书加载信息,供测试阶段调试
			logger.info("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
		} catch (CertificateException e) {
			logger.error("InitCert Error", e);
		} catch (FileNotFoundException e) {
			logger.error("InitCert Error File Not Found", e);
		} catch (NoSuchProviderException e) {
			logger.error("LoadVerifyCert Error No BC Provider", e);
		} finally {
			if (null != in) {
				try {
					in.close();
				} catch (IOException e) {
					logger.error(e.toString());
				}
			}
		}
		return encryptCertTemp;
	}

	/**
	 * 获取加密证书公钥.密码加密时需要
	 *
	 * @return
	 */
	public static PublicKey getEncryptCertPublicKey() {
		if (null == encryptCert) {
			if (!StringUtils.isEmpty(SIGNCERTPATH)) {
				encryptCert = initCert(SIGNCERTPATH);
				return encryptCert.getPublicKey();
			} else {
				logger.info("ERROR: acpsdk.encryptCert.path is empty");
				return null;
			}
		} else {
			return encryptCert.getPublicKey();
		}
	}

	/**
	 * 获取签名证书私钥（单证书模式）
	 *
	 * @return
	 */
	public static PrivateKey getSignCertPrivateKey() {
		try {
			if (keyStore == null) {
				initSignCert();
			}

			Enumeration<String> aliasenum = keyStore.aliases();
			String keyAlias = null;
			if (aliasenum.hasMoreElements()) {
				keyAlias = aliasenum.nextElement();
			}
			PrivateKey privateKey = (PrivateKey) keyStore.getKey(keyAlias, PWD.toCharArray());
			return privateKey;
		} catch (KeyStoreException e) {
			logger.error("getSignCertPrivateKey Error", e);
			return null;
		} catch (UnrecoverableKeyException e) {
			logger.error("getSignCertPrivateKey Error", e);
			return null;
		} catch (NoSuchAlgorithmException e) {
			logger.error("getSignCertPrivateKey Error", e);
			return null;
		}
	}

}
