package com.aote.ccb_ronglian;

import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import javax.ws.rs.WebApplicationException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * 建行扫码支付下单
 * @author Lenovo
 *
 */
@Component
public class CcbUtil {


    static Logger log = Logger.getLogger(CcbUtil.class);

    /**
     * 建行支付请求
     * @param data pc端传回付款金额，用户支付码，操作人id等
     * @return
     */
    public JSONObject bankPayOnLine(JSONObject config,JSONObject data) {
        JSONObject obj = null;
        try {
            log.debug("在线支付传入参数:"+data);
            obj = new JSONObject();
            //支付金额
            String f_payamount = data.getString("f_payamount");
            //支付码
            String f_paycode = data.getString("f_paycode");
            //操作人id
            String f_operatorid = data.getString("f_operatorid");
            //用户姓名
            String f_user_name = data.getString("f_user_name");
            //气量
            String f_pregas = data.getString("f_pregas");
            //地址
            String f_address = data.getString("f_address");
            //操作人
            String f_operator = data.getString("f_operator");
            //用户编号
            String f_userid = data.getString("f_userid");
            // 清空JSONObject
            obj = new JSONObject();
            obj.put("f_userid",data.getString("f_userid"));
//            obj.put("f_filiale",data.getString("f_filiale"));
            if (f_paycode.startsWith("1")) {
                obj.put("f_paymethod", "微信");
            } else {
                obj.put("f_paymethod", "支付宝");
            }
            Map<String, String> map = getPayDataMap(f_payamount, f_paycode,
                    f_operatorid,f_user_name, f_pregas, f_address,f_operator,f_userid,config.getString("merchId"));
            map = Tool.addSign(map,config.getString("signkey"));
            String orderNumber = map.get("orderNumber");
            obj.put("f_total_fee",
                    new BigDecimal(map.get("orderAmount")).divide(
                            new BigDecimal(100)).toString());
            log.debug("发起交易请求参数map集合：" + map.toString());
            String response = HttpClientUtil.httpPost(config.getString("payUrl"),
                    map, "UTF-8");
            if (StringUtils.isNotBlank(response)) {
                Map<String, String> responseMap = Maps.newHashMap();
                Tool.convertRetToMap(response, responseMap);
                obj.put("f_return_code", responseMap.get("respCode"));
                obj.put("f_trade_type", "付款");
                if ("00".equals(responseMap.get("respCode"))) {//支付成功
                    log.debug("支付同步响应报文"+response);
                    obj.put("f_bill_state", "成功");
                    obj.put("f_out_trade_no", responseMap.get("orderNumber"));
                    obj.put("f_transaction_id", responseMap.get("qid"));
                    Date f_paytime = new SimpleDateFormat("yyyyMMddHHmmss").parse(map.get("orderTime"));
                    obj.put("f_time_end", new SimpleDateFormat(
                            "yyyyMMddHHmmss").format(f_paytime));
                } else if ("99".equals(responseMap.get("respCode"))){//支付状态未知
                    log.debug("订单号:"+orderNumber+"状态未知,即将发起单笔交易查询。");
                    Map<String, String> resultMap = sendPayOrderQuery(config,orderNumber);
                    if ("00".equals(resultMap.get("respCode"))) {//查询成功
                        log.debug("订单号:"+orderNumber+",发起单笔交易查询响应成功。");
                        if("1".equals(resultMap.get("state"))){//交易成功
                            obj.put("f_bill_state", "成功");
                            obj.put("f_out_trade_no", resultMap.get("orderNumber"));
                            obj.put("f_transaction_id", responseMap.get("qid"));
                        }else if("2".equals(resultMap.get("state"))){//交易失败
                            obj.put("f_bill_state", "失败");
                            obj.put("message", resultMap.get("respMsg"));
                            log.debug("订单号:"+orderNumber+"支付失败，原因："+responseMap.get("respMsg"));
                        }else if("0".equals(resultMap.get("state"))){//交易处理中，线程沉睡2分钟,重新查询一次
                            log.debug("订单号:"+orderNumber+"状态未知,线程沉睡2分钟后将再次发起单笔交易查询。");
                            Thread.sleep(1000*60*2);
                            Map<String, String> resultMap2 = sendPayOrderQuery(config,orderNumber);//重新发起查询请求
                            if ("00".equals(resultMap2.get("respCode"))) {
                                if("1".equals(resultMap2.get("state"))){//成功
                                    obj.put("f_bill_state", "成功");
                                    obj.put("f_out_trade_no", resultMap2.get("orderNumber"));
                                    obj.put("f_transaction_id", responseMap.get("qid"));
                                }else{//除1外其余状态判定为失败
                                    obj.put("f_bill_state", "失败");
                                    obj.put("message", responseMap.get("respMsg"));
                                    log.debug("订单号:"+orderNumber+"支付失败，原因："+responseMap.get("respMsg"));
                                }
                            }
                        }
                    } else {//失败
                        obj.put("f_bill_state", "失败");
                        obj.put("message", responseMap.get("respMsg"));
                        log.debug("订单号:"+orderNumber+"支付失败，原因："+responseMap.get("respMsg"));
                    }

                } else {//支付失败
                    obj.put("f_bill_state", "失败");
                    obj.put("message", responseMap.get("respMsg"));
                    log.debug("订单号:"+orderNumber+"支付失败，原因："+responseMap.get("respMsg"));
                }
            } else {
                obj.put("f_bill_state", "失败");
                obj.put("message", "银行未响应！");
                log.debug("订单号:"+orderNumber+"发起支付请求银行未响应");
            }
        } catch (Exception e) {
            throw new WebApplicationException(400);
        }
        return obj;
    }

    /**
     * 发起单笔支付交易查询请求
     * @param orderNumber
     * @return
     * @throws FileNotFoundException
     * @throws DocumentException
     * @throws UnsupportedEncodingException
     */
    private Map<String, String> sendPayOrderQuery(JSONObject config,String orderNumber)
            throws FileNotFoundException, DocumentException,
            UnsupportedEncodingException {
        Map<String, String> httpMap = Maps.newTreeMap();
        httpMap.put("version", "2.0");
        httpMap.put("charset", "UTF-8");
        httpMap.put("signMethod", "MD5");
        httpMap.put("transType", "01");
        httpMap.put("payType", "B2C");
        // 商户编号
        httpMap.put("merId", config.getString("merchId"));
        // 查询时间(当前交易发起时间，不能与当前时间相差超过 10 分钟)
        httpMap.put("queryTime", new SimpleDateFormat(
                "yyyyMMddHHmmss").format(new Date()));
        // 商户订单号(最长 32 位,商户需要保证订单的唯一性)
        httpMap.put("orderNumber", orderNumber);
        httpMap = Tool.addSign(httpMap,config.getString("signkey"));
        String httpPost = HttpClientUtil.httpPost(config.getString("queryUrl"), httpMap, "UTF-8");
        String xml = Tool.readStringXml(httpPost, config.getString("signkey"),"MD5", "UTF-8");
        Map<String, String> resultMap = ParseXML.xmlToMap(xml);
        return resultMap;
    }


    /**
     *
     * @param payamount
     *            支付金额
     * @param paycode
     *            支付码
     * @param operatorid
     *            操作员id
     * @param merchId
     *            商户编号
     *
     * @return
     */
    private Map<String, String> getPayDataMap(String payamount, String paycode,
                                              String operatorid,String f_user_name, String f_pregas,
                                              String f_address, String f_operator, String f_userid,
                                               String merchId) {
        Map<String, String> map = Maps.newTreeMap();
        try {
            //版本号
            map.put("version", "2.0");
            map.put("charset", "UTF-8");
            //签名方法
            map.put("signMethod", "MD5");
            //交易类型
            map.put("transType", "01");
            //支付接口类型
            map.put("payType", "B2C");
            // 商户编号(咸阳天然气：20068)
            map.put("merId", merchId);
            // 交易时间
            map.put("orderTime", new SimpleDateFormat("yyyyMMddHHmmss")
                    .format(new Date()));
            // 商户订单号(最长 32 位,商户需要保证订单的唯一性)
            map.put("orderNumber", operatorid
                    + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())
                    .toString());
            // 订单金额(单位：分)
            BigDecimal orderAmount = new BigDecimal(Double
                    .parseDouble(payamount)
                    * 100 + "").setScale(0, BigDecimal.ROUND_HALF_UP);
            map.put("orderAmount", orderAmount.toString());
            // 交易币种 (人民币：156)
            map.put("orderCurrency", "156");
            // 银行编码(微信：991；支付宝：992)
            if (paycode.startsWith("1")) {
                map.put("defaultBankNumber", "991");
            } else {
                map.put("defaultBankNumber", "992");
            }
            // 持卡人IP(填写商户服务器端出口IP)
            map.put("customerIp", "127.0.0.1");
            // 支付场景(被扫模式：01,主扫模式：02)
            map.put("scence", "01");
            // 付款码
            map.put("authCode", paycode);
            map.put("merReserved1", f_userid+'/'+f_user_name + '/' + f_address);
            map.put("merReserved2", f_pregas);
            map.put("merReserved3", f_operator);
        } catch (Exception e) {
            log.debug("getPayDataMap错误:"+e.getMessage());
            throw new RuntimeException("getPayDataMap():获取支付Map出错");
        }
        return map;
    }

    /**
     * 获取对账文件下载Map集合
     *
     * @return
     */
    public static Map<String, String> getDownFileMap(String billDate,
                                               String billType, String fileName, String merId) {
        Map<String, String> map = Maps.newTreeMap();
        map.put("version", "2.0");
        map.put("charset", "UTF-8");
        map.put("signMethod", "MD5");
        map.put("transCode", "F002");
        map.put("merId", merId);
        map.put("billDate", billDate);
        map.put("billType", billType);
        map.put("fileType", "01");
        map.put("transTime", new SimpleDateFormat("yyyyMMddHHmmss")
                .format(new Date()));
        map.put("fileName", fileName);
        return map;
    }

}
