package com.aote.abcauth;


import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.ebus.*;
import com.af.plugins.Base64Utils;
import org.apache.log4j.Logger;
import org.json.JSONObject;


public class abcauthUtil {

    private  static final Logger logger = Logger.getLogger(abcauthUtil.class);
    /**
     * 支付下单
     * @param pay_type
     * @param param
     * @return
     */
    public static JSONObject getPayCode(String pay_type, JSONObject param){
        if("wx".equals(pay_type)){
            return getPayCode_wx(param);
        }else if("ali".equals(pay_type)){
            return getPayCode_ali(param);
        }else if("union".equals(pay_type)){
            return getPayCode_unionPay(param);
        }else {
            return null;
        }
    }


    /**
     * 微信支付下单
     * @return
     */

    private static JSONObject getPayCode_wx(JSONObject param){

        UnifiedPaymentRequest unifiedPaymentRequest = new UnifiedPaymentRequest();


        unifiedPaymentRequest.dicOrder.put("PayTypeID",param.get("PayTypeID"));
        unifiedPaymentRequest.dicOrder.put("OrderDate",param.getString("OrderDate"));
        unifiedPaymentRequest.dicOrder.put("OrderTime",param.getString("OrderTime"));
        unifiedPaymentRequest.dicOrder.put("OrderDesc",param.getString("OrderDesc"));
        if(param.has("orderTimeountDate")) {
            unifiedPaymentRequest.dicOrder.put("orderTimeountDate", param.getString("orderTimeountDate"));
        }


        unifiedPaymentRequest.dicOrder.put("OrderNo",param.getString("OrderNo"));
        unifiedPaymentRequest.dicOrder.put("CurrencyCode",param.getString("CurrencyCode"));
        unifiedPaymentRequest.dicOrder.put("OrderAmount",param.getString("OrderAmount"));
        if(param.has("OrderURL")){
            unifiedPaymentRequest.dicOrder.put("OrderURL",param.getString("OrderURL"));
        }
        unifiedPaymentRequest.dicOrder.put("Fee",param.getString("Fee"));
        unifiedPaymentRequest.dicOrder.put("AccountNo",param.getString("AccountNo"));
        if(param.has("ReceiverAddress")){
            unifiedPaymentRequest.dicOrder.put("ReceiverAddress",param.getString("ReceiverAddress"));
        }
        unifiedPaymentRequest.dicOrder.put("InstallmentMark", param.getString("InstallmentMark"));
        if(param.has("InstallmentNum")) {
            unifiedPaymentRequest.dicOrder.put("InstallmentNum",param.getString("InstallmentNum"));
        }

        unifiedPaymentRequest.dicRequest.put("CommodityType",param.getString("CommodityType"));
        unifiedPaymentRequest.dicRequest.put("PaymentType",param.getString("PaymentType"));

        unifiedPaymentRequest.dicRequest.put("PaymentLinkType",param.getString("PaymentLinkType"));
        unifiedPaymentRequest.dicRequest.put("NotifyType",param.getString("NotifyType"));
        unifiedPaymentRequest.dicRequest.put("ResultNotifyURL",param.getString("ResultNotifyURL"));
        unifiedPaymentRequest.dicRequest.put("IsBreakAccount",param.getString("IsBreakAccount"));


        JSON json = unifiedPaymentRequest.postRequest();

        logger.info("支付返回 json = " + json.getIJsonString());
        JSONObject jsonObject = new JSONObject();

        if( "0000".equals(json.GetKeyValue("ReturnCode"))){
            jsonObject.put("f_bill_state",0);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
            jsonObject.put("ThirdOrderNo", json.GetKeyValue("ThirdOrderNo"));
            jsonObject.put("f_mch_id",json.GetKeyValue("MerchantID"));
        }else {
            logger.info("农行下单错误，错误返回代码 ："+ json.GetKeyValue("ReturnCode")  +
                    " , 错误信息为：" + json.GetKeyValue("ErrorMessage"));
            jsonObject.put("f_bill_state",2);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
        }

        return jsonObject;

    }


    /**
     * 支付宝下单
     * @param param
     * @return
     */

    private static JSONObject getPayCode_ali(JSONObject param){

        AlipayRequest alipayRequest = new AlipayRequest();

        alipayRequest.dicOrder.put("PayTypeID",param.get("PayTypeID"));
        alipayRequest.dicOrder.put("OrderDate",param.getString("OrderDate"));
        alipayRequest.dicOrder.put("OrderTime",param.getString("OrderTime"));
        alipayRequest.dicOrder.put("OrderDesc",param.getString("OrderDesc"));
        if(param.has("orderTimeountDate")) {
            alipayRequest.dicOrder.put("orderTimeountDate", param.getString("orderTimeountDate"));
        }

        alipayRequest.dicOrder.put("TimeoutExpress",param.getString("TimeoutExpress"));

        alipayRequest.dicOrder.put("OrderNo",param.getString("OrderNo"));
        alipayRequest.dicOrder.put("CurrencyCode",param.getString("CurrencyCode"));
        alipayRequest.dicOrder.put("OrderAmount",param.getString("OrderAmount"));
        if(param.has("OrderURL")){
            alipayRequest.dicOrder.put("OrderURL",param.getString("OrderURL"));
        }
        alipayRequest.dicOrder.put("Fee",param.getString("Fee"));
        alipayRequest.dicOrder.put("AccountNo",param.getString("AccountNo"));

        if(param.has("ReceiverAddress")){
            alipayRequest.dicOrder.put("ReceiverAddress",param.getString("ReceiverAddress"));
        }
        alipayRequest.dicOrder.put("InstallmentMark", param.getString("InstallmentMark"));
        if(param.has("InstallmentNum")) {
            alipayRequest.dicOrder.put("InstallmentNum",param.getString("InstallmentNum"));
        }


        alipayRequest.dicRequest.put("CommodityType",param.getString("CommodityType"));
        alipayRequest.dicRequest.put("PaymentType",param.getString("PaymentType"));

        alipayRequest.dicRequest.put("PaymentLinkType",param.getString("PaymentLinkType"));
        alipayRequest.dicRequest.put("NotifyType",param.getString("NotifyType"));
        alipayRequest.dicRequest.put("ResultNotifyURL",param.getString("ResultNotifyURL"));
        alipayRequest.dicRequest.put("IsBreakAccount",param.getString("IsBreakAccount"));


        JSON json = alipayRequest.postRequest();

        logger.info("支付返回 json = " + json.getIJsonString());

        JSONObject jsonObject = new JSONObject();

        if( "0000".equals(json.GetKeyValue("ReturnCode"))){
            jsonObject.put("f_bill_state",0);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
            jsonObject.put("ThirdOrderNo", json.GetKeyValue("ThirdOrderNo"));
            jsonObject.put("f_mch_id",json.GetKeyValue("MerchantID"));
        }else {
            logger.info("农行下单错误，错误返回代码 ："+ json.GetKeyValue("ReturnCode")  +
                    " , 错误信息为：" + json.GetKeyValue("ErrorMessage"));
            jsonObject.put("f_bill_state",2);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
        }



        return jsonObject;
    }

    /**
     * 掌银下单
     * @param param
     * @return
     */
    private static JSONObject getPayCode_unionPay(JSONObject param){

        QRPayCode qrPayCode = new QRPayCode();

        qrPayCode.dicOrder.put("PayTypeID",param.getString("PayTypeID"));
        qrPayCode.dicOrder.put("QRPayCode",param.getString("QRPayCode"));
        qrPayCode.dicOrder.put("OrderDate",param.getString("OrderDate"));
        qrPayCode.dicOrder.put("OrderTime",param.getString("OrderTime"));
        qrPayCode.dicOrder.put("OrderDesc",param.getString("OrderDesc"));
        if(param.has("orderTimeountDate")) {
            qrPayCode.dicOrder.put("orderTimeountDate", param.getString("orderTimeountDate"));
        }

        qrPayCode.dicOrder.put("TimeoutExpress",param.getString("TimeoutExpress"));

        qrPayCode.dicOrder.put("OrderNo",param.getString("OrderNo"));
        qrPayCode.dicOrder.put("CurrencyCode",param.getString("CurrencyCode"));
        qrPayCode.dicOrder.put("OrderAmount",param.getString("OrderAmount"));
        if(param.has("OrderURL")){
            qrPayCode.dicOrder.put("OrderURL",param.getString("OrderURL"));
        }
        qrPayCode.dicOrder.put("Fee",param.getString("Fee"));
        qrPayCode.dicOrder.put("AccountNo",param.getString("AccountNo"));
        if(param.has("ReceiverAddress")){
            qrPayCode.dicOrder.put("ReceiverAddress",param.getString("ReceiverAddress"));
        }
        qrPayCode.dicOrder.put("InstallmentMark", param.getString("InstallmentMark"));
        if(param.has("InstallmentNum")) {
            qrPayCode.dicOrder.put("InstallmentNum",param.getString("InstallmentNum"));
        }


        qrPayCode.dicOrder.put("CommodityType",param.getString("CommodityType"));

        qrPayCode.dicRequest.put("PaymentType",param.getString("PaymentType"));

        qrPayCode.dicRequest.put("PaymentLinkType",param.getString("PaymentLinkType"));
        qrPayCode.dicRequest.put("NotifyType",param.getString("NotifyType"));
        qrPayCode.dicRequest.put("ResultNotifyURL",param.getString("ResultNotifyURL"));
        qrPayCode.dicRequest.put("IsBreakAccount",param.getString("IsBreakAccount"));

        JSON json = qrPayCode.postRequest();

        JSONObject jsonObject = new JSONObject();

        logger.info("支付返回 json = " + json.getIJsonString());
        if("0000".equals(json.GetKeyValue("ReturnCode"))){
            logger.info("农行下单成功返回： " + json.getIJsonString());
            jsonObject.put("f_bill_state",0);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
            jsonObject.put("f_mch_id","");
            jsonObject.put("ThirdOrderNo", "");
        }else {
            logger.error("农行下单错误，错误返回代码 ："+ json.GetKeyValue("ReturnCode")  +
                    " , 错误信息为：" + json.GetKeyValue("ErrorMessage"));
            jsonObject.put("f_bill_state",2);
            jsonObject.put("msg", json.GetKeyValue("ErrorMessage"));
        }

        return jsonObject;

    }


    /**
     *  下单查询（）
     */
    public  static JSONObject QueryOrder(JSONObject jsonObject) {
        QueryOrderRequest queryOrderRequest = new QueryOrderRequest();

        queryOrderRequest.queryRequest.put("PayTypeID", jsonObject.getString("PayTypeID"));
        queryOrderRequest.queryRequest.put("OrderNo", jsonObject.getString("OrderNo"));
        queryOrderRequest.queryRequest.put("QueryDetail", jsonObject.getString("QueryDetail"));


        JSON json = queryOrderRequest.postRequest();

        JSONObject jsonObject1 = new JSONObject();

        if ("0000".equals(json.GetKeyValue("ReturnCode"))) {

            String order = json.GetKeyValue("Order");

            String result =  Base64Utils.decode(order);

            JSON json1 = new JSON(result);

            logger.info("农行查询订单返回 =========>"+ json1.getIJsonString());


            String state = json1.GetKeyValue("Status");

            switch (state) {
                case "01":
                    jsonObject1.put("state", 1);
                    break;
                case "03":
                case "04":
                    jsonObject1.put("state", 0);
                    break;
                case "05":
                    jsonObject1.put("state", 3);
                    break;
                case "02":
                case "99":
                    jsonObject1.put("state", 4);
                    break;
                default:
                    break;
            }
        }else {
            logger.error("农行查询订单错误，错误返回代码 ："+ json.GetKeyValue("ReturnCode")  +
                    " , 错误信息为：" + json.GetKeyValue("ErrorMessage"));
            jsonObject1.put("state", 4);
        }
        jsonObject1.put("msg", json.GetKeyValue("ErrorMessage"));
        return jsonObject1;
    }

    public static JSONObject getReturnJson(String str){

        JSONObject jsonObject = new JSONObject();
        try {
            PaymentResult  paymentResult = new PaymentResult(str);

            if(paymentResult.isSuccess()){
                logger.info("解析接收数据成功，返回数据为 ： "+ paymentResult.getResponseMessage() );
                jsonObject.put("state",0);
                jsonObject.put("f_out_trade_no", paymentResult.getValue("OrderNo"));
                jsonObject.put("f_transaction_id",paymentResult.getValue("ThirdOrderNo"));
                jsonObject.put("f_end_time",paymentResult.getValue("HostDate") +" " +
                        paymentResult.getValue("HostTime"));
                jsonObject.put("f_user_code",paymentResult.getValue("iRspRef"));

            }else {
                logger.error("农行查询订单错误，错误返回代码 ："+ paymentResult.getReturnCode()  +
                        " , 错误信息为：" + paymentResult.getErrorMessage());
                jsonObject.put("state",1);
            }
            jsonObject.put("msg", paymentResult.getErrorMessage());

        } catch (TrxException e) {
            e.printStackTrace();
            logger.error("解析数据出错，错误信息： " + e.getMessage());
            jsonObject.put("state",2);
            jsonObject.put("msg", "数据解析出错");
        }
        return  jsonObject;
    }


    public static JSONObject refund(JSONObject param){

        JSONObject jsonObject = new JSONObject();

        RefundRequest refundRequest = new RefundRequest();

        refundRequest.dicRequest.put("OrderDate",param.getString("OrderDate"));
        refundRequest.dicRequest.put("OrderTime",param.getString("OrderTime"));
        refundRequest.dicRequest.put("OrderNo",param.getString("OrderNo"));
        refundRequest.dicRequest.put("NewOrderNo",param.getString("NewOrderNo"));
        refundRequest.dicRequest.put("CurrencyCode",param.getString("CurrencyCode"));
        refundRequest.dicRequest.put("TrxAmount",param.getString("TrxAmount"));

        JSON json = refundRequest.postRequest();

         if("0000".equals(json.GetKeyValue("ReturnCode"))){

            logger.info("退款返回成功 ，返回数据：" + json.getIJsonString());

            jsonObject.put("state" , 0);
            jsonObject.put("f_out_trade_no", json.GetKeyValue("OrderNo"));
            jsonObject.put("f_transaction_id",json.GetKeyValue("ThirdOrderNo"));
            jsonObject.put("f_end_time",json.GetKeyValue("HostDate") +" " +
                    json.GetKeyValue("HostTime"));
            jsonObject.put("f_user_code",json.GetKeyValue("iRspRef"));

        }else {
            logger.error("农行查询订单错误，错误返回代码 ："+ json.GetKeyValue("ReturnCode")  +
                    " , 错误信息为：" + json.GetKeyValue("ErrorMessage"));
            jsonObject.put("state",1);
        }
        jsonObject.put("msg",json.GetKeyValue("ErrorMessage"));
        return jsonObject;
    }
}
